/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget.recyclerviewhelper;

import android.graphics.Canvas;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHAdapter;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHViewHolder;

public class RVHItemTouchHelperCallback
extends ItemTouchHelper.Callback {
    private final RVHAdapter mAdapter;
    private final boolean isLongPressDragEnabled;
    private final boolean isItemViewSwipeEnabledLeft;
    private final boolean isItemViewSwipeEnabledRight;

    public RVHItemTouchHelperCallback(RVHAdapter adapter, boolean isLongPressDragEnabled, boolean isItemViewSwipeEnabledLeft, boolean isItemViewSwipeEnabledRight) {
        this.mAdapter = adapter;
        this.isItemViewSwipeEnabledLeft = isItemViewSwipeEnabledLeft;
        this.isItemViewSwipeEnabledRight = isItemViewSwipeEnabledRight;
        this.isLongPressDragEnabled = isLongPressDragEnabled;
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        int swipeFlags;
        int dragFlags;
        if (!(viewHolder instanceof RVHViewHolder)) {
            dragFlags = 0;
            swipeFlags = 0;
        } else {
            dragFlags = 3;
            swipeFlags = this.mAdapter.isCanSwipe() ? (this.isItemViewSwipeEnabledLeft && this.isItemViewSwipeEnabledRight ? 48 : (this.isItemViewSwipeEnabledRight ? 16 : 32)) : 0;
        }
        return ItemTouchHelper.Callback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
    }

    public boolean canDropOver(RecyclerView recyclerView, RecyclerView.ViewHolder current, RecyclerView.ViewHolder target) {
        return current.getItemViewType() == target.getItemViewType();
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
        this.mAdapter.onItemMove(source.getAdapterPosition(), target.getAdapterPosition());
        return true;
    }

    public boolean isLongPressDragEnabled() {
        return this.isLongPressDragEnabled;
    }

    public boolean isItemViewSwipeEnabled() {
        return this.isItemViewSwipeEnabledLeft || this.isItemViewSwipeEnabledRight;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        this.mAdapter.onItemDismiss(viewHolder.getAdapterPosition(), direction);
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState != 0 && viewHolder instanceof RVHViewHolder) {
            RVHViewHolder itemViewHolder = (RVHViewHolder)viewHolder;
            itemViewHolder.onItemSelected(actionState);
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        if (viewHolder instanceof RVHViewHolder) {
            RVHViewHolder itemViewHolder = (RVHViewHolder)viewHolder;
            itemViewHolder.onItemClear();
        }
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        if (actionState == 1) {
            viewHolder.itemView.setTranslationX(dX);
        } else {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
    }
}

