/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;
import java.util.ArrayList;

public class ZMVerticalFlowLayout
extends LinearLayout {
    private static final String TAG = ZMVerticalFlowLayout.class.getSimpleName();
    private int mGravityHolder;
    private ArrayList<Integer> mColumnWidths = new ArrayList();

    public ZMVerticalFlowLayout(Context context) {
        super(context);
    }

    public ZMVerticalFlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ZMVerticalFlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @SuppressLint(value={"NewApi"})
    public ZMVerticalFlowLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setGravity(int gravity) {
        super.setGravity(gravity);
        if (this.mGravityHolder != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravityHolder = gravity;
        }
    }

    public int getGravity() {
        return this.mGravityHolder;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthParent = View.MeasureSpec.getSize((int)widthMeasureSpec) - paddingLeft - paddingRight;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightParent = View.MeasureSpec.getSize((int)heightMeasureSpec) - paddingTop - paddingBottom;
        int countItemsInCurrentColumn = 0;
        int maxWidthInCurrentColumn = 0;
        int totalWidth = 0;
        int totalHeightOfCurrentColumn = 0;
        int maxHeightOfColumns = 0;
        int count = this.getChildCount();
        this.mColumnWidths.clear();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            try {
                this.measureChild(child, View.MeasureSpec.makeMeasureSpec((int)widthParent, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)heightParent, (int)Integer.MIN_VALUE));
            }
            catch (Exception exception) {
                // empty catch block
            }
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)child.getLayoutParams();
            int lMargin = 0;
            int tMargin = 0;
            int rMargin = 0;
            int bMargin = 0;
            if (layoutParams != null) {
                lMargin = layoutParams.leftMargin;
                tMargin = layoutParams.topMargin;
                rMargin = layoutParams.rightMargin;
                bMargin = layoutParams.bottomMargin;
            }
            int width = child.getMeasuredWidth() + lMargin + rMargin;
            int heightRemain = heightParent - totalHeightOfCurrentColumn;
            int height = child.getMeasuredHeight() + tMargin + bMargin;
            if (heightRemain < height && countItemsInCurrentColumn > 0) {
                maxHeightOfColumns = maxHeightOfColumns > totalHeightOfCurrentColumn ? maxHeightOfColumns : totalHeightOfCurrentColumn;
                totalWidth += maxWidthInCurrentColumn;
                this.mColumnWidths.add(maxWidthInCurrentColumn);
                countItemsInCurrentColumn = 0;
                maxWidthInCurrentColumn = 0;
                totalHeightOfCurrentColumn = 0;
            }
            ++countItemsInCurrentColumn;
            maxWidthInCurrentColumn = maxWidthInCurrentColumn > width ? maxWidthInCurrentColumn : width;
            totalHeightOfCurrentColumn += height;
        }
        maxHeightOfColumns = maxHeightOfColumns > totalHeightOfCurrentColumn ? maxHeightOfColumns : totalHeightOfCurrentColumn;
        this.mColumnWidths.add(maxWidthInCurrentColumn);
        this.setMeasuredDimension((widthMode == 0x40000000 ? widthParent : (totalWidth += maxWidthInCurrentColumn)) + paddingLeft + paddingRight, (heightMode == 0x40000000 ? heightParent : maxHeightOfColumns) + paddingTop + paddingBottom);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int gravity = this.getGravity();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int heightParent = b - t - paddingTop - paddingBottom;
        int lOffset = paddingLeft;
        int tOffset = paddingTop;
        int countItemsInCurrentColumn = 0;
        int maxWidthInCurrentColumn = 0;
        int totalHeightOfCurrentColumn = 0;
        int count = this.getChildCount();
        int colIdx = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)child.getLayoutParams();
            int lMargin = 0;
            int tMargin = 0;
            int rMargin = 0;
            int bMargin = 0;
            if (layoutParams != null) {
                lMargin = layoutParams.leftMargin;
                tMargin = layoutParams.topMargin;
                rMargin = layoutParams.rightMargin;
                bMargin = layoutParams.bottomMargin;
            }
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int childTotalWidth = lMargin + width + rMargin;
            int heightRemain = heightParent - totalHeightOfCurrentColumn;
            int childTotalHeight = tMargin + height + bMargin;
            if (heightRemain < childTotalHeight && countItemsInCurrentColumn > 0) {
                lOffset += maxWidthInCurrentColumn;
                tOffset = paddingTop;
                countItemsInCurrentColumn = 0;
                maxWidthInCurrentColumn = 0;
                totalHeightOfCurrentColumn = 0;
                ++colIdx;
            }
            ++countItemsInCurrentColumn;
            int left = 0;
            if (this.mColumnWidths.size() > colIdx) {
                int widthColumn = this.mColumnWidths.get(colIdx);
                int hGravity = gravity & 0x800007;
                int layoutDirection = this.getLayoutDirection();
                switch (Gravity.getAbsoluteGravity((int)hGravity, (int)layoutDirection)) {
                    case 5: {
                        left = lOffset + widthColumn - rMargin - width;
                        break;
                    }
                    case 1: {
                        left = lOffset + lMargin + (widthColumn - lMargin - rMargin - width) / 2;
                        break;
                    }
                    default: {
                        left = lOffset + lMargin;
                        break;
                    }
                }
            } else {
                left = lOffset + lMargin;
            }
            child.layout(left, tOffset + tMargin, left + width, tOffset + tMargin + height);
            tOffset += tMargin + height + bMargin;
            maxWidthInCurrentColumn = maxWidthInCurrentColumn > childTotalWidth ? maxWidthInCurrentColumn : childTotalWidth;
            totalHeightOfCurrentColumn += tMargin + height + bMargin;
        }
    }
}

