/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.UIUtil;

public class ZMUpArrowView
extends View {
    private Path mPath = new Path();
    private Paint mPaint = new Paint();
    private int mArrowWidth;
    private int mLeftDelta;
    private int mDividerHeight;

    public ZMUpArrowView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ZMUpArrowView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ZMUpArrowView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        int paintColor = this.getResources().getColor(R.color.zm_listview_divider);
        this.mDividerHeight = UIUtil.dip2px(context, 1.0f);
        this.mArrowWidth = UIUtil.dip2px(context, 12.0f);
        this.mLeftDelta = UIUtil.dip2px(context, 24.0f);
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ZMUpArrowView);
            paintColor = ta.getColor(R.styleable.ZMUpArrowView_zm_up_arrow_divider_color, paintColor);
            this.mDividerHeight = (int)ta.getDimension(R.styleable.ZMUpArrowView_zm_up_arrow_divider_height, (float)this.mDividerHeight);
            this.mArrowWidth = (int)ta.getDimension(R.styleable.ZMUpArrowView_zm_up_arrow_width, (float)this.mArrowWidth);
            this.mLeftDelta = (int)ta.getDimension(R.styleable.ZMUpArrowView_zm_up_arrow_left_delta, (float)this.mLeftDelta);
            ta.recycle();
        }
        this.mPaint.setColor(paintColor);
        this.mPaint.setStrokeWidth((float)this.mDividerHeight);
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPath.reset();
        int width = this.getWidth();
        int height = this.getHeight() - this.mDividerHeight;
        this.mPath.moveTo(0.0f, (float)height);
        this.mPath.lineTo((float)(this.mLeftDelta - this.mArrowWidth / 2), (float)height);
        this.mPath.lineTo((float)this.mLeftDelta, 0.0f);
        this.mPath.lineTo((float)(this.mLeftDelta + this.mArrowWidth / 2), (float)height);
        this.mPath.lineTo((float)width, (float)height);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public void setmLeftDelta(int mLeftDelta) {
        this.mLeftDelta = mLeftDelta;
        this.postInvalidate();
    }
}

