/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class ZMToolbarLayout
extends ViewGroup {
    private static final String TAG = ZMToolbarLayout.class.getSimpleName();

    public ZMToolbarLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ZMToolbarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ZMToolbarLayout(Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View child;
        int i;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthParent = View.MeasureSpec.getSize((int)widthMeasureSpec) - paddingLeft - paddingRight;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightParent = View.MeasureSpec.getSize((int)heightMeasureSpec) - paddingTop - paddingBottom;
        int count = this.getChildCount();
        int countNoneGone = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            View child2 = this.getChildAt(i2);
            if (child2.getVisibility() == 8) continue;
            ++countNoneGone;
        }
        int unitWidth = widthParent;
        if (countNoneGone != 0) {
            unitWidth = widthParent / countNoneGone;
        }
        int unitHeight = heightParent;
        int maxWidth = 0;
        int maxHeight = 0;
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            try {
                this.measureChild(child, View.MeasureSpec.makeMeasureSpec((int)unitWidth, (int)widthMode), View.MeasureSpec.makeMeasureSpec((int)heightParent, (int)heightMode));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            maxWidth = maxWidth > width ? maxWidth : width;
            maxHeight = maxHeight > height ? maxHeight : height;
        }
        if (widthMode != 0x40000000) {
            unitWidth = maxWidth;
        }
        if (heightMode != 0x40000000) {
            unitHeight = maxHeight;
        }
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            try {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)unitWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)unitHeight, (int)0x40000000));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setMeasuredDimension((widthMode == 0x40000000 ? widthParent : unitWidth * count) + paddingLeft + paddingRight, (heightMode == 0x40000000 ? heightParent : unitHeight) + paddingTop + paddingBottom);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View child;
        int count = this.getChildCount();
        int lOffset = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int rightEdge = this.getWidth() - this.getPaddingRight();
        int lastVisibe = -1;
        for (lastVisibe = count - 1; lastVisibe >= 0 && (child = this.getChildAt(lastVisibe)).getVisibility() == 8; --lastVisibe) {
        }
        for (int i = 0; i < count; ++i) {
            View child2 = this.getChildAt(i);
            if (child2.getVisibility() == 8) continue;
            int right = lOffset + child2.getMeasuredWidth();
            int bottom = top + child2.getMeasuredHeight();
            child2.layout(lOffset, top, lastVisibe == i ? rightEdge : right, bottom);
            lOffset = right;
        }
    }
}

