/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMTipLayer;

public class ZMTip
extends LinearLayout {
    public static final int ARROW_DIRECTION_NONE = -1;
    public static final int ARROW_DIRECTION_LEFT = 0;
    public static final int ARROW_DIRECTION_UP = 1;
    public static final int ARROW_DIRECTION_RIGHT = 2;
    public static final int ARROW_DIRECTION_DOWN = 3;
    public static final int LAYOUT_GRAVITY_NONE = -1;
    public static final int LAYOUT_GRAVITY_LEFT = 0;
    public static final int LAYOUT_GRAVITY_RIGHT = 1;
    public static final int LAYOUT_GRAVITY_TOP = 2;
    public static final int LAYOUT_GRAVITY_BOTTOM = 3;
    public static final int LAYOUT_OVERLYING_FROM_CENTER = 0;
    public static final int LAYOUT_OVERLYING_FROM_BOTTOM = 1;
    private View mAnchor;
    private Paint mPaint;
    private float mShadowRadius = 0.0f;
    private int mBorderMarginLeft = 0;
    private int mBorderMarginTop = 0;
    private int mBorderMarginRight = 0;
    private int mBorderMarginBottom = 0;
    private int mArrowWidth = 0;
    private int mArrowHeight = 0;
    private float mStrokeWidth;
    private int mArcSize;
    private int mClrBackground;
    private int mClrBorder;
    private int mClrShadow;
    private int mShadowDx;
    private int mShadowDy;
    private Drawable mDrawableBackground;
    private int mPreferredX;
    private int mPreferredY;
    private boolean mbPreferredPosSetted = false;
    private int mGravity = -1;
    private int mOverlyingType = 0;
    private int mGravityPadding = 0;
    private int mArrowDir = -1;
    private int mDistanceToAnchor = 0;

    public ZMTip(Context context) {
        super(context);
        this.init(context, null);
    }

    public ZMTip(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mPaint = new Paint();
        this.mPaint.setColor(-536870912);
        this.mPaint.setAntiAlias(true);
        this.setWillNotDraw(false);
        this.setWillNotCacheDrawing(true);
        this.mArrowWidth = UIUtil.dip2px(context, 16.0f);
        this.mArrowHeight = this.mArrowWidth / 2;
        this.mStrokeWidth = UIUtil.dip2px(context, 1.0f);
        this.mArcSize = UIUtil.dip2px(context, 6.0f);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.ZMTip, R.attr.zm_tipAppearance, 0);
        TypedValue background = new TypedValue();
        a.getValue(R.styleable.ZMTip_zm_background, background);
        if (background.type == 1 || background.type == 3) {
            this.mDrawableBackground = a.getDrawable(R.styleable.ZMTip_zm_background);
            this.mClrBackground = a.getColor(R.styleable.ZMTip_zm_backgroundColorIfHardwareAccelerated, -522725417);
        } else {
            this.mClrBackground = a.getColor(R.styleable.ZMTip_zm_background, -522725417);
        }
        this.mClrBorder = a.getColor(R.styleable.ZMTip_zm_borderColor, -520093697);
        this.setShadow(4.0f, 0, 2, a.getColor(R.styleable.ZMTip_zm_shadowColor, -13610096));
        a.recycle();
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
    }

    public void setBackgroundColor(int color2) {
        this.mClrBackground = color2;
        this.mDrawableBackground = null;
        if (this.getVisibility() == 0) {
            this.invalidate();
        }
    }

    public int getBackgroundColor() {
        return this.mClrBackground;
    }

    public int getLayoutGravity() {
        return this.mGravity;
    }

    public int getLayoutGravityPadding() {
        return this.mGravityPadding;
    }

    public void setLayoutGravity(int gravity, int padding) {
        this.mGravity = gravity;
        this.mGravityPadding = padding;
    }

    public int getOverlyingType() {
        return this.mOverlyingType;
    }

    public void setOverlyingType(int mOverlyingGravity) {
        this.mOverlyingType = mOverlyingGravity;
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.mDrawableBackground = drawable2;
        this.mClrBackground = 0;
        if (this.getVisibility() == 0) {
            this.invalidate();
        }
    }

    public Drawable getBackgroundDrawable() {
        return this.mDrawableBackground;
    }

    public void setBorderColor(int color2) {
        this.mClrBorder = color2;
        if (this.getVisibility() == 0) {
            this.invalidate();
        }
    }

    public int getBorderColor() {
        return this.mClrBorder;
    }

    public void setShadow(float radius, int dx, int dy, int color2) {
        this.mShadowRadius = radius;
        this.mClrShadow = color2;
        this.mShadowDx = dx;
        this.mShadowDy = dy;
        this.updatePaddings();
        if (this.getVisibility() == 0) {
            this.invalidate();
        }
    }

    public void setShadowColor(int color2) {
        this.mClrShadow = color2;
        if (this.getVisibility() == 0) {
            this.invalidate();
        }
    }

    public int getShadowColor() {
        return this.mClrShadow;
    }

    public void setCornerArcSize(int arcSize) {
        this.mArcSize = arcSize;
        this.updatePaddings();
        if (this.getVisibility() == 0) {
            this.invalidate();
        }
    }

    public int getCornerArcSize() {
        return this.mArcSize;
    }

    public void setArrowSize(int arrowWidth, int arrowHeight) {
        this.mArrowWidth = arrowWidth;
        this.mArrowHeight = arrowHeight;
        this.updatePaddings();
    }

    public int getArrowWidth() {
        return this.mArrowWidth;
    }

    public int getArrowHeight() {
        return this.mArrowHeight;
    }

    public void setAnchor(View anchor, int arrowDirection) {
        if (this.mAnchor == anchor) {
            return;
        }
        this.mAnchor = anchor;
        this.mArrowDir = arrowDirection;
        this.updatePaddings();
    }

    public void setDistanceToAnchor(int distance) {
        this.mDistanceToAnchor = distance;
        if (this.getVisibility() == 0 && this.getParent() instanceof ZMTipLayer) {
            this.getParent().requestLayout();
        }
    }

    public int getDistanceToAnchor() {
        return this.mDistanceToAnchor;
    }

    private void updatePaddings() {
        if (this.getVisibility() == 0 && this.getParent() instanceof ZMTipLayer) {
            this.getParent().requestLayout();
        }
        this.mBorderMarginLeft = (int)(this.mShadowRadius - (float)this.mShadowDx);
        this.mBorderMarginTop = (int)(this.mShadowRadius - (float)this.mShadowDy);
        this.mBorderMarginRight = (int)(this.mShadowRadius + (float)this.mShadowDx);
        this.mBorderMarginBottom = (int)(this.mShadowRadius + (float)this.mShadowDy);
        int paddingLeft = (int)this.mStrokeWidth + this.mBorderMarginLeft;
        int paddingTop = (int)this.mStrokeWidth + this.mBorderMarginTop;
        int paddingRight = (int)this.mStrokeWidth + this.mBorderMarginRight;
        int paddingBottom = (int)this.mStrokeWidth + this.mBorderMarginBottom;
        switch (this.mArrowDir) {
            case 0: {
                if (this.mArrowHeight >= paddingLeft) {
                    paddingLeft = this.mArrowHeight;
                    this.mBorderMarginLeft = 0;
                    break;
                }
                paddingLeft += this.mArrowHeight;
                break;
            }
            case 1: {
                if (this.mArrowHeight >= paddingTop) {
                    paddingTop = this.mArrowHeight;
                    this.mBorderMarginTop = 0;
                    break;
                }
                paddingTop += this.mArrowHeight;
                break;
            }
            case 2: {
                if (this.mArrowHeight >= paddingRight) {
                    paddingRight = this.mArrowHeight;
                    this.mBorderMarginRight = 0;
                    break;
                }
                paddingRight += this.mArrowHeight;
                break;
            }
            case 3: {
                if (this.mArrowHeight >= paddingBottom) {
                    paddingBottom = this.mArrowHeight;
                    this.mBorderMarginBottom = 0;
                    break;
                }
                paddingBottom += this.mArrowHeight;
            }
        }
        this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    public View getAnchor() {
        return this.mAnchor;
    }

    public int getArrowDirection() {
        return this.mArrowDir;
    }

    public void setPreferredPosition(int x, int y) {
        this.mPreferredX = x;
        this.mPreferredY = y;
        this.mbPreferredPosSetted = true;
    }

    public void resetPreferredPosition() {
        this.mPreferredX = 0;
        this.mPreferredY = 0;
        this.mbPreferredPosSetted = false;
    }

    public int getPreferredX() {
        return this.mPreferredX;
    }

    public int getPreferredY() {
        return this.mPreferredY;
    }

    public boolean isPreferredPositionSetted() {
        return this.mbPreferredPosSetted;
    }

    public void show(ZMTipLayer parent) {
        if (parent.indexOfChild((View)this) < 0) {
            parent.addView((View)this);
        }
        parent.requestLayout();
        if (this.getVisibility() == 0) {
            Animation fadeIn = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.zm_tip_fadein);
            this.startAnimation(fadeIn);
        }
    }

    public void dismiss() {
        ZMTipLayer parent = (ZMTipLayer)this.getParent();
        if (parent == null) {
            return;
        }
        parent.removeView((View)this);
        parent.requestLayout();
    }

    protected void onDraw(Canvas canvas) {
        int lineY;
        int lineY2;
        int arrowXPos;
        int arcY;
        int arcX;
        int lineX;
        int arrowDir = this.getArrowDirection();
        Rect rectAnchor = null;
        if (this.mAnchor != null) {
            rectAnchor = UIUtil.getAbsoluteRect(this.mAnchor);
        }
        Rect rectSelf = UIUtil.getAbsoluteRect((View)this);
        if (rectAnchor != null) {
            rectAnchor.offset(-rectSelf.left, -rectSelf.top);
        }
        Path path = new Path();
        if (arrowDir == 0) {
            int arrowYPos = (rectAnchor.top + rectAnchor.bottom) / 2;
            lineX = this.mBorderMarginLeft + this.mArrowHeight;
            path.moveTo((float)lineX, (float)(this.getHeight() - this.mBorderMarginBottom - this.mArcSize));
            path.lineTo((float)lineX, (float)(arrowYPos + this.mArrowWidth / 2));
            path.lineTo((float)this.mBorderMarginLeft, (float)arrowYPos);
            path.lineTo((float)lineX, (float)(arrowYPos - this.mArrowWidth / 2));
            path.lineTo((float)lineX, (float)(this.mBorderMarginTop + this.mArcSize));
            arcX = lineX;
            arcY = this.mBorderMarginTop;
        } else {
            int lineX2 = this.mBorderMarginLeft;
            if (arrowDir == 3) {
                path.moveTo((float)lineX2, (float)(this.getHeight() - this.mBorderMarginBottom - this.mArrowHeight - this.mArcSize));
            } else {
                path.moveTo((float)lineX2, (float)(this.getHeight() - this.mBorderMarginBottom - this.mArcSize));
            }
            if (arrowDir == 1) {
                path.lineTo((float)lineX2, (float)(this.mBorderMarginTop + this.mArrowHeight + this.mArcSize));
                arcY = this.mBorderMarginTop + this.mArrowHeight;
            } else {
                path.lineTo((float)lineX2, (float)(this.mBorderMarginTop + this.mArcSize));
                arcY = this.mBorderMarginTop;
            }
            arcX = lineX2;
        }
        RectF oval = this.getArcOval(arcX, arcY);
        path.arcTo(oval, 180.0f, 90.0f);
        if (arrowDir == 1) {
            arrowXPos = (rectAnchor.left + rectAnchor.right) / 2;
            lineY2 = this.mBorderMarginTop + this.mArrowHeight;
            path.lineTo((float)(arrowXPos - this.mArrowWidth / 2), (float)lineY2);
            path.lineTo((float)arrowXPos, (float)this.mBorderMarginTop);
            path.lineTo((float)(arrowXPos + this.mArrowWidth / 2), (float)lineY2);
            path.lineTo((float)(this.getWidth() - this.mBorderMarginRight - this.mArcSize), (float)lineY2);
            arcX = this.getWidth() - this.mBorderMarginRight - this.mArcSize * 2;
            arcY = lineY2;
        } else {
            lineY = this.mBorderMarginTop;
            if (arrowDir == 2) {
                path.lineTo((float)(this.getWidth() - this.mBorderMarginRight - this.mArrowHeight - this.mArcSize), (float)lineY);
                arcX = this.getWidth() - this.mBorderMarginRight - this.mArrowHeight - this.mArcSize * 2;
            } else {
                path.lineTo((float)(this.getWidth() - this.mBorderMarginRight - this.mArcSize), (float)lineY);
                arcX = this.getWidth() - this.mBorderMarginRight - this.mArcSize * 2;
            }
            arcY = lineY;
        }
        oval = this.getArcOval(arcX, arcY);
        path.arcTo(oval, 270.0f, 90.0f);
        if (arrowDir == 2) {
            int arrowYPos = (rectAnchor.top + rectAnchor.bottom) / 2;
            int lineX3 = this.getWidth() - this.mBorderMarginRight - this.mArrowHeight;
            path.lineTo((float)lineX3, (float)(arrowYPos - this.mArrowWidth / 2));
            path.lineTo((float)(this.getWidth() - this.mBorderMarginRight), (float)arrowYPos);
            path.lineTo((float)lineX3, (float)(arrowYPos + this.mArrowWidth / 2));
            path.lineTo((float)lineX3, (float)(this.getHeight() - this.mBorderMarginBottom - this.mArcSize));
            arcX = lineX3 - this.mArcSize * 2;
            arcY = this.getHeight() - this.mBorderMarginBottom - this.mArcSize * 2;
        } else {
            lineX = this.getWidth() - this.mBorderMarginRight;
            if (arrowDir == 3) {
                path.lineTo((float)lineX, (float)(this.getHeight() - this.mBorderMarginBottom - this.mArrowHeight - this.mArcSize));
                arcY = this.getHeight() - this.mBorderMarginBottom - this.mArrowHeight - this.mArcSize * 2;
            } else {
                path.lineTo((float)lineX, (float)(this.getHeight() - this.mBorderMarginBottom - this.mArcSize));
                arcY = this.getHeight() - this.mBorderMarginBottom - this.mArcSize * 2;
            }
            arcX = lineX - this.mArcSize * 2;
        }
        oval = this.getArcOval(arcX, arcY);
        path.arcTo(oval, 0.0f, 90.0f);
        if (arrowDir == 3) {
            arrowXPos = (rectAnchor.left + rectAnchor.right) / 2;
            lineY2 = this.getHeight() - this.mBorderMarginBottom - this.mArrowHeight;
            path.lineTo((float)(arrowXPos + this.mArrowWidth / 2), (float)lineY2);
            path.lineTo((float)arrowXPos, (float)(this.getHeight() - this.mBorderMarginBottom));
            path.lineTo((float)(arrowXPos - this.mArrowWidth / 2), (float)lineY2);
            path.lineTo((float)(this.mBorderMarginLeft + this.mArcSize), (float)lineY2);
            arcX = this.mBorderMarginLeft;
            arcY = lineY2 - this.mArcSize * 2;
        } else {
            lineY = this.getHeight() - this.mBorderMarginBottom;
            if (arrowDir == 0) {
                path.lineTo((float)(this.mBorderMarginLeft + this.mArrowHeight + this.mArcSize), (float)lineY);
                arcX = this.mBorderMarginLeft + this.mArrowHeight;
            } else {
                path.lineTo((float)(this.mBorderMarginLeft + this.mArcSize), (float)lineY);
                arcX = this.mBorderMarginLeft;
            }
            arcY = lineY - this.mArcSize * 2;
        }
        oval = this.getArcOval(arcX, arcY);
        path.arcTo(oval, 90.0f, 90.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setShadowLayer(this.mShadowRadius, (float)this.mShadowDx, (float)this.mShadowDy, this.mClrShadow);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setColor(this.mClrBorder);
        canvas.drawPath(path, this.mPaint);
        if (this.mDrawableBackground == null || this._zmIsHardwareAccelerated()) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            this.mPaint.setStrokeWidth(0.0f);
            this.mPaint.setColor(this.mClrBackground);
            canvas.drawPath(path, this.mPaint);
        } else {
            this.mDrawableBackground.setBounds(0, 0, this.getWidth(), this.getHeight());
            canvas.clipPath(path);
            this.mDrawableBackground.draw(canvas);
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setColor(this.mClrBorder);
        canvas.drawPath(path, this.mPaint);
    }

    @SuppressLint(value={"NewApi"})
    private boolean _zmIsHardwareAccelerated() {
        if (Build.VERSION.SDK_INT >= 11) {
            return this.isHardwareAccelerated();
        }
        return false;
    }

    private RectF getArcOval(int arcX, int arcY) {
        RectF oval = new RectF();
        oval.left = arcX;
        oval.top = arcY;
        oval.right = arcX + this.mArcSize * 2;
        oval.bottom = arcY + this.mArcSize * 2;
        return oval;
    }
}

