/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TimePicker;
import java.util.Calendar;
import us.zoom.androidlib.R;
import us.zoom.androidlib.widget.ZMAlertDialog;

public class ZMTimePickerDialog
extends ZMAlertDialog
implements DialogInterface.OnClickListener,
TimePicker.OnTimeChangedListener {
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String IS_24_HOUR = "is24hour";
    private final TimePicker mTimePicker;
    private final OnTimeSetListener mCallback;
    Calendar calendar;
    int mInitialHourOfDay;
    int mInitialMinute;
    boolean mIs24HourView;

    public ZMTimePickerDialog(Context context, OnTimeSetListener callBack, int hourOfDay, int minute, boolean is24HourView) {
        this(context, 0, callBack, hourOfDay, minute, is24HourView);
    }

    public ZMTimePickerDialog(Context context, int theme, OnTimeSetListener callBack, int hourOfDay, int minute, boolean is24HourView) {
        super(context, theme);
        this.mCallback = callBack;
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mIs24HourView = is24HourView;
        this.setTitle(R.string.zm_time_picker_dialog_title);
        Context themeContext = this.getContext();
        this.setButton(-1, themeContext.getText(R.string.zm_date_time_set), this);
        this.setButton(-3, themeContext.getText(R.string.zm_date_time_cancel), this);
        LayoutInflater inflater = (LayoutInflater)themeContext.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.zm_time_picker_dialog, null);
        this.setView(view);
        this.mTimePicker = (TimePicker)view.findViewById(R.id.timePicker);
        this.mTimePicker.setIs24HourView(Boolean.valueOf(this.mIs24HourView));
        this.mTimePicker.setCurrentHour(Integer.valueOf(this.mInitialHourOfDay));
        this.mTimePicker.setCurrentMinute(Integer.valueOf(this.mInitialMinute));
        this.mTimePicker.setOnTimeChangedListener((TimePicker.OnTimeChangedListener)this);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            this.tryNotifyTimeSet();
        } else {
            this.dismiss();
        }
    }

    public void updateTime(int hourOfDay, int minutOfHour) {
        this.mTimePicker.setCurrentHour(Integer.valueOf(hourOfDay));
        this.mTimePicker.setCurrentMinute(Integer.valueOf(minutOfHour));
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
    }

    private void tryNotifyTimeSet() {
        if (this.mCallback != null) {
            this.mTimePicker.clearFocus();
            this.mCallback.onTimeSet(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
        }
    }

    protected void onStop() {
        super.onStop();
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(HOUR, this.mTimePicker.getCurrentHour().intValue());
        state.putInt(MINUTE, this.mTimePicker.getCurrentMinute().intValue());
        state.putBoolean(IS_24_HOUR, this.mTimePicker.is24HourView());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int hour = savedInstanceState.getInt(HOUR);
        int minute = savedInstanceState.getInt(MINUTE);
        this.mTimePicker.setIs24HourView(Boolean.valueOf(savedInstanceState.getBoolean(IS_24_HOUR)));
        this.mTimePicker.setCurrentHour(Integer.valueOf(hour));
        this.mTimePicker.setCurrentMinute(Integer.valueOf(minute));
    }

    public static interface OnTimeSetListener {
        public void onTimeSet(TimePicker var1, int var2, int var3);
    }
}

