/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import us.zoom.androidlib.R;
import us.zoom.androidlib.widget.ZMSettingsCategory;

public class ZMSettingsLayout
extends LinearLayout {
    private static final int INVALID_SPACING = Integer.MIN_VALUE;
    private float mCategorySpacing = -2.1474836E9f;

    public ZMSettingsLayout(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public ZMSettingsLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    @SuppressLint(value={"NewApi"})
    public ZMSettingsLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context, attrs, defStyle);
    }

    private void initView(Context context, AttributeSet attrs, int defStyle) {
        int spacing;
        TypedArray attrFromStyle;
        Resources.Theme theme = context.getTheme();
        TypedArray defAttrs = theme.obtainStyledAttributes(attrs, R.styleable.ZMSettingsLayout, R.attr.zm_settingsLayoutAppearance, 0);
        if (defAttrs != null) {
            int spacing2 = defAttrs.getDimensionPixelSize(R.styleable.ZMSettingsLayout_zm_settingsCategorySpacing, Integer.MIN_VALUE);
            if (spacing2 != Integer.MIN_VALUE) {
                this.mCategorySpacing = spacing2;
            }
            defAttrs.recycle();
            defAttrs = null;
        }
        if (defStyle > 0 && (attrFromStyle = context.obtainStyledAttributes(attrs, R.styleable.ZMSettingsCategory, defStyle, 0)) != null) {
            spacing = attrFromStyle.getDimensionPixelSize(R.styleable.ZMSettingsLayout_zm_settingsCategorySpacing, Integer.MIN_VALUE);
            if (spacing != Integer.MIN_VALUE) {
                this.mCategorySpacing = spacing;
            }
            attrFromStyle.recycle();
        }
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ZMSettingsCategory);
            spacing = a.getDimensionPixelSize(R.styleable.ZMSettingsLayout_zm_settingsCategorySpacing, Integer.MIN_VALUE);
            if (spacing != Integer.MIN_VALUE) {
                this.mCategorySpacing = spacing;
            }
            a.recycle();
        }
        if (this.mCategorySpacing == -2.1474836E9f) {
            try {
                this.mCategorySpacing = context.getResources().getDimension(R.dimen.zm_setting_item_group_spacing);
            }
            catch (Exception e) {
                this.mCategorySpacing = 45.0f;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean bFirstCategory = true;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof ZMSettingsCategory) || child.getVisibility() != 0) continue;
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)child.getLayoutParams();
            params.topMargin = !bFirstCategory ? (int)this.mCategorySpacing : params.topMargin;
            child.setLayoutParams((ViewGroup.LayoutParams)params);
            bFirstCategory = false;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

