/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.EditText;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.UIUtil;

public class ZMMaterialEditText
extends EditText {
    private int mLineNormalColor;
    private int mLineDisableColor;
    private int mLinefocusColor;
    private PathEffect mDisablePathEffect;
    private boolean enableLine = true;

    public ZMMaterialEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public ZMMaterialEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ZMMaterialEditText(Context context) {
        super(context);
        this.init(null);
    }

    private void init(AttributeSet attrs) {
        Resources res = this.getResources();
        if (res == null) {
            return;
        }
        int dash = UIUtil.dip2px(this.getContext(), 4.0f);
        this.mDisablePathEffect = new DashPathEffect(new float[]{dash / 2, dash}, 1.0f);
        super.setBackgroundColor(0);
        this.mLineNormalColor = res.getColor(R.color.zm_highlight);
        this.mLineDisableColor = res.getColor(R.color.zm_highlight_disabled);
        this.mLinefocusColor = res.getColor(R.color.zm_highlight);
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ZMMaterialEdt);
            this.mLineNormalColor = typedArray.getColor(R.styleable.ZMMaterialEdt_zm_edtNormalColor, this.mLineNormalColor);
            this.mLineDisableColor = typedArray.getColor(R.styleable.ZMMaterialEdt_zm_edtDisableColor, this.mLineDisableColor);
            this.mLinefocusColor = typedArray.getColor(R.styleable.ZMMaterialEdt_zm_edtFocusColor, this.mLinefocusColor);
            typedArray.recycle();
        }
    }

    public void setEnableLine(boolean enable) {
        this.enableLine = enable;
    }

    public int getLineNormalColor() {
        return this.mLineNormalColor;
    }

    public void setLineNormalColor(int lineNormalColor) {
        this.mLineNormalColor = lineNormalColor;
    }

    public int getLineDisableColor() {
        return this.mLineDisableColor;
    }

    public void setLineDisableColor(int lineDisableColor) {
        this.mLineDisableColor = lineDisableColor;
    }

    public int getLinefocusColor() {
        return this.mLinefocusColor;
    }

    public void setLinefocusColor(int linefocusColor) {
        this.mLinefocusColor = linefocusColor;
    }

    public void setBackground(Drawable background) {
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable background) {
    }

    public void setBackgroundColor(int color2) {
    }

    public void setBackgroundResource(int resid) {
    }

    public void setTextAppearance(Context context, int resid) {
        if (resid != 0) {
            TypedArray typedArray = context.obtainStyledAttributes(resid, R.styleable.ZMMaterialEdt);
            this.mLineNormalColor = typedArray.getColor(R.styleable.ZMMaterialEdt_zm_edtNormalColor, this.mLineNormalColor);
            this.mLineDisableColor = typedArray.getColor(R.styleable.ZMMaterialEdt_zm_edtDisableColor, this.mLineDisableColor);
            this.mLinefocusColor = typedArray.getColor(R.styleable.ZMMaterialEdt_zm_edtFocusColor, this.mLinefocusColor);
            typedArray.recycle();
        }
        super.setTextAppearance(context, resid);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.enableLine) {
            TextPaint paint = this.getPaint();
            int lineHeight = UIUtil.dip2px(this.getContext(), 3.0f);
            int color2 = this.mLineNormalColor;
            paint.setPathEffect(null);
            if (!this.isEnabled()) {
                color2 = this.mLineDisableColor;
                lineHeight = UIUtil.dip2px(this.getContext(), 2.0f);
                paint.setPathEffect(this.mDisablePathEffect);
            } else if (this.isFocused()) {
                color2 = this.mLinefocusColor;
            }
            paint.setColor(color2);
            paint.setStrokeWidth((float)lineHeight);
            paint.setAntiAlias(true);
            int height = this.getMeasuredHeight() + this.getScrollY();
            int width = this.getMeasuredWidth();
            canvas.drawLine(0.0f, (float)height, (float)width, (float)height, (Paint)paint);
            paint.setPathEffect(null);
        }
    }
}

