/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import us.zoom.androidlib.R;

public class ZMImageTextButton
extends Button {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mImageTextOrientation = 0;
    private int mImage;
    private View.OnClickListener mOnClickListener;

    public ZMImageTextButton(Context context) {
        super(context);
    }

    public ZMImageTextButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ZMImageTextButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        int imageId;
        if (context == null || attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ZMImageTextButton);
        int orientation = a.getInt(R.styleable.ZMImageTextButton_zmImageTextOrientation, -1);
        if (orientation >= 0) {
            this.setImageTextOrientation(orientation);
        }
        if ((imageId = a.getResourceId(R.styleable.ZMImageTextButton_zm_image, -1)) != -1) {
            this.setImageResource(imageId);
        }
        a.recycle();
        super.setOnClickListener(new View.OnClickListener(){
            private long mLastClickTime = 0L;

            public void onClick(View view) {
                if (ZMImageTextButton.this.mOnClickListener == null) {
                    return;
                }
                long curTime = SystemClock.elapsedRealtime();
                if (curTime - this.mLastClickTime > 500L) {
                    ZMImageTextButton.this.mOnClickListener.onClick(view);
                }
                this.mLastClickTime = curTime;
            }
        });
    }

    public void setImageResource(int resId) {
        this.mImage = resId;
        if (this.isShown()) {
            this.requestLayout();
        }
    }

    public int getImage() {
        return this.mImage;
    }

    public void setImageTextOrientation(int orientation) {
        if (orientation == 0 || orientation == 1) {
            this.mImageTextOrientation = orientation;
        }
    }

    public int getImageTextOrientation() {
        return this.mImageTextOrientation;
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mOnClickListener = l;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mImage > 0) {
            if ("".equals(this.getText().toString())) {
                this.setBackgroundResource(this.mImage);
            } else if (this.mImageTextOrientation == 0) {
                this.setCompoundDrawablesWithIntrinsicBounds(this.getResources().getDrawable(this.mImage), null, null, null);
            } else if (this.mImageTextOrientation == 1) {
                this.setCompoundDrawablesWithIntrinsicBounds(null, this.getResources().getDrawable(this.mImage), null, null);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

