/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import us.zoom.androidlib.R;

public class ZMIOSStyleTitlebarLayout
extends LinearLayout {
    private int mLeftButton = 0;
    private int mRightButton = 0;
    private int mTitle = 0;
    private View mvLeftButton = null;
    private View mvRightButton = null;

    @SuppressLint(value={"NewApi"})
    public ZMIOSStyleTitlebarLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    public ZMIOSStyleTitlebarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public ZMIOSStyleTitlebarLayout(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    private void init(Context context, AttributeSet attrs, int style2) {
        if (context == null || attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ZMIOSStyleTitlebarLayout);
        this.mLeftButton = a.getResourceId(R.styleable.ZMIOSStyleTitlebarLayout_zm_leftButton, 0);
        this.mRightButton = a.getResourceId(R.styleable.ZMIOSStyleTitlebarLayout_zm_rightButton, 0);
        this.mTitle = a.getResourceId(R.styleable.ZMIOSStyleTitlebarLayout_zm_title, 0);
        a.recycle();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View title = null;
        this.mvLeftButton = null;
        this.mvRightButton = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            int id2 = view.getId();
            if (id2 == this.mLeftButton || this.isInEditMode() && i == 0) {
                this.mvLeftButton = view;
                this.layoutLeftButton(view, l, t, r, b);
                continue;
            }
            if (id2 == this.mRightButton || this.isInEditMode() && this.getChildCount() >= 3 && i == 1) {
                this.mvRightButton = view;
                this.layoutRightButton(view, l, t, r, b);
                continue;
            }
            if (id2 == this.mTitle || this.isInEditMode() && (this.getChildCount() >= 3 && i == 2 || this.getChildCount() < 3 && i == 1)) {
                title = view;
                continue;
            }
            this.layoutOthers(view, l, t, r, b);
        }
        if (title != null) {
            this.layoutTitle(title, l, t, r, b);
        }
    }

    private void layoutLeftButton(View view, int l, int t, int r, int b) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
        int marginLeft = params.leftMargin;
        int marginTop = params.topMargin;
        int marginBottom = params.bottomMargin;
        int left = paddingLeft + marginLeft;
        int top = paddingTop + marginTop + (b - t - paddingTop - marginTop - paddingBottom - marginBottom - view.getMeasuredHeight()) / 2;
        view.layout(left, top, left + view.getMeasuredWidth(), top + view.getMeasuredHeight());
    }

    private void layoutRightButton(View view, int l, int t, int r, int b) {
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
        int marginTop = params.topMargin;
        int marginRight = params.rightMargin;
        int marginBottom = params.bottomMargin;
        int right = r - l - paddingRight - marginRight;
        int top = paddingTop + marginTop + (b - t - paddingTop - marginTop - paddingBottom - marginBottom - view.getMeasuredHeight()) / 2;
        view.layout(right - view.getMeasuredWidth(), top, right, top + view.getMeasuredHeight());
    }

    private void layoutOthers(View view, int l, int t, int r, int b) {
        this.layoutTitle(view, l, t, r, b);
    }

    private void layoutTitle(View view, int l, int t, int r, int b) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
        int marginLeft = params.leftMargin;
        int marginTop = params.topMargin;
        int marginRight = params.rightMargin;
        int marginBottom = params.bottomMargin;
        int minLeft = 0;
        if (this.mvLeftButton != null) {
            minLeft = this.mvLeftButton.getRight();
        }
        int maxRight = r - l;
        if (this.mvRightButton != null) {
            maxRight = this.mvRightButton.getLeft();
        }
        int left = paddingLeft + marginLeft + (r - l - paddingLeft - marginLeft - paddingRight - marginRight - view.getMeasuredWidth()) / 2;
        int right = left + view.getMeasuredWidth();
        int top = paddingTop + marginTop + (b - t - paddingTop - marginTop - paddingBottom - marginBottom - view.getMeasuredHeight()) / 2;
        int bottom = top + view.getMeasuredHeight();
        if (maxRight - minLeft >= view.getMeasuredWidth()) {
            if (left < minLeft) {
                left = minLeft;
                right = left + view.getMeasuredWidth();
            } else if (right > maxRight) {
                right = maxRight;
                left = right - view.getMeasuredWidth();
            }
        } else {
            left = minLeft;
            right = maxRight;
        }
        view.layout(left, top, right, bottom);
    }
}

