/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import us.zoom.androidlib.R;

public class ZMDynTextSizeTextView
extends TextView {
    private float mMaxTextSize = 0.0f;
    private int mTextSizeUnit = 0;
    private boolean mSetTextSizeCalledFromOnMeasure = false;
    private int mMaxReduce = 12;

    public ZMDynTextSizeTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context, attrs);
    }

    public ZMDynTextSizeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public ZMDynTextSizeTextView(Context context) {
        super(context);
        this.initView(context, null);
    }

    private void initView(Context context, AttributeSet attrs) {
        TypedArray a;
        this.mMaxTextSize = this.getTextSize();
        if (attrs != null && (a = context.obtainStyledAttributes(attrs, R.styleable.ZMDynTextSizeTextView)) != null) {
            this.mMaxReduce = a.getDimensionPixelSize(R.styleable.ZMDynTextSizeTextView_zm_maxReduce, this.mMaxReduce);
            a.recycle();
        }
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, size);
        if (!this.mSetTextSizeCalledFromOnMeasure) {
            this.mTextSizeUnit = unit;
            this.mMaxTextSize = size;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int maxWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int tmpWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)100000, (int)Integer.MIN_VALUE);
        int tmpHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)10, (int)Integer.MIN_VALUE);
        float textSize = this.mMaxTextSize;
        int width = 0;
        do {
            this.mSetTextSizeCalledFromOnMeasure = true;
            float f = textSize;
            textSize = f - 1.0f;
            this.setTextSize(this.mTextSizeUnit, f);
            this.mSetTextSizeCalledFromOnMeasure = false;
            super.onMeasure(tmpWidthMeasureSpec, tmpHeightMeasureSpec);
        } while ((width = this.getMeasuredWidth()) > maxWidth && this.mMaxTextSize - textSize < (float)this.mMaxReduce);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

