/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.DatePicker;
import java.util.Calendar;
import us.zoom.androidlib.R;
import us.zoom.androidlib.widget.ZMAlertDialog;

public class ZMDatePickerDialog
extends ZMAlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private final DatePicker mDatePicker;
    private final OnDateSetListener mCallBack;
    private final Calendar mCalendar;
    int currentapiVersion = Build.VERSION.SDK_INT;
    private boolean mTitleNeedsUpdate = true;

    public ZMDatePickerDialog(Context context, OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        this(context, 0, callBack, year, monthOfYear, dayOfMonth);
    }

    public ZMDatePickerDialog(Context context, int theme, OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        super(context, theme);
        this.mCallBack = callBack;
        this.mCalendar = Calendar.getInstance();
        Context themeContext = this.getContext();
        this.setButton(-1, themeContext.getText(R.string.zm_date_time_set), this);
        this.setButton(-3, themeContext.getText(R.string.zm_date_time_cancel), this);
        LayoutInflater inflater = (LayoutInflater)themeContext.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.zm_date_picker_dialog, null);
        this.setView(view);
        this.mDatePicker = (DatePicker)view.findViewById(R.id.datePicker);
        this.mDatePicker.init(year, monthOfYear, dayOfMonth, (DatePicker.OnDateChangedListener)this);
        if (this.currentapiVersion >= 11) {
            this.mDatePicker.setCalendarViewShown(false);
        }
        this.updateTitle(year, monthOfYear, dayOfMonth);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            this.tryNotifyDateSet();
        } else {
            this.dismiss();
        }
    }

    public void onDateChanged(DatePicker view, int year, int month, int day) {
        this.mDatePicker.init(year, month, day, (DatePicker.OnDateChangedListener)this);
        this.updateTitle(year, month, day);
    }

    public DatePicker getDatePicker() {
        return this.mDatePicker;
    }

    public void updateDate(int year, int monthOfYear, int dayOfMonth) {
        this.mDatePicker.updateDate(year, monthOfYear, dayOfMonth);
    }

    private void tryNotifyDateSet() {
        if (this.mCallBack != null) {
            this.mDatePicker.clearFocus();
            this.mCallBack.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth());
        }
    }

    protected void onStop() {
        super.onStop();
    }

    private void updateTitle(int year, int month, int day) {
        if (this.currentapiVersion >= 11) {
            if (!this.mDatePicker.getCalendarViewShown()) {
                this.updateTitl(year, month, day);
            } else if (this.mTitleNeedsUpdate) {
                this.mTitleNeedsUpdate = false;
                this.setTitle(" ");
            }
        } else {
            this.updateTitl(year, month, day);
        }
    }

    private void updateTitl(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        String title = DateUtils.formatDateTime((Context)this.mContext, (long)this.mCalendar.getTimeInMillis(), (int)98326);
        this.setTitle(title);
        this.mTitleNeedsUpdate = true;
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(YEAR, this.mDatePicker.getYear());
        state.putInt(MONTH, this.mDatePicker.getMonth());
        state.putInt(DAY, this.mDatePicker.getDayOfMonth());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt(YEAR);
        int month = savedInstanceState.getInt(MONTH);
        int day = savedInstanceState.getInt(DAY);
        this.mDatePicker.init(year, month, day, (DatePicker.OnDateChangedListener)this);
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePicker var1, int var2, int var3, int var4);
    }
}

