/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import us.zoom.androidlib.R;

public class ZMBoundedLinearLayout
extends LinearLayout {
    private int mBoundedHeight;
    private int mBoundedWidth;

    @SuppressLint(value={"NewApi"})
    public ZMBoundedLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    @SuppressLint(value={"NewApi"})
    public ZMBoundedLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public ZMBoundedLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ZMBoundedLinearLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mBoundedHeight = 0;
        this.mBoundedWidth = 0;
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ZMBoundedLinearLayout);
        this.mBoundedWidth = a.getDimensionPixelSize(R.styleable.ZMBoundedLinearLayout_zm_bounded_width, 0);
        this.mBoundedHeight = a.getDimensionPixelSize(R.styleable.ZMBoundedLinearLayout_zm_bounded_height, 0);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.mBoundedWidth > 0 && this.mBoundedWidth < measuredWidth) {
            int measureMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mBoundedWidth, (int)measureMode);
        }
        int measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mBoundedHeight > 0 && this.mBoundedHeight < measuredHeight) {
            int measureMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mBoundedHeight, (int)measureMode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

