/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.UiModeUtil;
import us.zoom.androidlib.widget.ZMViewPager;

public class TouchImageView
extends View
implements ZMViewPager.Page,
View.OnTouchListener,
GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener {
    private static final String TAG = TouchImageView.class.getSimpleName();
    private static final int MAX_SCALE_LEVEL_COUNT = 3;
    private static final int MAX_VELOCITY_IN_DIP = 1500;
    private static final int MEM_BITMAP_THRESHOLD = 4096;
    private double mZoomVal = 0.0;
    private float mContentX = 0.0f;
    private float mContentY = 0.0f;
    private float mScaleWidth = 0.0f;
    private float mScaleHeight = 0.0f;
    private Scroller mScroller;
    private Handler mFlingHandler = new Handler();
    private boolean mStopFling = false;
    private boolean mIsFitScreen = true;
    private GestureDetector mGestureDetector;
    private Size mContentSize = new Size();
    private Rect mRectContent = new Rect();
    private boolean mHasInitData = false;
    private boolean mHasLayout = false;
    private Drawable mDrawable = null;
    private Bitmap mMemBitmap = null;
    private Canvas mMemCanvas = null;
    private View.OnTouchListener mOnTouchListener;
    private OnSingleTapConfirmedListener mOnSingleTapConfirmedListener;
    private OnViewPortChangedListener mOnViewPortChangedListener;
    private Handler mHandler = new Handler();
    private Runnable mRunnableNotifyViewPortChange = new Runnable(){

        @Override
        public void run() {
            if (TouchImageView.this.mOnViewPortChangedListener != null) {
                TouchImageView.this.mOnViewPortChangedListener.onViewPortChanged();
            }
        }
    };
    private Rect mSrcRect = new Rect();
    private Rect mDestRect = new Rect();
    private float mLastX1;
    private float mLastY1;
    private float mLastX2;
    private float mLastY2;
    private boolean mIsMultiTouchZooming = false;

    public TouchImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    public TouchImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public TouchImageView(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        DecelerateInterpolator interpolator = new DecelerateInterpolator(1.0f);
        this.mScroller = new Scroller(context, (Interpolator)interpolator);
        if (context instanceof ZMActivity) {
            ((ZMActivity)context).disableFinishActivityByGesture(true);
        }
        super.setOnTouchListener((View.OnTouchListener)this);
        if (!this.isInEditMode()) {
            this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
            this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this);
            this.mGestureDetector.setIsLongpressEnabled(false);
        }
    }

    public void setOnSingleTapConfirmedListener(OnSingleTapConfirmedListener onSingleTapConfirmedListener) {
        this.mOnSingleTapConfirmedListener = onSingleTapConfirmedListener;
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mOnTouchListener = l;
    }

    public void setOnViewPortChangedListener(OnViewPortChangedListener l) {
        this.mOnViewPortChangedListener = l;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 8) {
            float vScroll = event.getAxisValue(9);
            this.handleScroll(0.0f, -vScroll * (float)UIUtil.dip2px(this.getContext(), 5.0f));
        }
        return false;
    }

    public void setImageResource(int resId) {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        if (resId == 0) {
            this.mDrawable = null;
            this.invalidate();
            return;
        }
        this.mDrawable = context.getResources().getDrawable(resId);
        if (this.mDrawable != null) {
            this.initData();
        }
        this.invalidate();
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mDrawable = drawable2;
        if (this.mMemBitmap != null) {
            this.mMemBitmap.recycle();
            this.mMemBitmap = null;
            this.mMemCanvas = null;
        }
        if (this.mDrawable != null) {
            this.initData();
        }
        this.invalidate();
    }

    public void setImageBitmap(Bitmap bm) {
        if (bm == null) {
            this.mDrawable = null;
            this.invalidate();
            return;
        }
        this.mDrawable = new BitmapDrawable(this.getResources(), bm);
        if (this.mMemBitmap != null) {
            this.mMemBitmap.recycle();
            this.mMemBitmap = null;
            this.mMemCanvas = null;
        }
        if (this.mDrawable != null) {
            this.initData();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mMemBitmap != null) {
            this.mMemBitmap.recycle();
            this.mMemBitmap = null;
            this.mMemCanvas = null;
        }
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public boolean hasImage() {
        return this.mDrawable != null;
    }

    @Override
    public boolean canScrollHorizontal(int dx, int x, int y) {
        return this.canScrollHorizontal(dx);
    }

    public boolean canScrollHorizontal(int dx) {
        if (this.mContentSize == null || this.mRectContent == null) {
            return false;
        }
        if (this.mIsFitScreen) {
            return false;
        }
        float contentWidth = (float)(this.mZoomVal * (double)this.mContentSize.width);
        float newContentX = this.mContentX + (float)dx;
        if (newContentX > 0.0f) {
            if (contentWidth >= (float)this.mRectContent.width()) {
                newContentX = 0.0f;
            } else if (newContentX + contentWidth > (float)this.mRectContent.width()) {
                newContentX = (float)this.mRectContent.width() - contentWidth;
            }
        } else if (contentWidth >= (float)this.mRectContent.width() && newContentX + contentWidth < (float)this.mRectContent.width()) {
            newContentX = (float)this.mRectContent.width() - contentWidth;
        } else if (contentWidth <= (float)this.mRectContent.width()) {
            newContentX = 0.0f;
        }
        return (int)(newContentX * 100.0f) != (int)(this.mContentX * 100.0f);
    }

    public boolean canScrollVertical(int dy) {
        if (this.mContentSize == null || this.mRectContent == null) {
            return false;
        }
        if (this.mIsFitScreen) {
            return false;
        }
        float contentHeight = (float)(this.mZoomVal * (double)this.mContentSize.height);
        float newContentY = this.mContentY + (float)dy;
        if (newContentY > 0.0f) {
            if (contentHeight >= (float)this.mRectContent.height()) {
                newContentY = 0.0f;
            } else if (newContentY + contentHeight > (float)this.mRectContent.height()) {
                newContentY = (float)this.mRectContent.height() - contentHeight;
            }
        } else if (contentHeight >= (float)this.mRectContent.height() && newContentY + contentHeight < (float)this.mRectContent.height()) {
            newContentY = (float)this.mRectContent.height() - contentHeight;
        } else if (contentHeight <= (float)this.mRectContent.height()) {
            newContentY = 0.0f;
        }
        return (int)(newContentY * 100.0f) != (int)(this.mContentY * 100.0f);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mHasLayout = true;
        if (!this.mHasInitData) {
            this.initData();
        } else if (this.mIsFitScreen) {
            this.zoomToFitUnit();
        } else {
            PointF center = this.getCenterPixelPosOnContent();
            this.updateRectContentWithoutResetDestArea();
            if (center == null) {
                return;
            }
            this.resetDestAreaCenter(center.x, center.y);
        }
    }

    private void initData() {
        if (!this.mHasLayout) {
            return;
        }
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            this.mContentSize.width = drawable2.getIntrinsicWidth();
            this.mContentSize.height = drawable2.getIntrinsicHeight();
            this.mRectContent = this.createRectContent(this.mContentSize);
        }
        this.mHasInitData = true;
        this.zoomToFitUnit();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        canvas.save();
        try {
            Bitmap baseBitmap;
            Bitmap bitmap;
            canvas.clipRect(this.mRectContent);
            int left = (int)((float)this.mRectContent.left + this.mContentX);
            int top = (int)((float)this.mRectContent.top + this.mContentY);
            int right = (int)((float)left + this.mScaleWidth);
            int bottom = (int)((float)top + this.mScaleHeight);
            boolean done = false;
            if (drawable2 instanceof BitmapDrawable && (drawable2.getIntrinsicWidth() > 4096 || drawable2.getIntrinsicHeight() > 4096) && (bitmap = ((BitmapDrawable)drawable2).getBitmap()) != null && (baseBitmap = this.getMemBitmap(bitmap.getConfig())) != null && this.mMemCanvas != null) {
                this.mSrcRect.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
                this.mDestRect.set(left, top, right, bottom);
                this.mMemCanvas.drawColor(-16777216);
                this.mMemCanvas.drawBitmap(bitmap, this.mSrcRect, this.mDestRect, null);
                canvas.drawBitmap(baseBitmap, 0.0f, 0.0f, null);
                done = true;
            }
            if (!done) {
                drawable2.setBounds(left, top, right, bottom);
                drawable2.draw(canvas);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        canvas.restore();
    }

    private Bitmap getMemBitmap(Bitmap.Config config) {
        if (this.mMemBitmap != null) {
            if (this.mMemBitmap.getWidth() == this.getWidth() && this.mMemBitmap.getHeight() == this.getHeight()) {
                return this.mMemBitmap;
            }
            this.mMemBitmap.recycle();
            this.mMemBitmap = null;
            this.mMemCanvas = null;
        }
        try {
            this.mMemBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)config);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        if (this.mMemBitmap != null) {
            this.mMemCanvas = new Canvas(this.mMemBitmap);
        }
        return this.mMemBitmap;
    }

    public boolean onDown(MotionEvent e) {
        this.mStopFling = true;
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return true;
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        if (this.mOnSingleTapConfirmedListener != null) {
            this.mOnSingleTapConfirmedListener.onSingleTapConfirmed();
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent e) {
        this.mStopFling = true;
        if (this.mContentSize == null || this.mContentSize.width == 0 || this.mContentSize.height == 0) {
            return true;
        }
        int levelsCount = this.getScaleLevelsCount();
        int oldLevel = this.getCurrentScaleLevel();
        int newLevel = (oldLevel + 1) % levelsCount;
        if (newLevel == oldLevel) {
            return true;
        }
        if (newLevel == 0) {
            this.zoomToFitUnit();
        } else {
            this.switchToLevel(newLevel, e.getX(), e.getY());
        }
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return true;
    }

    public boolean onTouch(View v, MotionEvent e) {
        boolean res;
        if (this.mOnTouchListener != null && (res = this.mOnTouchListener.onTouch(v, e))) {
            return true;
        }
        if (e.getPointerCount() == 2) {
            if (e.getActionMasked() == 1 && this.mIsMultiTouchZooming) {
                this.onMultiTouchZoomEnd();
                return true;
            }
            float x1 = e.getX(0);
            float y1 = e.getY(0);
            float x2 = e.getX(1);
            float y2 = e.getY(1);
            if (this.mIsMultiTouchZooming) {
                this.onMultiTouchZoom(x1, y1, x2, y2, this.mLastX1, this.mLastY1, this.mLastX2, this.mLastY2);
            }
            this.mIsMultiTouchZooming = true;
            this.mLastX1 = x1;
            this.mLastY1 = y1;
            this.mLastX2 = x2;
            this.mLastY2 = y2;
            return true;
        }
        if (this.mIsMultiTouchZooming) {
            this.onMultiTouchZoomEnd();
            return true;
        }
        if (e.getActionMasked() == 1) {
            this.notifyViewPortChange(0);
        }
        return this.mGestureDetector.onTouchEvent(e);
    }

    private void notifyViewPortChange(int delayMs) {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeCallbacks(this.mRunnableNotifyViewPortChange);
        this.mHandler.postDelayed(this.mRunnableNotifyViewPortChange, (long)delayMs);
    }

    private void onMultiTouchZoom(float x1, float y1, float x2, float y2, float lastX1, float lastY1, float lastX2, float lastY2) {
        this.mIsMultiTouchZooming = true;
        float dx = x2 - x1;
        float dy = y2 - y1;
        float lastDx = lastX2 - lastX1;
        float lastDy = lastY2 - lastY1;
        double curDistance = Math.sqrt(dx * dx + dy * dy);
        double lastDistance = Math.sqrt(lastDx * lastDx + lastDy * lastDy);
        double newZoom = this.mZoomVal * (curDistance / lastDistance);
        float lastX1OnUnit = this.viewXToShareUnitX(lastX1);
        float lastY1OnUnit = this.viewYToShareUnitY(lastY1);
        PointF pixelLastPos1OnContent = this.unitPosToPixelPosOnContent(lastX1OnUnit, lastY1OnUnit, this.mZoomVal);
        float lastXPos1OnContentNew = (float)((double)pixelLastPos1OnContent.x * newZoom);
        float lastYPos1OnContentNew = (float)((double)pixelLastPos1OnContent.y * newZoom);
        this.mZoomVal = newZoom;
        this.mIsFitScreen = this.checkFitScreen();
        this.updateRectContentWithoutResetDestArea();
        float x1OnUnit = this.viewXToShareUnitX(x1);
        float y1OnUnit = this.viewYToShareUnitY(y1);
        if (this.mContentSize == null || this.mContentSize.width == 0) {
            return;
        }
        this.mScaleWidth = (float)((double)this.mContentSize.width * newZoom);
        this.mScaleHeight = (float)((double)this.mContentSize.height * newZoom);
        this.mContentX = x1OnUnit - lastXPos1OnContentNew;
        this.mContentY = y1OnUnit - lastYPos1OnContentNew;
        this.trimContentPos();
        this.repaint();
        this.notifyViewPortChange(0);
    }

    private void onMultiTouchZoomEnd() {
        this.mIsMultiTouchZooming = false;
        if (this.mZoomVal < this.getMinLevelZoomValue()) {
            this.zoomToFitUnit();
        } else if (this.mZoomVal > this.getMaxLevelZoomValue()) {
            this.switchToLevel(this.getScaleLevelsCount() - 1, this.mRectContent.width() / 2 + this.mRectContent.left, this.mRectContent.height() / 2 + this.mRectContent.top);
        }
        this.notifyViewPortChange(0);
    }

    private boolean checkFitScreen() {
        if (this.mZoomVal < 0.01) {
            return true;
        }
        double zoomFit = this.scaleLevelToZoomValue(0);
        return Math.abs(this.mZoomVal - zoomFit) < 0.01;
    }

    private double getMaxLevelZoomValue() {
        Context context = this.getContext();
        if (context == null) {
            return 1.0;
        }
        float density = context.getResources().getDisplayMetrics().density;
        float maxLevelZoomVal = UiModeUtil.isInDesktopMode(this.getContext()) ? (float)(this.getFitLevelZoomValue(false) * 5.0 / 2.0 - this.getMinLevelZoomValue()) : density * 160.0f / 120.0f;
        return maxLevelZoomVal;
    }

    private double getMinLevelZoomValue() {
        return this.getFitLevelZoomValue(true);
    }

    private double getFitLevelZoomValue(boolean include) {
        boolean isRenderLarger;
        if (this.mContentSize == null) {
            return 0.0;
        }
        int renderWidth = this.getWidth();
        int renderHeight = this.getHeight();
        double fitWidth = 0.0;
        boolean bl = isRenderLarger = renderWidth * this.mContentSize.height > renderHeight * this.mContentSize.width;
        if (isRenderLarger && include || !isRenderLarger && !include) {
            int fitHeight = renderHeight;
            fitWidth = (double)fitHeight * (double)this.mContentSize.width / (double)this.mContentSize.height;
        } else {
            fitWidth = renderWidth;
        }
        double levelZoomVal = fitWidth / (double)this.mContentSize.width;
        return levelZoomVal;
    }

    private int getScaleLevelsCount() {
        if (this.mContentSize == null || this.mContentSize.width == 0 || this.mContentSize.height == 0) {
            return 3;
        }
        double maxLevelZoomVal = this.getMaxLevelZoomValue();
        float maxContextDisplayWidth = (float)(maxLevelZoomVal * (double)this.mContentSize.width);
        float maxContextDisplayHeight = (float)(maxLevelZoomVal * (double)this.mContentSize.height);
        if (maxContextDisplayWidth <= (float)this.getWidth() && maxContextDisplayHeight < (float)this.getHeight()) {
            return 1;
        }
        double minLevelZoomVal = this.getMinLevelZoomValue();
        double mediumLevelZoomVal = (minLevelZoomVal + maxLevelZoomVal) * 2.0 / 5.0;
        float mediumContextDisplayWidth = (float)(mediumLevelZoomVal * (double)this.mContentSize.width);
        float mediumContextDisplayHeight = (float)(mediumLevelZoomVal * (double)this.mContentSize.height);
        if (mediumContextDisplayWidth <= (float)this.getWidth() && mediumContextDisplayHeight < (float)this.getHeight()) {
            return 2;
        }
        return 3;
    }

    private int getCurrentScaleLevel() {
        int i;
        int levelsCount = this.getScaleLevelsCount();
        double[] levelZooms = new double[levelsCount];
        for (i = 0; i < levelsCount; ++i) {
            levelZooms[i] = this.scaleLevelToZoomValue(i);
        }
        for (i = 0; i < levelsCount - 1; ++i) {
            if (!(this.mZoomVal >= levelZooms[i]) || !(this.mZoomVal < levelZooms[i + 1])) continue;
            return i;
        }
        return levelsCount - 1;
    }

    private void switchToLevel(int level, float x, float y) {
        this.switchToZoom(this.scaleLevelToZoomValue(level), x, y);
    }

    private void switchToZoom(double zoomVal, float x, float y) {
        double oldZoom = this.mZoomVal;
        this.mZoomVal = zoomVal;
        this.mIsFitScreen = this.checkFitScreen();
        float xOnUnit = this.viewXToShareUnitX(x);
        float yOnUnit = this.viewYToShareUnitY(y);
        PointF pixelPosOnContent = this.unitPosToPixelPosOnContent(xOnUnit, yOnUnit, oldZoom);
        this.updateRectContentWithoutResetDestArea();
        if (this.mContentSize == null || this.mContentSize.width == 0) {
            return;
        }
        float pixelXOnContent = pixelPosOnContent.x;
        float pixelYOnContent = pixelPosOnContent.y;
        this.mScaleWidth = (float)((double)this.mContentSize.width * this.mZoomVal);
        this.mScaleHeight = (float)((double)this.mContentSize.height * this.mZoomVal);
        this.resetDestAreaCenter(pixelXOnContent, pixelYOnContent);
        this.notifyViewPortChange(500);
    }

    private PointF getCenterPixelPosOnContent() {
        if (this.mRectContent == null) {
            return null;
        }
        return this.unitPosToPixelPosOnContent(this.mRectContent.width() / 2, this.mRectContent.height() / 2, this.mZoomVal);
    }

    private void resetDestAreaCenter(float pixelX, float pixelY) {
        if (this.mRectContent == null) {
            return;
        }
        this.mContentX = (float)(this.mRectContent.width() / 2) - (float)((double)pixelX * this.mZoomVal);
        this.mContentY = (float)(this.mRectContent.height() / 2) - (float)((double)pixelY * this.mZoomVal);
        this.trimContentPos();
        this.repaint();
    }

    private PointF unitPosToPixelPosOnContent(float x, float y, double zoomVal) {
        float xOnContent = x - this.mContentX;
        float yOnContent = y - this.mContentY;
        float pixelXOnContent = (float)((double)xOnContent / zoomVal);
        float pixelYOnContent = (float)((double)yOnContent / zoomVal);
        return new PointF(pixelXOnContent, pixelYOnContent);
    }

    private void repaint() {
        this.invalidate();
    }

    private void zoomToFitUnit() {
        this.mZoomVal = this.scaleLevelToZoomValue(0);
        this.mIsFitScreen = this.checkFitScreen();
        this.mContentX = 0.0f;
        this.mContentY = 0.0f;
        this.updateRectContentWithoutResetDestArea();
        if (this.mRectContent == null) {
            return;
        }
        this.mScaleWidth = this.mRectContent.width();
        this.mScaleHeight = this.mRectContent.height();
        this.repaint();
        this.notifyViewPortChange(0);
    }

    private float viewXToShareUnitX(float x) {
        if (this.mRectContent == null) {
            return x;
        }
        return x - (float)this.mRectContent.left;
    }

    private float viewYToShareUnitY(float y) {
        if (this.mRectContent == null) {
            return y;
        }
        return y - (float)this.mRectContent.top;
    }

    private double scaleLevelToZoomValue(int level) {
        if (this.mContentSize == null || this.mContentSize.width == 0) {
            return 1.0;
        }
        double minLevelZoomVal = this.getMinLevelZoomValue();
        double maxLevelZoomVal = this.getMaxLevelZoomValue();
        double mediumLevelZoomVal = (minLevelZoomVal + maxLevelZoomVal) * 2.0 / 5.0;
        int levelsCount = this.getScaleLevelsCount();
        if (levelsCount == 1) {
            return Math.min(minLevelZoomVal, maxLevelZoomVal);
        }
        if (levelsCount == 2) {
            switch (level) {
                case 0: {
                    return minLevelZoomVal;
                }
            }
            return maxLevelZoomVal;
        }
        if (levelsCount >= 3) {
            switch (level) {
                case 0: {
                    return minLevelZoomVal;
                }
                case 1: {
                    return mediumLevelZoomVal;
                }
            }
            return maxLevelZoomVal;
        }
        return 0.0;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.mStopFling = true;
        this.mContentX -= distanceX;
        this.mContentY -= distanceY;
        this.trimContentPos();
        this.repaint();
        this.notifyViewPortChange(500);
        return true;
    }

    private void handleScroll(float distanceX, float distanceY) {
        this.mStopFling = true;
        this.mContentX -= distanceX;
        this.mContentY -= distanceY;
        this.trimContentPos();
        this.repaint();
        this.notifyViewPortChange(500);
    }

    private void trimContentPos() {
        if (this.mContentSize == null || this.mRectContent == null) {
            return;
        }
        float contentWidth = (float)(this.mZoomVal * (double)this.mContentSize.width);
        float contentHeight = (float)(this.mZoomVal * (double)this.mContentSize.height);
        if (this.mContentX > 0.0f) {
            if (contentWidth >= (float)this.mRectContent.width()) {
                this.mContentX = 0.0f;
            } else if (this.mContentX + contentWidth > (float)this.mRectContent.width()) {
                this.mContentX = (float)this.mRectContent.width() - contentWidth;
            }
        } else if (contentWidth >= (float)this.mRectContent.width() && this.mContentX + contentWidth < (float)this.mRectContent.width()) {
            this.mContentX = (float)this.mRectContent.width() - contentWidth;
        } else if (contentWidth <= (float)this.mRectContent.width()) {
            this.mContentX = 0.0f;
        }
        if (this.mContentY > 0.0f) {
            if (contentHeight >= (float)this.mRectContent.height()) {
                this.mContentY = 0.0f;
            } else if (this.mContentY + contentHeight > (float)this.mRectContent.height()) {
                this.mContentY = (float)this.mRectContent.height() - contentHeight;
            }
        } else if (contentHeight >= (float)this.mRectContent.height() && this.mContentY + contentHeight < (float)this.mRectContent.height()) {
            this.mContentY = (float)this.mRectContent.height() - contentHeight;
        } else if (contentHeight <= (float)this.mRectContent.height()) {
            this.mContentY = 0.0f;
        }
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.mRectContent == null || this.mContentSize == null) {
            return true;
        }
        if (velocityX > 0.0f) {
            this.mScroller.setFinalX(0);
        } else {
            float contentWidth = (float)(this.mZoomVal * (double)this.mContentSize.width);
            this.mScroller.setFinalX((int)((float)this.mRectContent.width() - contentWidth));
        }
        if (velocityY > 0.0f) {
            this.mScroller.setFinalY(0);
        } else {
            float contentHeight = (float)(this.mZoomVal * (double)this.mContentSize.height);
            this.mScroller.setFinalY((int)((float)this.mRectContent.height() - contentHeight));
        }
        int maxVelocity = UIUtil.dip2px(this.getContext(), 1500.0f);
        if (Math.abs(velocityX) > Math.abs(velocityY)) {
            if (velocityX == 0.0f) {
                velocityX = 0.1f;
            }
            float rate = velocityY / velocityX;
            if (velocityX > (float)maxVelocity) {
                velocityX = maxVelocity;
            } else if (velocityX < (float)(-maxVelocity)) {
                velocityX = -maxVelocity;
            }
            velocityY = velocityX * rate;
        } else {
            if (velocityY == 0.0f) {
                velocityY = 0.1f;
            }
            float rate = velocityX / velocityY;
            if (velocityY > (float)maxVelocity) {
                velocityY = maxVelocity;
            } else if (velocityY < (float)(-maxVelocity)) {
                velocityY = -maxVelocity;
            }
            velocityX = velocityY * rate;
        }
        this.mScroller.fling((int)this.mContentX, (int)this.mContentY, (int)velocityX, (int)velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.mStopFling = false;
        this.handleFling();
        return true;
    }

    private void handleFling() {
        this.mFlingHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!TouchImageView.this.mStopFling && TouchImageView.this.updateContentPosOnFling()) {
                    TouchImageView.this.handleFling();
                }
            }
        }, 40L);
    }

    private boolean updateContentPosOnFling() {
        boolean stop;
        boolean xStopped = false;
        boolean yStopped = false;
        if (this.mRectContent == null || this.mContentSize == null) {
            return false;
        }
        if (!this.mScroller.computeScrollOffset()) {
            return false;
        }
        this.mContentX = this.mScroller.getCurrX();
        if (this.mContentX > 0.0f) {
            this.mContentX = 0.0f;
            xStopped = true;
        } else {
            float contentWidth = (float)(this.mZoomVal * (double)this.mContentSize.width);
            if (this.mContentX + contentWidth < (float)this.mRectContent.width()) {
                this.mContentX = (float)this.mRectContent.width() - contentWidth;
                xStopped = true;
            }
        }
        this.mContentY = this.mScroller.getCurrY();
        if (this.mContentY > 0.0f) {
            this.mContentY = 0.0f;
            yStopped = true;
        } else {
            float contentHeight = (float)(this.mZoomVal * (double)this.mContentSize.height);
            if (this.mContentY + contentHeight < (float)this.mRectContent.height()) {
                this.mContentY = (float)this.mRectContent.height() - contentHeight;
                yStopped = true;
            }
        }
        this.repaint();
        boolean bl = stop = xStopped || yStopped;
        if (stop) {
            this.notifyViewPortChange(0);
        }
        return !stop;
    }

    private void updateRectContentWithoutResetDestArea() {
        this.mRectContent = this.createRectContent(this.mContentSize);
    }

    private Rect createRectContent(Size size) {
        int l;
        int w;
        int h;
        int t;
        int shareWidth = size.width;
        int shareHeight = size.height;
        if (shareWidth == 0 || shareHeight == 0) {
            return null;
        }
        int renderWidth = this.getWidth();
        int renderHeight = this.getHeight();
        if (this.mIsFitScreen && Math.abs(this.mZoomVal - this.getMinLevelZoomValue()) < 0.01) {
            if (renderWidth * shareHeight > renderHeight * shareWidth) {
                t = 0;
                h = renderHeight;
                w = h * shareWidth / shareHeight;
                l = (renderWidth - w) / 2;
            } else {
                l = 0;
                w = renderWidth;
                h = w * shareHeight / shareWidth;
                t = (renderHeight - h) / 2;
            }
        } else {
            float contentWidth = (float)((double)shareWidth * this.mZoomVal);
            float contentHeight = (float)((double)shareHeight * this.mZoomVal);
            if (contentWidth > (float)this.getWidth()) {
                l = 0;
                w = this.getWidth();
            } else {
                w = (int)contentWidth;
                l = (renderWidth - w) / 2;
            }
            if (contentHeight > (float)this.getHeight()) {
                t = 0;
                h = this.getHeight();
            } else {
                h = (int)contentHeight;
                t = (renderHeight - h) / 2;
            }
        }
        return new Rect(l, t, l + w, t + h);
    }

    public static interface OnViewPortChangedListener {
        public void onViewPortChanged();
    }

    static class Size {
        int width = 0;
        int height = 0;

        Size() {
        }
    }

    public static interface OnSingleTapConfirmedListener {
        public void onSingleTapConfirmed();
    }
}

