/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.TimeZoneListAdapter;

public class TimeZoneListView
extends ListView
implements AdapterView.OnItemClickListener {
    private TimeZoneListAdapter mAdapter;
    private String mSelectedId;
    private Listener mListener;

    public TimeZoneListView(Context context) {
        super(context);
        this.initView(context);
    }

    public TimeZoneListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public TimeZoneListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mAdapter = new TimeZoneListAdapter(context, false);
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.setHeaderDividersEnabled(true);
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public void refresh() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.getItemAtPosition(position);
        String timeZoneId = (String)obj;
        if (StringUtil.isEmptyOrNull(timeZoneId)) {
            return;
        }
        this.mSelectedId = timeZoneId;
        if (this.mListener != null) {
            this.mListener.onSelected(this.mSelectedId);
        }
    }

    public String getSelectedName() {
        return this.mSelectedId;
    }

    public static interface Listener {
        public void onSelected(String var1);
    }
}

