/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.UIUtil;

public class QuickSearchSideBar
extends LinearLayout
implements View.OnTouchListener,
View.OnClickListener {
    private float mMaxTextSize = 0.0f;
    private IListener mListener = null;
    private char mLastChar = '\u0000';
    private static final String CATEGORY_CHARS_DEFAULT = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DISPLAY_CHARS_FULL_DEFAULT = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DISPLAY_CHARS_LARGE_DEFAULT = "#AB.IJK.RST.Z";
    private static final String DISPLAY_CHARS_MEDIUM_DEFAULT = "#A.IJ.RS.Z";
    private static final String DISPLAY_CHARS_SMALL_DEFAULT = "#A.I.R.Z";
    private String mCategoryChars = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private String mDisplayCharsFull = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private String mDisplayCharsLarge = "#AB.IJK.RST.Z";
    private String mDisplayCharsMedium = "#A.IJ.RS.Z";
    private String mDisplayCharsSmall = "#A.I.R.Z";

    public QuickSearchSideBar(Context context) {
        super(context);
        this.initView(context);
    }

    public QuickSearchSideBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public QuickSearchSideBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    public void setCategoryChars(String categoryChars, String displayCharsFullSize, String displayCharsLargeSize, String displayCharsMediumSize, String displayCharsSmallSize) {
        if (categoryChars == null || displayCharsFullSize == null || displayCharsLargeSize == null || displayCharsMediumSize == null || displayCharsSmallSize == null) {
            throw new NullPointerException("at least one of arguments is null");
        }
        if (categoryChars.length() != displayCharsFullSize.length()) {
            throw new IllegalArgumentException("length of categoryChars and displayCharsFullSize do not match");
        }
        this.mCategoryChars = categoryChars;
        this.mDisplayCharsFull = displayCharsFullSize;
        this.mDisplayCharsLarge = displayCharsLargeSize;
        this.mDisplayCharsMedium = displayCharsMediumSize;
        this.mDisplayCharsSmall = displayCharsSmallSize;
        this.prebuildCharViews(this.getContext());
    }

    public String getCategoryChars() {
        return this.mCategoryChars;
    }

    public String getDisplayCharsFullSize() {
        return this.mDisplayCharsFull;
    }

    private void initView(Context context) {
        this.setOrientation(1);
        this.setGravity(1);
        this.setBackgroundResource(R.drawable.zm_quick_search_sidebar);
        this.prebuildCharViews(context);
        this.setOnTouchListener(this);
        this.setOnClickListener(this);
    }

    private void prebuildCharViews(Context context) {
        if (this.getChildCount() >= this.mCategoryChars.length()) {
            return;
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, 0);
        params.weight = 1.0f;
        String mask = this.mCategoryChars;
        TextView textView = null;
        for (int i = this.getChildCount(); i < mask.length(); ++i) {
            char c = mask.charAt(i);
            textView = new TextView(context);
            textView.setText((CharSequence)String.valueOf(c));
            textView.setTag((Object)String.valueOf(c));
            textView.setTextColor(-7829368);
            textView.setGravity(17);
            this.addView((View)textView, (ViewGroup.LayoutParams)params);
        }
        this.mMaxTextSize = textView.getTextSize();
    }

    public void setQuickSearchSideBarListener(IListener l) {
        this.mListener = l;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int visibleCount;
        int maxHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float textSize = maxHeight / (visibleCount = this.updateTagsVisibility(maxHeight)) - 4;
        if (textSize > this.mMaxTextSize) {
            textSize = this.mMaxTextSize;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            TextView textView = (TextView)this.getChildAt(i);
            textView.setTextSize(0, textSize);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private int updateTagsVisibility(int maxHeight) {
        float dpHeight = UIUtil.px2dip(this.getContext(), maxHeight);
        String mask = this.mDisplayCharsFull;
        if (dpHeight < 100.0f) {
            mask = this.mDisplayCharsSmall;
        }
        if (dpHeight < 180.0f) {
            mask = this.mDisplayCharsMedium;
        } else if (dpHeight < 300.0f) {
            mask = this.mDisplayCharsLarge;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            TextView textView = (TextView)this.getChildAt(i);
            if (i < mask.length()) {
                String ch = String.valueOf(mask.charAt(i));
                textView.setTag((Object)ch);
                textView.setText((CharSequence)ch);
                textView.setVisibility(0);
                continue;
            }
            textView.setVisibility(8);
        }
        return mask.length();
    }

    public boolean onTouch(View v, MotionEvent event) {
        super.onTouchEvent(event);
        if (this.mListener == null) {
            return true;
        }
        int height = this.getHeight();
        int width = this.getWidth();
        float x = event.getX();
        float y = event.getY();
        if ((x < 0.0f || x > (float)width || y < 0.0f || y > (float)height) && this.mLastChar != '\u0000') {
            this.mListener.onQuickSearchCharReleased(this.mLastChar);
            this.mLastChar = '\u0000';
            return true;
        }
        int categoryCount = this.mCategoryChars.length();
        int idx = (int)y / (height / categoryCount);
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= categoryCount) {
            idx = categoryCount - 1;
        }
        char c = this.mCategoryChars.charAt(idx);
        if (event.getAction() == 1) {
            this.mListener.onQuickSearchCharReleased(c);
            this.mLastChar = '\u0000';
        } else if (event.getAction() == 0) {
            this.mListener.onQuickSearchCharPressed(c);
            this.mLastChar = c;
        } else if (event.getAction() == 2 && this.mLastChar != '\u0000' && c != this.mLastChar) {
            this.mListener.onQuickSearchCharPressed(c);
            this.mLastChar = c;
        }
        return true;
    }

    public void onClick(View v) {
    }

    public static interface IListener {
        public void onQuickSearchCharPressed(char var1);

        public void onQuickSearchCharReleased(char var1);
    }
}

