/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.HashMap;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.PullDownRefreshListView;
import us.zoom.androidlib.widget.QuickSearchListAdapter;
import us.zoom.androidlib.widget.QuickSearchSideBar;

public class QuickSearchListView
extends FrameLayout
implements QuickSearchSideBar.IListener {
    public static final char LAST_GROUP_CATEGORY_CHAR = Short.MAX_VALUE;
    protected static final int SIDEBAR_DISPLAY_THRESHOLD = 5;
    private PullDownRefreshListView mListView;
    private QuickSearchSideBar mQuickSearchSideBar;
    private TextView mTxtQuickSearchChar;
    private QuickSearchListAdapter mAdapter;
    private AdapterView.OnItemClickListener mOnItemClickListener;
    private AdapterView.OnItemLongClickListener mOnItemLongClickListener;
    private View.OnTouchListener mOnTouchListener;
    private AbsListView.OnScrollListener mOnScrollListener;
    private boolean mbQuickSearchEnabled = true;
    private HashMap<Character, String> mCategoryTitlesMap;
    private HashMap<Character, String> mCategoryHintsMap;

    public QuickSearchListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    public QuickSearchListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public QuickSearchListView(Context context) {
        super(context);
        this.initView(context);
    }

    public ListView getListView() {
        return this.mListView;
    }

    public void setPullDownRefreshEnabled(boolean enabled) {
        this.mListView.setPullDownRefreshEnabled(enabled);
    }

    public boolean isPullDownRefreshEnabled() {
        return this.mListView.isPullDownRefreshEnabled();
    }

    public void setPullDownRefreshListener(PullDownRefreshListView.PullDownRefreshListener l) {
        this.mListView.setPullDownRefreshListener(l);
    }

    public void showRefreshing(boolean show) {
        this.mListView.showRefreshing(show);
    }

    public boolean isRefreshing() {
        return this.mListView.isRefreshing();
    }

    public void notifyRefreshDone() {
        this.mListView.notifyRefreshDone();
    }

    private void initView(Context context) {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_quick_search_listview, (ViewGroup)this);
        this.mListView = (PullDownRefreshListView)this.findViewById(R.id.listView);
        this.mQuickSearchSideBar = (QuickSearchSideBar)this.findViewById(R.id.quickSearchSideBar);
        this.mTxtQuickSearchChar = (TextView)this.findViewById(R.id.txtQuickSearchChar);
        this.mCategoryTitlesMap = this.buildDefaultCategoryTitlesFromSideBar(this.mQuickSearchSideBar);
        this.mCategoryHintsMap = this.buildDefaultCategoryTitlesFromSideBar(this.mQuickSearchSideBar);
        this.mQuickSearchSideBar.setQuickSearchSideBarListener(this);
        this.mAdapter = new QuickSearchListAdapter(context, this);
        this.mAdapter.setQuickSearchEnabled(this.isQuickSearchEnabled());
        this.mListView.setPullDownRefreshEnabled(false);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Object item = QuickSearchListView.this.mListView.getItemAtPosition(position);
                if (item instanceof QuickSearchListAdapter.DataItem && QuickSearchListView.this.mOnItemClickListener != null) {
                    QuickSearchListView.this.mOnItemClickListener.onItemClick(parent, view, position, id2);
                }
            }
        });
        this.mListView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                Object item = QuickSearchListView.this.mAdapter.getItem(position);
                if (item instanceof QuickSearchListAdapter.DataItem && QuickSearchListView.this.mOnItemLongClickListener != null) {
                    QuickSearchListView.this.mOnItemLongClickListener.onItemLongClick(parent, view, position, id2);
                }
                return true;
            }
        });
        this.mListView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (QuickSearchListView.this.mOnTouchListener != null) {
                    QuickSearchListView.this.mOnTouchListener.onTouch(v, event);
                }
                return QuickSearchListView.this.mListView.onTouch(v, event);
            }
        });
        this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (QuickSearchListView.this.mOnScrollListener != null) {
                    QuickSearchListView.this.mOnScrollListener.onScrollStateChanged(view, scrollState);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (QuickSearchListView.this.mOnScrollListener != null) {
                    QuickSearchListView.this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
                }
            }
        });
        this.setCategoryTitle((char)Short.MAX_VALUE, null);
    }

    public QuickSearchSideBar getQuickSearchSideBar() {
        return this.mQuickSearchSideBar;
    }

    public void setPullDownRefreshTextResources(int textReleaseToRefresh, int textPullDownToRefresh, int textLoading) {
        this.mListView.setTextResources(textReleaseToRefresh, textPullDownToRefresh, textLoading);
    }

    private HashMap<Character, String> buildDefaultCategoryTitlesFromSideBar(QuickSearchSideBar sideBar) {
        HashMap<Character, String> titlesMap = new HashMap<Character, String>();
        String categoryChars = sideBar.getCategoryChars();
        String displayChars = sideBar.getDisplayCharsFullSize();
        String[] titles = new String[categoryChars.length()];
        for (int i = 0; i < titles.length; ++i) {
            char chCategory = categoryChars.charAt(i);
            char chDisplay = displayChars.charAt(i);
            titlesMap.put(Character.valueOf(chCategory), String.valueOf(chDisplay));
        }
        return titlesMap;
    }

    public void setCategoryChars(String categoryChars, String displayCharsFullSize, String displayCharsLargeSize, String displayCharsMediumSize, String displayCharsSmallSize) {
        this.mQuickSearchSideBar.setCategoryChars(categoryChars, displayCharsFullSize, displayCharsLargeSize, displayCharsMediumSize, displayCharsSmallSize);
        this.mCategoryTitlesMap = this.buildDefaultCategoryTitlesFromSideBar(this.mQuickSearchSideBar);
        this.mCategoryHintsMap = this.buildDefaultCategoryTitlesFromSideBar(this.mQuickSearchSideBar);
        QuickSearchListDataAdapter dataAdapter = this.mAdapter.getDataAdapter();
        if (dataAdapter != null) {
            dataAdapter.notifyDataSetChanged();
        }
    }

    public void setCategoryTitle(char categoryChar, String title) {
        if (this.mCategoryTitlesMap == null) {
            return;
        }
        this.mCategoryTitlesMap.put(Character.valueOf(categoryChar), title);
        QuickSearchListDataAdapter dataAdapter = this.mAdapter.getDataAdapter();
        if (dataAdapter != null) {
            dataAdapter.notifyDataSetChanged();
        }
    }

    public String getCategoryTitle(char categoryChar) {
        if (this.mCategoryTitlesMap == null) {
            return null;
        }
        return this.mCategoryTitlesMap.get(Character.valueOf(categoryChar));
    }

    public void setCategoryHint(char categoryChar, String hint) {
        if (this.mCategoryHintsMap == null) {
            return;
        }
        this.mCategoryHintsMap.put(Character.valueOf(categoryChar), hint);
    }

    public String getCategoryHint(char categoryChar) {
        if (this.mCategoryHintsMap == null) {
            return null;
        }
        return this.mCategoryHintsMap.get(Character.valueOf(categoryChar));
    }

    public void setQuickSearchEnabled(boolean enabled) {
        this.mbQuickSearchEnabled = enabled;
        if (this.getCount() == 0) {
            this.mQuickSearchSideBar.setVisibility(8);
        } else {
            this.mQuickSearchSideBar.setVisibility(this.mbQuickSearchEnabled ? 0 : 8);
        }
        this.mAdapter.setQuickSearchEnabled(this.mbQuickSearchEnabled);
    }

    public boolean isQuickSearchEnabled() {
        return this.mbQuickSearchEnabled;
    }

    public void onResume() {
        this.mTxtQuickSearchChar.setVisibility(8);
    }

    private int getCount() {
        return this.mAdapter.getCount();
    }

    public int getDataItemCount() {
        QuickSearchListDataAdapter dataAdapter = this.mAdapter.getDataAdapter();
        if (dataAdapter == null) {
            return 0;
        }
        return dataAdapter.getCount();
    }

    public Object getItemAtPosition(int position) {
        Object obj = this.mListView.getItemAtPosition(position);
        if (obj == null) {
            return null;
        }
        if (obj instanceof QuickSearchListAdapter.DataItem) {
            return ((QuickSearchListAdapter.DataItem)obj).data;
        }
        return ((QuickSearchListAdapter.GroupHeaderItem)obj).title;
    }

    public void setSelectionFromTop(int position, int y) {
        this.mListView.setSelectionFromTop(position, y);
    }

    public int pointToPosition(int x, int y) {
        return this.mListView.pointToPosition(x, y);
    }

    public void setAdapter(QuickSearchListDataAdapter adapter) {
        this.mAdapter.setDataAdapter(adapter);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onQuickSearchCharPressed(char c) {
        this.scrollToChar(c);
        String hint = this.getCategoryHint(c);
        if (!StringUtil.isEmptyOrNull(hint)) {
            this.mTxtQuickSearchChar.setText((CharSequence)this.getCategoryHint(c));
            this.mTxtQuickSearchChar.setVisibility(0);
        } else {
            this.mTxtQuickSearchChar.setVisibility(8);
        }
    }

    @Override
    public void onQuickSearchCharReleased(char c) {
        this.scrollToChar(c);
        this.mTxtQuickSearchChar.setVisibility(8);
    }

    public void scrollToChar(char c) {
        int i = this.mAdapter.getFirstItemPosFromChar(c);
        this.mListView.setSelection(i);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.mOnItemLongClickListener = listener;
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.mOnTouchListener = listener;
    }

    public void setmOnScrollListener(AbsListView.OnScrollListener mOnScrollListener) {
        this.mOnScrollListener = mOnScrollListener;
    }

    public void setFooterDividersEnabled(boolean enabled) {
        this.mListView.setFooterDividersEnabled(enabled);
    }

    public void setHeaderDividersEnabled(boolean enabled) {
        this.mListView.setHeaderDividersEnabled(enabled);
    }

    protected ListView getmmListView() {
        return this.mListView;
    }

    protected void onDataChanged() {
        if (this.getDataItemCount() <= 5) {
            this.mQuickSearchSideBar.setVisibility(8);
        } else {
            this.mQuickSearchSideBar.setVisibility(this.isQuickSearchEnabled() ? 0 : 8);
        }
    }

    public static abstract class QuickSearchListDataAdapter
    extends BaseAdapter {
        public abstract String getItemSortKey(Object var1);

        public boolean isDataSorted() {
            return false;
        }
    }
}

