/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.androidlib.widget.QuickSearchSideBar;

class QuickSearchListAdapter
extends BaseAdapter {
    private static final int ITEM_TYPE_GROUP_HEADER = 0;
    private QuickSearchListView.QuickSearchListDataAdapter mDataAdapter;
    private ArrayList<Object> mItems = new ArrayList();
    private Context mContext;
    private QuickSearchListView mListView;
    private boolean mbQuickSearchEnabled = true;
    private Handler mHandler = new Handler();
    private Runnable mRebuildItemsRunnable = new Runnable(){

        @Override
        public void run() {
            QuickSearchListAdapter.this.rebuildItems();
            QuickSearchListAdapter.this.notifyDataSetChanged();
        }
    };
    private DataSetObserver mDataAdapterObserver = new DataSetObserver(){

        public void onChanged() {
            this.rebuildItemsLater();
        }

        public void onInvalidated() {
            QuickSearchListAdapter.this.rebuildItems();
            QuickSearchListAdapter.this.notifyDataSetInvalidated();
        }

        private void rebuildItemsLater() {
            QuickSearchListAdapter.this.mHandler.removeCallbacks(QuickSearchListAdapter.this.mRebuildItemsRunnable);
            QuickSearchListAdapter.this.mHandler.postAtFrontOfQueue(QuickSearchListAdapter.this.mRebuildItemsRunnable);
        }
    };

    public QuickSearchListAdapter(Context context, QuickSearchListView listView) {
        this.mContext = context;
        this.mListView = listView;
    }

    public void setQuickSearchEnabled(boolean enabled) {
        if (enabled == this.mbQuickSearchEnabled) {
            return;
        }
        this.mbQuickSearchEnabled = enabled;
        this.rebuildItems();
    }

    public void setDataAdapter(QuickSearchListView.QuickSearchListDataAdapter dataAdapter) {
        this.mDataAdapter = dataAdapter;
        this.mDataAdapter.registerDataSetObserver(this.mDataAdapterObserver);
        this.rebuildItems();
    }

    public QuickSearchListView.QuickSearchListDataAdapter getDataAdapter() {
        return this.mDataAdapter;
    }

    public int getFirstItemPosFromChar(char c) {
        int pos = Collections.binarySearch(this.mItems, String.valueOf(c), new QuickSearchListItemComparator(CompatUtils.getLocalDefault(), this.mDataAdapter));
        if (pos < 0) {
            pos = -pos - 1;
        }
        return ++pos;
    }

    private void rebuildItems() {
        if (this.mDataAdapter == null) {
            return;
        }
        this.mItems.clear();
        ArrayList<DataItem> list = new ArrayList<DataItem>();
        for (int i = 0; i < this.mDataAdapter.getCount(); ++i) {
            list.add(new DataItem(this.mDataAdapter.getItem(i), i));
        }
        Locale locale = CompatUtils.getLocalDefault();
        if (this.mbQuickSearchEnabled && !this.mDataAdapter.isDataSorted()) {
            Collections.sort(list, new DataItemComparator(locale, this.mDataAdapter));
        }
        Collator collator = Collator.getInstance(locale);
        collator.setStrength(0);
        GroupHeaderItem lastHeader = null;
        for (int i = 0; i < list.size(); ++i) {
            DataItem item = (DataItem)list.get(i);
            if (this.mbQuickSearchEnabled) {
                char groupChar = this.getGroupChar(item, collator);
                if (lastHeader == null || groupChar != lastHeader.key) {
                    String title = this.mListView != null ? this.mListView.getCategoryTitle(groupChar) : null;
                    lastHeader = new GroupHeaderItem(groupChar, title);
                    if (title != null) {
                        this.mItems.add(lastHeader);
                    }
                }
            }
            this.mItems.add(item);
        }
        if (this.mListView != null) {
            this.mListView.onDataChanged();
        }
    }

    private char getGroupChar(DataItem item, Collator collator) {
        String key = this.mDataAdapter.getItemSortKey(item.data);
        if (StringUtil.isEmptyOrNull(key)) {
            return '#';
        }
        if ((key = key.substring(0, 1)).charAt(0) == Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        char c = key.charAt(0);
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
            return c;
        }
        if (c >= 'A' && c <= 'Z') {
            return c;
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            int res = collator.compare(String.valueOf(c), key);
            if (res != 0) continue;
            return c;
        }
        QuickSearchSideBar sidebar = this.mListView.getQuickSearchSideBar();
        if (sidebar != null && sidebar.getCategoryChars().indexOf(key) >= 0) {
            return key.charAt(0);
        }
        return '#';
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return -1;
        }
        Object item = this.getItem(position);
        if (item instanceof DataItem) {
            DataItem dataItem = (DataItem)item;
            return this.mDataAdapter.getItemViewType(dataItem.index) + 1;
        }
        if (item instanceof GroupHeaderItem) {
            return 0;
        }
        return -1;
    }

    public boolean isEnabled(int position) {
        if (UIUtil.isTV(this.mContext)) {
            int type = this.getItemViewType(position);
            return type != 0;
        }
        return true;
    }

    public int getViewTypeCount() {
        if (this.mDataAdapter == null) {
            return 2;
        }
        return this.mDataAdapter.getViewTypeCount() + 1;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.mItems.size()) {
            return new View(this.mContext);
        }
        Object item = this.getItem(position);
        if (item instanceof DataItem) {
            DataItem dataItem = (DataItem)item;
            View view = this.mDataAdapter.getView(dataItem.index, convertView, parent);
            if (view == null) {
                return new View(this.mContext);
            }
            int tagKey = R.id.zm_quick_search_list_item_reset_padding_flag;
            if (this.mListView.isQuickSearchEnabled() && this.mDataAdapter.getCount() > 5) {
                Boolean paddingReset = (Boolean)view.getTag(tagKey);
                if (paddingReset == null || !paddingReset.booleanValue()) {
                    int left = view.getPaddingLeft();
                    int top = view.getPaddingTop();
                    int right = view.getPaddingRight() + UIUtil.dip2px(this.mContext, 25.0f);
                    int bottom = view.getPaddingBottom();
                    view.setPadding(left, top, right, bottom);
                    view.setTag(tagKey, (Object)Boolean.TRUE);
                }
            } else {
                Boolean paddingReset = (Boolean)view.getTag(tagKey);
                if (paddingReset != null && paddingReset.booleanValue()) {
                    int left = view.getPaddingLeft();
                    int top = view.getPaddingTop();
                    int right = view.getPaddingRight() - UIUtil.dip2px(this.mContext, 25.0f);
                    int bottom = view.getPaddingBottom();
                    view.setPadding(left, top, right, bottom);
                    view.setTag(tagKey, (Object)Boolean.FALSE);
                }
            }
            return view;
        }
        if (item instanceof GroupHeaderItem) {
            return this.newGroupHeaderView(position, (GroupHeaderItem)item, convertView, parent);
        }
        return new View(this.mContext);
    }

    private View newGroupHeaderView(int position, GroupHeaderItem item, View convertView, ViewGroup parent) {
        View view = null;
        if (convertView != null && "us.zoom.androidlib.widget.QuickSearchListView.header".equals(convertView.getTag())) {
            view = convertView;
        } else {
            LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
            view = factory.inflate(R.layout.zm_quick_search_list_items_header, parent, false);
            view.setTag((Object)"us.zoom.androidlib.widget.QuickSearchListView.header");
        }
        TextView txtHeader = (TextView)view.findViewById(R.id.txtHeader);
        if (txtHeader != null) {
            txtHeader.setText((CharSequence)item.title);
        }
        return view;
    }

    static class QuickSearchListItemComparator
    implements Comparator<Object> {
        private Collator mCollator;
        private QuickSearchListView.QuickSearchListDataAdapter mDataAdapter;

        public QuickSearchListItemComparator(Locale locale, QuickSearchListView.QuickSearchListDataAdapter dataAdapter) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
            this.mDataAdapter = dataAdapter;
        }

        @Override
        public int compare(Object lhs, Object rhs) {
            if (lhs == rhs) {
                return 0;
            }
            String str1 = null;
            String str2 = null;
            str1 = lhs instanceof DataItem ? this.mDataAdapter.getItemSortKey(((DataItem)lhs).data) : (lhs instanceof GroupHeaderItem ? String.valueOf(((GroupHeaderItem)lhs).key) : lhs.toString());
            str2 = rhs instanceof DataItem ? this.mDataAdapter.getItemSortKey(((DataItem)rhs).data) : (rhs instanceof GroupHeaderItem ? String.valueOf(((GroupHeaderItem)rhs).key) : rhs.toString());
            return this.mCollator.compare(str1, str2);
        }
    }

    static class DataItemComparator
    implements Comparator<DataItem> {
        private Collator mCollator;
        private QuickSearchListView.QuickSearchListDataAdapter mDataAdapter;

        public DataItemComparator(Locale locale, QuickSearchListView.QuickSearchListDataAdapter dataAdapter) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
            this.mDataAdapter = dataAdapter;
        }

        @Override
        public int compare(DataItem lhs, DataItem rhs) {
            if (lhs == rhs) {
                return 0;
            }
            String str1 = this.mDataAdapter.getItemSortKey(lhs.data);
            String str2 = this.mDataAdapter.getItemSortKey(rhs.data);
            if (str1 == null) {
                str1 = "";
            }
            if (str2 == null) {
                str2 = "";
            }
            if (str1.equals(str2)) {
                return 0;
            }
            if (str1.length() == 1 && str1.charAt(0) == Short.MAX_VALUE) {
                return 1;
            }
            if (str2.length() == 1 && str2.charAt(0) == Short.MAX_VALUE) {
                return -1;
            }
            return this.mCollator.compare(str1, str2);
        }
    }

    static class GroupHeaderItem {
        char key;
        String title;

        public GroupHeaderItem(char key, String title) {
            this.key = key;
            this.title = title;
        }
    }

    static class DataItem {
        Object data;
        int index;

        public DataItem(Object data, int index) {
            this.data = data;
            this.index = index;
        }
    }
}

