/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.TextView;
import java.util.Locale;
import us.zoom.androidlib.util.CaptionStyleCompat;
import us.zoom.androidlib.util.CaptionUtil;
import us.zoom.androidlib.util.UIUtil;

public class CaptionTextView
extends TextView {
    private int mShadowRadius;
    private int mTwoDpInPx;
    private RectF mBgRect;
    private Paint mBgPaint;

    public CaptionTextView(Context context) {
        super(context);
        this.initView(context);
    }

    public CaptionTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public CaptionTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @SuppressLint(value={"NewApi"})
    public CaptionTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mShadowRadius = this.mTwoDpInPx = UIUtil.dip2px(context, 2.0f);
        if (this.isInEditMode()) {
            this.setTextSize(16.0f);
            this.setBackgroundColor(-16777216);
            this.setTextColor(-1);
        } else {
            this.initCaptionInfo();
        }
    }

    private void refresh() {
        this.initCaptionInfo();
    }

    private void initCaptionInfo() {
        float scale = CaptionUtil.getCaptionFontScale(this.getContext());
        this.setTextSize(16.0f * scale);
        Locale locale = CaptionUtil.getLocale(this.getContext());
        if (locale != null && Build.VERSION.SDK_INT >= 17) {
            this.setLocaleV17(locale);
        }
        CaptionStyleCompat style2 = CaptionUtil.getCaptionStyle(this.getContext());
        if (style2.typeface != null) {
            this.setTypeface(style2.typeface);
        }
        this.setTextColor(style2.foregroundColor);
    }

    @TargetApi(value=17)
    private void setLocaleV17(Locale locale) {
        this.setTextLocale(locale);
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.refresh();
    }

    protected void onDraw(Canvas canvas) {
        if (this.isInEditMode()) {
            super.onDraw(canvas);
            return;
        }
        ColorStateList textColor = this.getTextColors();
        CaptionStyleCompat style2 = CaptionUtil.getCaptionStyle(this.getContext());
        TextPaint paint = this.getPaint();
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(style2.foregroundColor);
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        if (this.mBgPaint == null) {
            this.mBgPaint = new Paint();
        }
        this.mBgPaint.setStyle(Paint.Style.FILL);
        this.mBgPaint.setColor(style2.backgroundColor);
        this.mBgPaint.setAntiAlias(true);
        if (this.mBgRect == null) {
            this.mBgRect = new RectF();
        }
        this.mBgRect.left = 0.0f;
        this.mBgRect.top = 0.0f;
        this.mBgRect.right = this.getWidth();
        this.mBgRect.bottom = this.getHeight();
        int radius = UIUtil.dip2px(this.getContext(), 5.0f);
        canvas.drawRoundRect(this.mBgRect, (float)radius, (float)radius, this.mBgPaint);
        switch (style2.edgeType) {
            case 1: {
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeJoin(Paint.Join.ROUND);
                paint.setStrokeMiter(10.0f);
                paint.setStrokeWidth((float)UIUtil.dip2px(this.getContext(), 2.0f));
                this.setTextColor(style2.edgeColor);
                super.onDraw(canvas);
                paint.setStyle(Paint.Style.FILL);
                this.setTextColor(textColor);
                super.onDraw(canvas);
                break;
            }
            case 2: {
                float offset = this.mShadowRadius;
                this.setShadowLayer(this.mShadowRadius, offset, offset, style2.edgeColor);
                super.onDraw(canvas);
                break;
            }
            case 3: 
            case 4: {
                boolean raise = style2.edgeType == 3;
                float offset = raise ? (float)this.mShadowRadius / 2.0f : (float)(-this.mShadowRadius) / 2.0f;
                this.setShadowLayer(this.mShadowRadius, offset, offset, style2.edgeColor);
                super.onDraw(canvas);
                break;
            }
            default: {
                super.onDraw(canvas);
            }
        }
    }
}

