/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import us.zoom.androidlib.util.ILogger;

public class ZMLog {
    private static ILogger logger = new ILogger(){

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public int getLevel() {
            return 1;
        }

        @Override
        public boolean needLogThreadId() {
            return false;
        }

        @Override
        public void log(int level, String tag, String msg, Throwable t) {
        }
    };

    public static void setLogger(ILogger logger) {
        ZMLog.logger = logger;
    }

    public static boolean isLogEnabled() {
        if (logger != null) {
            return logger.isEnabled();
        }
        return false;
    }

    public static void d(String tag, String format, Object ... args) {
        ZMLog.i(tag, format, args);
    }

    public static void d(String tag, Throwable t, String format, Object ... args) {
        ZMLog.i(tag, t, format, args);
    }

    public static void i(String tag, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 1) {
            return;
        }
        String msg = ZMLog.formatMsg(format, args);
        ZMLog.i(tag, (Throwable)null, msg, new Object[0]);
    }

    public static void i(String tag, Throwable t, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 1) {
            return;
        }
        String msg = ZMLog.getPrefix() + ZMLog.formatMsg(format, args);
        ZMLog.writeLog(1, tag, msg, t);
    }

    public static void w(String tag, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 2) {
            return;
        }
        String msg = ZMLog.formatMsg(format, args);
        ZMLog.w(tag, (Throwable)null, msg, new Object[0]);
    }

    public static void w(String tag, Throwable t, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 2) {
            return;
        }
        String msg = ZMLog.getPrefix() + ZMLog.formatMsg(format, args);
        ZMLog.writeLog(2, tag, msg, t);
    }

    public static void e(String tag, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 3) {
            return;
        }
        String msg = ZMLog.formatMsg(format, args);
        ZMLog.e(tag, (Throwable)null, msg, new Object[0]);
    }

    public static void e(String tag, Throwable t, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 3) {
            return;
        }
        String msg = ZMLog.getPrefix() + ZMLog.formatMsg(format, args);
        ZMLog.writeLog(3, tag, msg, t);
    }

    public static void er(String tag, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 4) {
            return;
        }
        String msg = ZMLog.formatMsg(format, args);
        ZMLog.er(tag, (Throwable)null, msg, new Object[0]);
    }

    public static void er(String tag, Throwable t, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 4) {
            return;
        }
        String msg = ZMLog.getPrefix() + ZMLog.formatMsg(format, args);
        ZMLog.writeLog(4, tag, msg, t);
    }

    public static void f(String tag, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 5) {
            return;
        }
        String msg = ZMLog.formatMsg(format, args);
        ZMLog.f(tag, (Throwable)null, msg, new Object[0]);
    }

    public static void f(String tag, Throwable t, String format, Object ... args) {
        if (logger == null || !logger.isEnabled() || logger.getLevel() > 5) {
            return;
        }
        String msg = ZMLog.getPrefix() + ZMLog.formatMsg(format, args);
        ZMLog.writeLog(5, tag, msg, t);
    }

    private static String formatMsg(String format, Object ... args) {
        if (format == null) {
            return "";
        }
        String msg = format;
        if (args != null && args.length > 0) {
            msg = String.format(format, args);
        }
        return msg;
    }

    private static String getPrefix() {
        if (logger == null) {
            return null;
        }
        String prefix = null;
        prefix = !logger.needLogThreadId() ? "" : String.format("[T:%d]", ZMLog.getThreadId());
        return prefix;
    }

    private static long getThreadId() {
        return Thread.currentThread().getId();
    }

    private static void writeLog(int level, String tag, String msg, Throwable t) {
        if (logger == null) {
            return;
        }
        logger.log(level, tag, msg, t);
    }
}

