/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import us.zoom.androidlib.cache.IoUtils;
import us.zoom.androidlib.cache.impl.LimitedAgeDiskCache;
import us.zoom.androidlib.util.ZMAsyncTask;

public class ZMDownloadDiscCacheFile
extends ZMAsyncTask<Void, Integer, Runnable> {
    private IDownloadFileListener mListener;
    private String mUrl;
    private LimitedAgeDiskCache diskCache;

    public ZMDownloadDiscCacheFile(IDownloadFileListener mListener, String mUrl, LimitedAgeDiskCache diskCache) {
        this.mListener = mListener;
        this.mUrl = mUrl;
        this.diskCache = diskCache;
    }

    protected Runnable doInBackground(Void ... params) {
        if (TextUtils.isEmpty((CharSequence)this.mUrl) || this.diskCache == null) {
            return new OnErrorRunnable();
        }
        if (this.isCancelled()) {
            return new onCanceledRunnable();
        }
        try {
            URL url = new URL(this.mUrl);
            URLConnection connection = url.openConnection();
            ContentLengthInputStream is = new ContentLengthInputStream(connection.getInputStream(), connection.getContentLength());
            this.diskCache.save(this.mUrl, is, new IoUtils.CopyListener(){

                @Override
                public boolean onBytesCopied(int current, int total) {
                    return ZMDownloadDiscCacheFile.this.fireProgressEvent(current, total);
                }
            });
        }
        catch (Exception e) {
            return new OnErrorRunnable();
        }
        if (this.isCancelled()) {
            return new onCanceledRunnable();
        }
        return new onCompeletedRunnable();
    }

    private boolean fireProgressEvent(int current, int total) {
        if (this.isTaskInterrupted()) {
            return false;
        }
        this.publishProgress(current, total);
        return true;
    }

    private boolean isTaskInterrupted() {
        return Thread.interrupted();
    }

    @Override
    protected void onPostExecute(Runnable result) {
        result.run();
    }

    protected void onProgressUpdate(Integer ... values) {
        int totalBytes = values[1];
        int bytesRead = values[0];
        if (this.mListener != null) {
            this.mListener.onDownloadProgress(this, totalBytes, bytesRead);
        }
    }

    private class onCanceledRunnable
    implements Runnable {
        private onCanceledRunnable() {
        }

        @Override
        public void run() {
            if (ZMDownloadDiscCacheFile.this.mListener != null) {
                ZMDownloadDiscCacheFile.this.mListener.onDownloadCanceled(ZMDownloadDiscCacheFile.this, ZMDownloadDiscCacheFile.this.mUrl);
            }
        }
    }

    private class onCompeletedRunnable
    implements Runnable {
        private onCompeletedRunnable() {
        }

        @Override
        public void run() {
            if (ZMDownloadDiscCacheFile.this.mListener != null) {
                ZMDownloadDiscCacheFile.this.mListener.onDownloadCompleted(ZMDownloadDiscCacheFile.this, ZMDownloadDiscCacheFile.this.mUrl, ZMDownloadDiscCacheFile.this.diskCache);
            }
        }
    }

    private class OnErrorRunnable
    implements Runnable {
        private OnErrorRunnable() {
        }

        @Override
        public void run() {
            if (ZMDownloadDiscCacheFile.this.mListener != null) {
                ZMDownloadDiscCacheFile.this.mListener.onDownloadFailed(ZMDownloadDiscCacheFile.this, ZMDownloadDiscCacheFile.this.mUrl);
            }
        }
    }

    public class ContentLengthInputStream
    extends InputStream {
        private final InputStream stream;
        private final int length;

        public ContentLengthInputStream(InputStream stream, int length) {
            this.stream = stream;
            this.length = length;
        }

        @Override
        public int available() {
            return this.length;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public void mark(int readLimit) {
            this.stream.mark(readLimit);
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.stream.read(buffer);
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            return this.stream.read(buffer, byteOffset, byteCount);
        }

        @Override
        public void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long byteCount) throws IOException {
            return this.stream.skip(byteCount);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }

    public static interface IDownloadFileListener {
        public void onDownloadCompleted(ZMDownloadDiscCacheFile var1, String var2, LimitedAgeDiskCache var3);

        public void onDownloadFailed(ZMDownloadDiscCacheFile var1, String var2);

        public void onDownloadProgress(ZMDownloadDiscCacheFile var1, int var2, int var3);

        public void onDownloadCanceled(ZMDownloadDiscCacheFile var1, String var2);
    }
}

