/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.net.Uri;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import us.zoom.androidlib.util.IDownloadFileListener;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncTask;

public class ZMAsyncURLDownloadFile
extends ZMAsyncTask<Void, Long, Runnable> {
    private IDownloadFileListener mListener;
    private Uri mInput;
    private String mOutput;
    private long mTotalBytes;
    private long mReadBytes;
    private static int BUFFER_SIZE = 1024;

    public ZMAsyncURLDownloadFile(Uri input, long totalBytes, String output, IDownloadFileListener l) {
        this.mInput = input;
        this.mOutput = output;
        this.mListener = l;
        this.mTotalBytes = totalBytes;
        this.mReadBytes = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable doInBackground(Void ... params) {
        BufferedOutputStream out;
        InputStream is;
        if (this.mInput == null || StringUtil.isEmptyOrNull(this.mOutput)) {
            return new OnErrorRunnable();
        }
        if (this.isCancelled()) {
            return new onCanceledRunnable();
        }
        try {
            URL url = new URL(this.mInput.toString());
            is = url.openConnection().getInputStream();
        }
        catch (Exception e) {
            return new OnErrorRunnable();
        }
        byte[] buffer = new byte[BUFFER_SIZE];
        try {
            out = new BufferedOutputStream(new FileOutputStream(this.mOutput));
        }
        catch (FileNotFoundException e1) {
            this.closeSilently(is);
            return new OnErrorRunnable();
        }
        try {
            int bytesRead;
            while ((bytesRead = is.read(buffer)) != -1) {
                if (this.isCancelled()) {
                    onCanceledRunnable onCanceledRunnable2 = new onCanceledRunnable();
                    return onCanceledRunnable2;
                }
                ((OutputStream)out).write(buffer, 0, bytesRead);
                this.mReadBytes += (long)bytesRead;
                this.publishProgress(this.mTotalBytes, this.mReadBytes);
            }
        }
        catch (IOException e) {
            OnErrorRunnable onErrorRunnable = new OnErrorRunnable();
            return onErrorRunnable;
        }
        finally {
            this.closeSilently(is);
            this.closeSilently(out);
        }
        if (this.isCancelled()) {
            return new onCanceledRunnable();
        }
        return new onCompeletedRunnable();
    }

    @Override
    protected void onPostExecute(Runnable result) {
        result.run();
    }

    protected void onProgressUpdate(Long ... values) {
        long totalBytes = values[0];
        long bytesRead = values[1];
        if (this.mListener != null) {
            this.mListener.onDownloadProgress(this, totalBytes, bytesRead);
        }
    }

    public String getmOutput() {
        return this.mOutput;
    }

    private void closeSilently(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class onCanceledRunnable
    implements Runnable {
        private onCanceledRunnable() {
        }

        @Override
        public void run() {
            if (ZMAsyncURLDownloadFile.this.mListener != null) {
                ZMAsyncURLDownloadFile.this.mListener.onDownloadCanceled(ZMAsyncURLDownloadFile.this, ZMAsyncURLDownloadFile.this.mInput);
            }
        }
    }

    private class onCompeletedRunnable
    implements Runnable {
        private onCompeletedRunnable() {
        }

        @Override
        public void run() {
            if (ZMAsyncURLDownloadFile.this.mListener != null) {
                ZMAsyncURLDownloadFile.this.mListener.onDownloadCompleted(ZMAsyncURLDownloadFile.this, ZMAsyncURLDownloadFile.this.mInput, ZMAsyncURLDownloadFile.this.mOutput);
            }
        }
    }

    private class OnErrorRunnable
    implements Runnable {
        private OnErrorRunnable() {
        }

        @Override
        public void run() {
            if (ZMAsyncURLDownloadFile.this.mListener != null) {
                ZMAsyncURLDownloadFile.this.mListener.onDownloadFailed(ZMAsyncURLDownloadFile.this, ZMAsyncURLDownloadFile.this.mInput);
            }
        }
    }
}

