/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.Notification;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.PowerManager;
import android.support.v4.app.FragmentManager;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import us.zoom.androidlib.R;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;

public class UIUtil {
    private static final String TAG = UIUtil.class.getSimpleName();
    private static final int MIUI_VERSION_NOT_SET = -2;
    public static final int MIUI_VERSION_UNDEFINED = -1;
    public static final int MIUI_VERSION_V2 = 0;
    public static final int MIUI_VERSION_V3 = 1;
    public static final int MIUI_VERSION_V4 = 2;
    public static final int MIUI_VERSION_V5 = 3;
    public static final int MIUI_VERSION_V6 = 4;
    private static final int TABLET_MIN_SCREEN_SIZE = 520;
    private static int gMiuiVersionCode = -2;
    private static PowerManager.WakeLock gProxiWakeLock;

    public static int dip2px(Context context, float value) {
        if (context == null) {
            return (int)value;
        }
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(value * density + 0.5f);
    }

    public static float px2dip(Context context, int value) {
        if (context == null) {
            return value;
        }
        float density = context.getResources().getDisplayMetrics().density;
        return (float)value / density;
    }

    public static boolean isNavtiveSupportIOSEmoji() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static int sp2px(Context context, float value) {
        if (context == null) {
            return (int)value;
        }
        float density = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(value * density + 0.5f);
    }

    public static float px2sp(Context context, int value) {
        if (context == null) {
            return value;
        }
        float density = context.getResources().getDisplayMetrics().scaledDensity;
        return (float)value / density;
    }

    public static float getDisplayMinWidthInDip(Context context) {
        int width = UIUtil.getDisplayWidth(context);
        int height = UIUtil.getDisplayHeight(context);
        width = Math.min(width, height);
        return UIUtil.px2dip(context, width);
    }

    public static boolean isFullScreen(Activity activity) {
        if (activity == null) {
            return false;
        }
        int flag = activity.getWindow().getAttributes().flags;
        return (flag & 0x400) == 1024;
    }

    public static void closeSoftKeyboard(Context context, View view) {
        if (context == null || view == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void closeSoftKeyboardInActivity(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.getDecorView();
        if (view == null) {
            return;
        }
        IBinder windowToken = view.getWindowToken();
        if (windowToken == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        imm.hideSoftInputFromWindow(windowToken, 0);
    }

    public static void openSoftKeyboard(Context context, View view) {
        if (context == null || view == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.showSoftInput(view, 0);
    }

    public static int getDisplayWidth(Context context) {
        WindowManager windowMgr = (WindowManager)context.getSystemService("window");
        if (windowMgr == null) {
            return 0;
        }
        Display display = windowMgr.getDefaultDisplay();
        return display.getWidth();
    }

    public static float getDisplayWidthInDip(Context context) {
        int widthPixels = UIUtil.getDisplayWidth(context);
        return UIUtil.px2dip(context, widthPixels);
    }

    public static int getDisplayHeight(Context context) {
        WindowManager windowMgr = (WindowManager)context.getSystemService("window");
        if (windowMgr == null) {
            return 0;
        }
        Display display = windowMgr.getDefaultDisplay();
        return display.getHeight();
    }

    public static float getDisplayHeightInDip(Context context) {
        int heightPixels = UIUtil.getDisplayHeight(context);
        return UIUtil.px2dip(context, heightPixels);
    }

    public static int getMetricWith(Context context) {
        DisplayMetrics metric = context.getApplicationContext().getResources().getDisplayMetrics();
        return metric.widthPixels;
    }

    public static int getMetricHeight(Context context) {
        DisplayMetrics metric = context.getApplicationContext().getResources().getDisplayMetrics();
        return metric.heightPixels;
    }

    public static int getCurrentOrientation(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public static boolean isPortraitMode(Context context) {
        int orientation = context.getResources().getConfiguration().orientation;
        return orientation == 1;
    }

    public static boolean isLandscapeMode(Context context) {
        int orientation = context.getResources().getConfiguration().orientation;
        return orientation == 2;
    }

    public static boolean isXLargeScreen(Context context) {
        Configuration config = context.getResources().getConfiguration();
        int size = config.screenLayout & 0xF;
        return size >= 4;
    }

    public static boolean isLargeScreen(Context context) {
        Configuration config = context.getResources().getConfiguration();
        int size = config.screenLayout & 0xF;
        return size >= 3;
    }

    public static boolean isPhone(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return false;
        }
        return pm.hasSystemFeature("android.hardware.telephony");
    }

    public static boolean isSmallScreen(Context context) {
        if (context == null) {
            return false;
        }
        return UIUtil.getDisplayHeightInDip(context) < 520.0f || UIUtil.getDisplayWidthInDip(context) < 520.0f;
    }

    public static boolean isTabletOrTV(Context context) {
        if (context == null) {
            return false;
        }
        return UIUtil.isTablet(context) || UIUtil.isTV(context);
    }

    public static boolean isTablet(Context context) {
        if (context == null) {
            return false;
        }
        return UIUtil.getDisplayHeightInDip(context) >= 520.0f && UIUtil.getDisplayWidthInDip(context) >= 520.0f && !UIUtil.isTV(context);
    }

    public static boolean isTV(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 16) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return pm.hasSystemFeature("android.hardware.type.television");
        }
        return pm.hasSystemFeature("android.hardware.type.television") || pm.hasSystemFeature("android.software.leanback");
    }

    public static String getScreenCategoryName(Context context) {
        Configuration config = context.getResources().getConfiguration();
        int size = config.screenLayout & 0xF;
        String category = null;
        category = size >= 4 ? "xlarge" : (size >= 3 ? "large" : (size >= 2 ? "normal" : "small"));
        return category;
    }

    public static Rect getAbsoluteRect(View view) {
        if (view == null) {
            return null;
        }
        Rect rect = new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            Rect rcParent = UIUtil.getAbsoluteRect((View)((ViewGroup)parent));
            rect.left += rcParent.left;
            rect.top += rcParent.top;
            rect.right += rcParent.left;
            rect.bottom += rcParent.top;
        }
        return rect;
    }

    public static boolean openURL(Context context, String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        try {
            Uri uri = Uri.parse((String)url);
            String scheme = uri.getScheme();
            if (StringUtil.isEmptyOrNull(scheme)) {
                url = "http://" + url;
            } else {
                int schemeLen = scheme.length();
                url = scheme.toLowerCase() + url.substring(schemeLen);
            }
            uri = Uri.parse((String)url);
            Intent intent = new Intent();
            intent.addFlags(0x10000000);
            intent.setAction("android.intent.action.VIEW");
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.setData(uri);
            context.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getDefaultOrientation(Context context) {
        WindowManager windowMgr = (WindowManager)context.getSystemService("window");
        if (windowMgr == null) {
            return 0;
        }
        Display display = windowMgr.getDefaultDisplay();
        int rotation = display.getRotation();
        int width = 0;
        int height = 0;
        switch (rotation) {
            case 0: 
            case 2: {
                width = display.getWidth();
                height = display.getHeight();
                break;
            }
            case 1: 
            case 3: {
                width = display.getHeight();
                height = display.getWidth();
                break;
            }
        }
        if (width > height) {
            return 0;
        }
        return 1;
    }

    public static synchronized void startProximityScreenOffWakeLock(Context context) {
        if (gProxiWakeLock != null && gProxiWakeLock.isHeld()) {
            return;
        }
        try {
            PowerManager pm = (PowerManager)context.getSystemService("power");
            gProxiWakeLock = pm.newWakeLock(32, UIUtil.class.getName() + ":proximitiy");
            if (gProxiWakeLock != null) {
                gProxiWakeLock.acquire();
            }
        }
        catch (Exception e) {
            ZMLog.w(TAG, e, "startProximityScreenOffWakeLock failure", new Object[0]);
        }
    }

    public static synchronized void stopProximityScreenOffWakeLock() {
        if (gProxiWakeLock != null) {
            try {
                gProxiWakeLock.release();
            }
            catch (Exception e) {
                ZMLog.w(TAG, e, "stopProximityScreenOffWakeLock failure", new Object[0]);
            }
            gProxiWakeLock = null;
        }
    }

    public static void buildLinkTextView(TextView view, String text, final View.OnClickListener listener) {
        if (StringUtil.isEmptyOrNull(text)) {
            return;
        }
        view.setMovementMethod(LinkMovementMethod.getInstance());
        SpannableString spannableString = new SpannableString((CharSequence)text);
        URLSpan urlSpan = new URLSpan(""){

            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
            }
        };
        spannableString.setSpan((Object)urlSpan, 0, text.length(), 33);
        view.setText((CharSequence)spannableString);
    }

    public static Dialog showSimpleMessageDialog(Activity activity, String title, String message) {
        if (activity == null) {
            return null;
        }
        ZMAlertDialog dlg = new ZMAlertDialog.Builder((Context)activity).setTitle(title).setMessage(message).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
        return dlg;
    }

    public static Dialog showSimpleMessageDialog(Activity activity, int title, int message) {
        if (activity == null) {
            return null;
        }
        String sTitle = title > 0 ? activity.getString(title) : null;
        String sMessage = message > 0 ? activity.getString(message) : null;
        return UIUtil.showSimpleMessageDialog(activity, sTitle, sMessage);
    }

    public static ProgressDialog showSimpleWaitingDialog(Activity activity, String message) {
        if (activity == null) {
            return null;
        }
        ProgressDialog dlg = new ProgressDialog((Context)activity);
        dlg.requestWindowFeature(1);
        dlg.setMessage((CharSequence)message);
        dlg.setCanceledOnTouchOutside(false);
        dlg.show();
        return dlg;
    }

    public static ProgressDialog showSimpleWaitingDialog(Activity activity, int message) {
        if (activity == null) {
            return null;
        }
        String sMessage = message > 0 ? activity.getString(message) : "";
        return UIUtil.showSimpleWaitingDialog(activity, sMessage);
    }

    @SuppressLint(value={"NewApi"})
    public static boolean setTranslucentStatus(Activity activity, boolean on) {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        if (activity == null) {
            return false;
        }
        Window win = activity.getWindow();
        if (win == null) {
            return false;
        }
        win.setFlags(0x4000000, 0x4000000);
        if (Build.VERSION.SDK_INT >= 21) {
            win.clearFlags(Integer.MIN_VALUE);
        }
        return true;
    }

    public static String getSystemProperty(String key, String defValue) {
        if (key == null) {
            return defValue;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
            return properties.getProperty(key, defValue);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static int getStatusBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return UIUtil.dip2px(context, 25.0f);
    }

    public static int getMIUIVersionCode() {
        if (gMiuiVersionCode == -2) {
            String sMiuiVersionCode = UIUtil.getSystemProperty("ro.miui.ui.version.code", "-1");
            gMiuiVersionCode = -1;
            try {
                gMiuiVersionCode = Integer.parseInt(sMiuiVersionCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return gMiuiVersionCode;
    }

    public static boolean isFlymeOS() {
        String fingerprint = Build.FINGERPRINT;
        if (fingerprint == null) {
            return false;
        }
        return fingerprint.contains("Meizu");
    }

    public static boolean isEMUI() {
        String emuiVersion = UIUtil.getSystemProperty("ro.build.version.emui", null);
        return !StringUtil.isEmptyOrNull(emuiVersion);
    }

    public static boolean isImmersedModeSupported() {
        if (UIUtil.getMIUIVersionCode() >= 4) {
            return true;
        }
        if (UIUtil.isFlymeOS() && Build.VERSION.SDK_INT >= 19) {
            return true;
        }
        return UIUtil.isEMUI() && Build.VERSION.SDK_INT >= 19;
    }

    public static boolean setStatusBarDarkMode(Activity activity, boolean darkMode) {
        if (activity == null) {
            return false;
        }
        if (UIUtil.getMIUIVersionCode() >= 4) {
            return UIUtil.setStatusBarDarkMode_MIUI(activity, darkMode);
        }
        if (UIUtil.isFlymeOS() && Build.VERSION.SDK_INT >= 19) {
            return UIUtil.setStatusBarDarkMode_FlymeOS(activity, darkMode);
        }
        return false;
    }

    private static boolean setStatusBarDarkMode_MIUI(Activity activity, boolean darkMode) {
        Class<?> clazz = activity.getWindow().getClass();
        try {
            int darkModeFlag = 0;
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            if (layoutParams == null) {
                return false;
            }
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            if (field == null) {
                return false;
            }
            darkModeFlag = field.getInt(null);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            if (extraFlagField == null) {
                return false;
            }
            extraFlagField.invoke((Object)activity.getWindow(), darkMode ? darkModeFlag : 0, darkModeFlag);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean setStatusBarDarkMode_FlymeOS(Activity activity, boolean darkMode) {
        Window window = activity.getWindow();
        boolean result = false;
        if (window != null) {
            try {
                WindowManager.LayoutParams lp = window.getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = darkMode ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                window.setAttributes(lp);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean setNotificationMessageCount(Notification notification, int count) {
        try {
            Class<?> miuiNotificationClass = Class.forName("android.app.MiuiNotification");
            if (miuiNotificationClass != null) {
                Object miuiNotification = miuiNotificationClass.newInstance();
                Field field = miuiNotification.getClass().getDeclaredField("messageCount");
                field.setAccessible(true);
                field.set(miuiNotification, count);
                field = notification.getClass().getField("extraNotification");
                field.set(notification, miuiNotification);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void showWaitingDialog(FragmentManager fm, int messageId, String tag) {
        if (fm == null || StringUtil.isEmptyOrNull(tag) || messageId == 0) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(messageId);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, tag);
    }

    public static void showWaitingDialog(FragmentManager fm, String message, String tag) {
        if (fm == null || StringUtil.isEmptyOrNull(tag)) {
            return;
        }
        WaitingDialog waitingDialog = new WaitingDialog(message);
        waitingDialog.setCancelable(true);
        waitingDialog.show(fm, tag);
    }

    public static void dismissWaitingDialog(FragmentManager fm, String tag) {
        if (fm == null || StringUtil.isEmptyOrNull(tag)) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag(tag);
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        }
    }
}

