/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.content.Context;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import us.zoom.androidlib.util.StringUtil;

public class TimeUtil {
    public static final String DATE_FORMAT_YYYY_MM_DD_T_HH_MM_SS_Z = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final long ONE_DAY_IN_MILLISECONDS = 86400000L;
    public static final long ONE_DAY_IN_SECONDS = 86400L;
    public static final long ONE_HOUR_IN_SECONDS = 3600L;
    public static final long ONE_MINUTE_IN_SECONDS = 60L;

    public static String formatTime(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)2561);
    }

    public static String formatTimeCap(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)2817);
    }

    public static String formatDateTime(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)2577);
    }

    public static String formatDateTimeCap(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)2833);
    }

    public static String formatDate(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)32794);
    }

    public static String formatDateWithYear(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)32790);
    }

    public static String formatFullDate(Context context, long time) {
        return DateUtils.formatDateTime((Context)context, (long)time, (int)32791);
    }

    public static boolean isSameDate(long time1, long time2) {
        Date date1 = new Date(time1);
        Date date2 = new Date(time2);
        return date1.getYear() == date2.getYear() && date1.getMonth() == date2.getMonth() && date1.getDate() == date2.getDate();
    }

    public static int dateDiff(long time1, long time2) {
        long zeroTime1 = TimeUtil.getDayZeroTime(time1);
        long zeroTime2 = TimeUtil.getDayZeroTime(time2);
        return (int)((zeroTime1 - zeroTime2) / 86400000L);
    }

    public static int monthsDiff(long start, long end) {
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTimeInMillis(start);
        endCalendar.setTimeInMillis(end);
        return TimeUtil.yearsDiff(start, end) * 12 + (endCalendar.get(2) - startCalendar.get(2));
    }

    public static int yearsDiff(long start, long end) {
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTimeInMillis(start);
        endCalendar.setTimeInMillis(end);
        return endCalendar.get(1) - startCalendar.get(1);
    }

    public static long getDayZeroTime(long time) {
        long offset = TimeZone.getDefault().getRawOffset();
        return (time + offset) / 86400000L * 86400000L - offset;
    }

    public static long stringToMilliseconds(String time, String dateformat) {
        if (StringUtil.isEmptyOrNull(time)) {
            return -1L;
        }
        SimpleDateFormat format = new SimpleDateFormat(dateformat);
        Date date = null;
        try {
            date = format.parse(time);
        }
        catch (ParseException e) {
            return -1L;
        }
        if (date == null) {
            return -1L;
        }
        return date.getTime();
    }

    private static String format(java.text.DateFormat formatter, Calendar calendar) {
        if (formatter == null || calendar == null) {
            return null;
        }
        formatter.setCalendar(calendar);
        return formatter.format(calendar.getTime());
    }

    public static String formatDate(Context context, Calendar calendar) {
        java.text.DateFormat formatter = context == null ? java.text.DateFormat.getDateInstance() : DateFormat.getDateFormat((Context)context);
        return TimeUtil.format(formatter, calendar);
    }

    public static String formatDateTime(Context context, Calendar calendar) {
        return TimeUtil.format(java.text.DateFormat.getDateTimeInstance(), calendar);
    }

    public static String formatTime(Context context, Calendar calendar) {
        java.text.DateFormat formatter = context == null ? java.text.DateFormat.getTimeInstance() : DateFormat.getTimeFormat((Context)context);
        return TimeUtil.format(formatter, calendar);
    }

    private static String format(java.text.DateFormat formatter, Date date, TimeZone timeZone) {
        if (formatter == null || date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (timeZone != null) {
            cal.setTimeZone(timeZone);
        }
        return TimeUtil.format(formatter, cal);
    }

    public static String formatDate(Context context, Date date, TimeZone timezone) {
        java.text.DateFormat formatter = context == null ? java.text.DateFormat.getDateInstance() : DateFormat.getDateFormat((Context)context);
        return TimeUtil.format(formatter, date, timezone);
    }

    public static String formatDateTime(Context context, Date date, TimeZone timezone) {
        return TimeUtil.format(java.text.DateFormat.getDateTimeInstance(), date, timezone);
    }

    public static String formatTime(Context context, Date date, TimeZone timezone) {
        java.text.DateFormat formatter = context == null ? java.text.DateFormat.getTimeInstance() : DateFormat.getTimeFormat((Context)context);
        return TimeUtil.format(formatter, date, timezone);
    }

    public static boolean isInSameMonth(long timeA, long timeB) {
        Calendar calDateA = Calendar.getInstance();
        calDateA.setTimeInMillis(timeA);
        Calendar calDateB = Calendar.getInstance();
        calDateB.setTimeInMillis(timeB);
        return calDateA.get(1) == calDateB.get(1) && calDateA.get(2) == calDateB.get(2);
    }

    public static String formateDuration(long seconds) {
        StringBuilder stringBuilder = new StringBuilder();
        if (seconds >= 86400L) {
            stringBuilder.append(String.valueOf(seconds / 86400L)).append(":");
            seconds %= 86400L;
        }
        if (seconds >= 3600L) {
            stringBuilder.append(String.format("%02d", seconds / 3600L)).append(":");
            seconds %= 3600L;
        }
        if (seconds >= 60L) {
            stringBuilder.append(String.format("%02d", seconds / 60L)).append(":");
            seconds %= 60L;
        } else {
            stringBuilder.append("00:");
        }
        stringBuilder.append(String.format("%02d", (int)seconds));
        return stringBuilder.toString();
    }
}

