/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import java.text.Collator;
import java.util.Locale;
import us.zoom.androidlib.util.PinyinUtil;

public class SortUtil {
    private SortUtil() {
    }

    public static String getSortKey(String str, Locale locale) {
        if (str == null || str.length() == 0) {
            return "!";
        }
        String sortKey = str;
        if (locale == null) {
            return sortKey;
        }
        sortKey = PinyinUtil.getSortKey(str);
        if (sortKey.length() == 0) {
            return sortKey;
        }
        Collator collator = Collator.getInstance(locale);
        collator.setStrength(0);
        String groupChar = SortUtil.getGroupChar(sortKey, collator);
        if ("#".equals(groupChar)) {
            sortKey = "#" + sortKey;
        }
        return sortKey;
    }

    private static String getGroupChar(String str, Collator collator) {
        if (str.length() == 0) {
            return "#";
        }
        String key = str.substring(0, 1);
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            int res = collator.compare(String.valueOf(c), key);
            if (res != 0) continue;
            return String.valueOf(c);
        }
        return "#";
    }
}

