/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ParamsList {
    private static final String TAG = ParamsList.class.getSimpleName();
    public static final String DEFAULT_SPLITER = ";";
    private HashMap<String, String> mMap = new HashMap();

    public static ParamsList parseFromString(String params) {
        return ParamsList.parseFromString(params, DEFAULT_SPLITER);
    }

    public static ParamsList parseFromString(String params, String spliter) {
        String[] strs;
        ParamsList paramsList = new ParamsList();
        if (params == null || params.length() == 0) {
            return paramsList;
        }
        for (String str : strs = params.split(spliter)) {
            String[] keyVal;
            if ((str = str.trim()).length() == 0 || (keyVal = str.split("=")).length != 2) continue;
            String key = keyVal[0].trim();
            String value = null;
            try {
                value = URLDecoder.decode(keyVal[1].trim(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (value == null) continue;
            paramsList.mMap.put(key, value);
        }
        return paramsList;
    }

    public String toString() {
        return this.serializeToString();
    }

    public String serializeToString() {
        return this.serializeToString(DEFAULT_SPLITER);
    }

    public String serializeToString(String spliter) {
        if (spliter == null || spliter.length() == 0) {
            throw new IllegalArgumentException("param spliter cannot be null or empty");
        }
        StringBuilder builder = new StringBuilder();
        Set<Map.Entry<String, String>> entrySet = this.mMap.entrySet();
        boolean bFirst = true;
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            String value = entry.getValue();
            String encValue = "";
            try {
                encValue = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (!bFirst) {
                builder.append(spliter);
            }
            builder.append(key).append('=').append(encValue);
            bFirst = false;
        }
        return builder.toString();
    }

    public void remove(String key) {
        if (key != null) {
            this.mMap.remove(key);
        }
    }

    public void putString(String key, String value) {
        if (value == null) {
            this.mMap.remove(key);
        } else {
            this.mMap.put(key, value);
        }
    }

    public void putInt(String key, int value) {
        if (key == null) {
            return;
        }
        this.mMap.put(key, String.valueOf(value));
    }

    public void putLong(String key, long value) {
        if (key == null) {
            return;
        }
        this.mMap.put(key, String.valueOf(value));
    }

    public void putBoolean(String key, boolean value) {
        if (key == null) {
            return;
        }
        this.mMap.put(key, String.valueOf(value));
    }

    public String getString(String key, String defValue) {
        if (key == null) {
            return null;
        }
        String value = this.mMap.get(key);
        if (value == null) {
            return defValue;
        }
        return value;
    }

    public int getInt(String key, int defValue) {
        if (key == null) {
            return defValue;
        }
        String value = this.mMap.get(key);
        if (value == null) {
            return defValue;
        }
        int iValue = defValue;
        try {
            iValue = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iValue;
    }

    public long getLong(String key, long defValue) {
        if (key == null) {
            return defValue;
        }
        String value = this.mMap.get(key);
        if (value == null) {
            return defValue;
        }
        long lValue = defValue;
        try {
            lValue = Long.parseLong(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lValue;
    }

    public boolean getBoolean(String key, boolean defValue) {
        if (key == null) {
            return defValue;
        }
        String value = this.mMap.get(key);
        if (value == null) {
            return defValue;
        }
        boolean bValue = defValue;
        try {
            bValue = Boolean.parseBoolean(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bValue;
    }
}

