/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class NetworkUtil {
    private static final String TAG = NetworkUtil.class.getSimpleName();
    public static final int NETWORK_TYPE_NONE = 0;
    public static final int NETWORK_TYPE_WIFI = 1;
    public static final int NETWORK_TYPE_MOBILE = 2;
    public static final int NETWORK_TYPE_WiMAX = 3;
    public static final int NETWORK_TYPE_ETHERNET = 4;
    public static final int NETWORK_TYPE_UNKNOWN = 5;
    public static final String IP_NULL = "0.0.0.0";

    public static boolean hasDataNetwork(Context context) {
        if (context == null) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo ni = null;
        try {
            ni = cm.getActiveNetworkInfo();
        }
        catch (Exception e) {
            return false;
        }
        if (ni == null) {
            return false;
        }
        boolean connected = ni.isConnected();
        if (connected && ni.getType() == 0) {
            TelephonyManager telMgr = (TelephonyManager)context.getSystemService("phone");
            if (telMgr == null) {
                return false;
            }
            connected = telMgr.getDataState() == 2;
        }
        return connected;
    }

    public static int getDataNetworkType(Context context) {
        if (context == null) {
            return 5;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return 5;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni == null) {
            return 0;
        }
        if (!ni.isConnected()) {
            return 0;
        }
        switch (ni.getType()) {
            case 1: {
                return 1;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                TelephonyManager telMgr = (TelephonyManager)context.getSystemService("phone");
                if (telMgr.getDataState() != 2) {
                    return 0;
                }
                return 2;
            }
            case 6: {
                return 3;
            }
            case 9: {
                return 4;
            }
        }
        return 5;
    }

    public static String getNetworkIP(Context context) {
        if (context == null) {
            return IP_NULL;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return IP_NULL;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni == null || !ni.isConnected()) {
            return IP_NULL;
        }
        String ip = IP_NULL;
        switch (ni.getType()) {
            case 1: {
                ip = NetworkUtil.getWifiIpAddress(context);
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                TelephonyManager telMgr = (TelephonyManager)context.getSystemService("phone");
                if (telMgr.getDataState() != 2) break;
                ip = NetworkUtil.getLocalIpAddress();
                break;
            }
            case 9: {
                ip = NetworkUtil.getEtherNetIP();
                break;
            }
        }
        return ip;
    }

    private static String intToIp(int ipInt) {
        StringBuilder sb = new StringBuilder();
        sb.append(ipInt & 0xFF).append(".");
        sb.append(ipInt >> 8 & 0xFF).append(".");
        sb.append(ipInt >> 16 & 0xFF).append(".");
        sb.append(ipInt >> 24 & 0xFF);
        return sb.toString();
    }

    private static String getWifiIpAddress(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager == null) {
            return IP_NULL;
        }
        try {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            int ipAddress = wifiInfo.getIpAddress();
            return NetworkUtil.intToIp(ipAddress);
        }
        catch (Exception exception) {
            return IP_NULL;
        }
    }

    private static String getLocalIpAddress() {
        try {
            ArrayList<NetworkInterface> nilist = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface ni : nilist) {
                ArrayList<InetAddress> ialist = Collections.list(ni.getInetAddresses());
                for (InetAddress address : ialist) {
                    if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return IP_NULL;
    }

    private static String getEtherNetIP() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return IP_NULL;
    }
}

