/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;

public class NetworkStatusReceiver
extends BroadcastReceiver {
    private ListenerList mListener = new ListenerList();
    private int mLastType = 0;
    private boolean mLastConnection = false;
    private String mLastIpAddress;

    public NetworkStatusReceiver(Context context) {
        this.mLastType = NetworkUtil.getDataNetworkType(context);
        this.mLastConnection = NetworkUtil.hasDataNetwork(context);
        this.mLastIpAddress = NetworkUtil.getNetworkIP(context);
    }

    public void addListener(NetworkStatusListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListener.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            this.removeListener((NetworkStatusListener)listeners[i]);
        }
        this.mListener.add(l);
    }

    public void removeListener(NetworkStatusListener l) {
        this.mListener.remove(l);
    }

    public boolean isListenerEmpty() {
        return this.mListener.size() == 0;
    }

    public void registerReceiver(Context context) {
        if (context == null) {
            return;
        }
        context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public void unregisterReceiver(Context context) {
        if (context == null) {
            return;
        }
        context.unregisterReceiver((BroadcastReceiver)this);
    }

    public void onReceive(Context context, Intent intent) {
        if (context == null || intent == null) {
            return;
        }
        String action = intent.getAction();
        if (StringUtil.isEmptyOrNull(action)) {
            return;
        }
        if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
            return;
        }
        this.notifyStatusChanged(context);
    }

    private void notifyStatusChanged(Context context) {
        IListener[] listeners = this.mListener.getAll();
        boolean curConnection = NetworkUtil.hasDataNetwork(context);
        int type = NetworkUtil.getDataNetworkType(context);
        String ip = NetworkUtil.getNetworkIP(context);
        for (IListener lTmp : listeners) {
            NetworkStatusListener l = (NetworkStatusListener)lTmp;
            l.networkStatusChanged(curConnection, this.mLastConnection, this.mLastType, this.mLastIpAddress);
        }
        this.mLastConnection = curConnection;
        this.mLastType = type;
        this.mLastIpAddress = ip;
    }

    public static class SimpleNetworkStatusListener
    implements NetworkStatusListener {
        @Override
        public void networkStatusChanged(boolean curConnection, boolean lastConnection, int lastType, String lastIp) {
        }
    }

    public static interface NetworkStatusListener
    extends IListener {
        public void networkStatusChanged(boolean var1, boolean var2, int var3, String var4);
    }
}

