/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import java.util.Locale;
import us.zoom.androidlib.util.StringUtil;

public class LanguageUtil {
    public static final String LOCALE_PREFERENCE_NAME = "app_locale_config";
    public static final String KEY_APP_LOCALE_ID = "app_locale_id";

    public static void setAppLocale(Context context, Locale locale) {
        if (context == null || locale == null) {
            return;
        }
        SharedPreferences store = context.getSharedPreferences(LOCALE_PREFERENCE_NAME, 0);
        SharedPreferences.Editor editor = store.edit();
        String countryCode = locale.getCountry();
        String languageCode = locale.getLanguage();
        String localeString = "";
        if (languageCode.length() != 0) {
            localeString = countryCode.length() == 0 ? languageCode : languageCode + "_" + countryCode;
        }
        editor.putString(KEY_APP_LOCALE_ID, localeString);
        editor.commit();
    }

    public static Locale getAppLocale(Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences store = context.getSharedPreferences(LOCALE_PREFERENCE_NAME, 0);
        Locale locale = null;
        String localeStr = store.getString(KEY_APP_LOCALE_ID, null);
        if (!StringUtil.isEmptyOrNull(localeStr)) {
            if (localeStr.contains("_")) {
                String[] strArray = localeStr.split("_", 2);
                locale = new Locale(strArray[0], strArray[1]);
            } else {
                locale = new Locale(localeStr);
            }
        }
        return locale;
    }

    public static void updateLocaleForContextWrapper(ContextWrapper context) {
        Locale locale = LanguageUtil.getAppLocale((Context)context);
        if (locale != null && !StringUtil.isEmptyOrNull(locale.getLanguage())) {
            Resources resources = context.getBaseContext().getResources();
            DisplayMetrics dm = resources.getDisplayMetrics();
            Configuration config = resources.getConfiguration();
            config.locale = locale;
            resources.updateConfiguration(config, dm);
        }
    }

    public static Resources getUpdateLocaleResources(ContextWrapper context) {
        Locale locale = LanguageUtil.getAppLocale((Context)context);
        if (locale != null && !StringUtil.isEmptyOrNull(locale.getLanguage())) {
            Configuration config = context.getResources().getConfiguration();
            config.locale = locale;
            DisplayMetrics metrics = context.getResources().getDisplayMetrics();
            return new Resources(context.getAssets(), metrics, config);
        }
        return context.getResources();
    }

    public static Context getUpdateLocaleForContext(Context context) {
        Locale locale = LanguageUtil.getAppLocale(context);
        if (locale != null && !StringUtil.isEmptyOrNull(locale.getLanguage())) {
            Resources resources = context.getResources();
            Configuration config = resources.getConfiguration();
            config.locale = locale;
            DisplayMetrics metrics = resources.getDisplayMetrics();
            if (Build.VERSION.SDK_INT < 17) {
                resources.updateConfiguration(config, metrics);
                return context;
            }
            return context.createConfigurationContext(config);
        }
        return context;
    }
}

