/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HardwareUtil {
    public static final int FLAG_CUR_FREQUENCY = 0;
    public static final int FLAG_MIN_FREQUENCY = 1;
    public static final int FLAG_MAX_FREQUENCY = 2;

    public static int getCPUKernalNumbers() {
        File dir = new File("/sys/devices/system/cpu");
        try {
            if (!dir.isDirectory()) {
                return 1;
            }
            String[] files = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    Pattern pattern = Pattern.compile("cpu(\\d+)");
                    Matcher matcher = pattern.matcher(filename);
                    return matcher.matches();
                }
            });
            if (files == null) {
                return 1;
            }
            return files.length;
        }
        catch (Exception e) {
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCPUKernelFrequency(int kernelIndex, int flag) {
        String fileName = "/sys/devices/system/cpu/cpu" + kernelIndex;
        if (flag == 0) {
            fileName = fileName + "/cpufreq/scaling_cur_freq";
        } else if (flag == 1) {
            fileName = fileName + "/cpufreq/cpuinfo_min_freq";
        } else if (flag == 2) {
            fileName = fileName + "/cpufreq/cpuinfo_max_freq";
        } else {
            return 0;
        }
        File f = new File(fileName);
        FileReader fReader = null;
        BufferedReader reader = null;
        int freq = 0;
        try {
            fReader = new FileReader(f);
            reader = new BufferedReader(fReader);
            String line = reader.readLine();
            if (line != null) {
                freq = Integer.parseInt(line);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                reader.close();
                fReader.close();
            }
            catch (Exception exception) {}
        }
        return freq;
    }

    public static boolean isBluetoothLESupported(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return false;
        }
        return Build.VERSION.SDK_INT >= 18 && pm.hasSystemFeature("android.hardware.bluetooth_le");
    }

    @SuppressLint(value={"NewApi"})
    public static String getPreferredCpuABI() {
        if (Build.VERSION.SDK_INT >= 21 && Build.SUPPORTED_ABIS != null && Build.SUPPORTED_ABIS.length > 0) {
            return Build.SUPPORTED_ABIS[0];
        }
        return Build.CPU_ABI;
    }
}

