/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;

public class FileUtils {
    private static final String TAG = FileUtils.class.getSimpleName();
    private static final String SAMSUNG_CLOUD_AGENT_PREFIX = "/storage/emulated/0/.cloudagent";
    private static final int KELO_BYTE = 1024;
    private static final int MEGA_BYTE = 0x100000;
    private static final int GIGA_BYTE = 0x40000000;

    @SuppressLint(value={"NewApi"})
    public static String getPathFromUri(Context context, Uri uri) {
        boolean isKitKat;
        if (context == null || uri == null) {
            return null;
        }
        String path = null;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        path = isKitKat ? (DocumentsContract.isDocumentUri((Context)context, (Uri)uri) ? FileUtils.getPathFromUri_KitKat(context, uri) : FileUtils.getPathFromUri_Normal(context, uri)) : FileUtils.getPathFromUri_Normal(context, uri);
        return path;
    }

    public static File createUnDuplicateNameFile(String fileName, String dirPath) {
        if (StringUtil.isEmptyOrNull(fileName) || StringUtil.isEmptyOrNull(dirPath)) {
            return null;
        }
        File parent = new File(dirPath);
        if (!parent.exists() && !parent.mkdirs()) {
            return null;
        }
        File newPath = new File(parent, fileName);
        if (!newPath.exists()) {
            return newPath;
        }
        int index = fileName.lastIndexOf(".");
        String name = null;
        String ext = null;
        if (index >= 0) {
            name = fileName.substring(0, index);
            ext = fileName.substring(index);
        } else {
            name = fileName;
            ext = "";
        }
        int i = 2;
        while ((newPath = new File(parent, String.format("%s(%d)%s", name, i, ext))).exists()) {
            ++i;
        }
        return newPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String srcFile, String destFile) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        FileChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(srcFile).getChannel();
            outputChannel = new FileOutputStream(destFile).getChannel();
            long srcSize = inputChannel.size();
            long size = ((FileChannel)outputChannel).transferFrom(inputChannel, 0L, srcSize);
            if (size == srcSize) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputChannel != null) {
                    inputChannel.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputChannel != null) {
                    outputChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        String column = "_data";
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(uri, null, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_thumb_index;
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String data = cursor.getString(column_index);
                if (data != null && data.startsWith(SAMSUNG_CLOUD_AGENT_PREFIX) && !new File(data).exists() && (column_thumb_index = cursor.getColumnIndex("thumb_data_path")) != -1 && !StringUtil.isEmptyOrNull(data = cursor.getString(column_thumb_index))) {
                    String string2 = data;
                    return string2;
                }
                String string3 = cursor.getString(column_index);
                return string3;
            }
        }
        return null;
    }

    @TargetApi(value=19)
    private static String getPathFromUri_KitKat(Context context, Uri uri) {
        if (FileUtils.isExternalStorageDocument(uri)) {
            String docId = DocumentsContract.getDocumentId((Uri)uri);
            String[] split = docId.split(":");
            String type = split[0];
            if ("primary".equalsIgnoreCase(type)) {
                return Environment.getExternalStorageDirectory() + "/" + split[1];
            }
            return null;
        }
        if (FileUtils.isDownloadsDocument(uri)) {
            String id2 = DocumentsContract.getDocumentId((Uri)uri);
            Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
            return FileUtils.getDataColumn(context, contentUri, null, null);
        }
        if (FileUtils.isMediaDocument(uri)) {
            String docId = DocumentsContract.getDocumentId((Uri)uri);
            String[] split = docId.split(":");
            String type = split[0];
            Uri contentUri = null;
            if ("image".equals(type)) {
                contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            } else if ("video".equals(type)) {
                contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            } else if ("audio".equals(type)) {
                contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
            }
            String selection = "_id=?";
            String[] selectionArgs = new String[]{split[1]};
            return FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPathFromUri_Normal(Context context, Uri uri) {
        String path = null;
        if ("content".equalsIgnoreCase(uri.getScheme())) {
            path = FileUtils.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : FileUtils.getDataColumn(context, uri, null, null);
            if (path == null) {
                InputStream is = null;
                OutputStream os = null;
                try {
                    byte[] buff;
                    int size;
                    String type = context.getContentResolver().getType(uri);
                    String ext = AndroidAppUtil.getFileExtendNameFromMimType(type);
                    String tmpFilePath = FileUtils.createTempFile(context, "tmp", null, ext);
                    is = context.getContentResolver().openInputStream(uri);
                    os = new FileOutputStream(tmpFilePath);
                    while ((size = is.read(buff = new byte[102400])) > 0) {
                        os.write(buff, 0, size);
                    }
                    path = tmpFilePath;
                }
                catch (Exception exception) {
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            path = "file".equalsIgnoreCase(uri.getScheme()) ? uri.getPath() : uri.toString();
        }
        return path;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static String getFileName(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        if (!file.exists()) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        InputStream is = null;
        try {
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            int readLen = 0;
            byte[] buff = new byte[10240];
            is = new FileInputStream(file);
            do {
                if ((readLen = is.read(buff)) <= 0) continue;
                mdInst.update(buff, 0, readLen);
            } while (readLen > 0);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            String string2 = new String(str);
            return string2;
        }
        catch (Exception e) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isSameFile(File file1, File file2) {
        String md51 = FileUtils.getMD5(file1);
        String md52 = FileUtils.getMD5(file2);
        return StringUtil.isSameString(md51, md52);
    }

    public static String toFileSizeString(Context context, long size) {
        if (size < 0L || context == null) {
            return "";
        }
        String sizeStr = size >= 0x40000000L ? context.getString(R.string.zm_file_size_gb, new Object[]{FileUtils.getFileSizeString((double)size / 1.073741824E9)}) : (size >= 0x100000L ? context.getString(R.string.zm_file_size_mb, new Object[]{FileUtils.getFileSizeString((double)size / 1048576.0)}) : (size >= 1024L ? context.getString(R.string.zm_file_size_kb, new Object[]{FileUtils.getFileSizeString((double)size / 1024.0)}) : context.getString(R.string.zm_file_size_bytes, new Object[]{FileUtils.getFileSizeString(size)})));
        return sizeStr;
    }

    private static String getFileSizeString(double totalSize) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        return format.format(totalSize);
    }

    public static String shrinkFileName(String fileName, int maxLength) {
        if (fileName == null || fileName.length() <= maxLength || maxLength <= 0) {
            return fileName;
        }
        String end = "";
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex >= 0) {
            int trimIdx = dotIndex - 1;
            if (trimIdx < 0) {
                trimIdx = 0;
            }
            end = fileName.substring(trimIdx);
        }
        int lenEnd = end.length();
        int lenRemain = maxLength - lenEnd;
        if ((lenRemain -= 3) <= 0) {
            return fileName.substring(0, maxLength);
        }
        String start = fileName.substring(0, lenRemain) + "...";
        return start + end;
    }

    public static String getDataPath(Context context, boolean isPrivate, boolean createIfNotExist) {
        File filesDir;
        if (context == null) {
            return null;
        }
        StringBuffer fn = new StringBuffer();
        String state = Environment.getExternalStorageState();
        boolean success = false;
        if (!isPrivate && state != null && state.equals("mounted")) {
            filesDir = context.getExternalFilesDir(null);
            if (filesDir != null) {
                fn.append(filesDir.getParent());
                fn.append("/data");
                success = true;
            } else {
                File tmpDir = new File((fn = fn.append("/sdcard/Android/data/").append(context.getPackageName()).append("/data")).toString());
                if (tmpDir.exists() && tmpDir.isDirectory() || tmpDir.mkdirs()) {
                    success = true;
                } else {
                    fn.delete(0, fn.length());
                }
            }
        }
        if (!success) {
            filesDir = context.getFilesDir();
            if (filesDir != null) {
                fn.append(filesDir.getParent());
            } else {
                fn.append("/data/data/" + context.getPackageName());
            }
            fn.append("/data");
        }
        String path = fn.toString();
        File dir = new File(path);
        if (createIfNotExist && !dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }

    public static String getTempPath(Context context) {
        return FileUtils.getDataPath(context, false, true);
    }

    public static String createTempFile(Context context, String prefix, String dir, String ext) {
        if (dir == null || dir.length() == 0) {
            dir = FileUtils.getDataPath(context, false, true);
        } else {
            File fDir = new File(dir);
            if (!fDir.exists()) {
                fDir.mkdirs();
            }
        }
        if (StringUtil.isEmptyOrNull(ext)) {
            ext = "tmp";
        }
        StringBuilder file = new StringBuilder().append(dir).append("/").append(prefix).append("-").append(UUID.randomUUID().toString());
        if (!ext.startsWith(".")) {
            file.append(".");
        }
        file.append(ext);
        return file.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadFile(Context context, URL url) {
        InputStream is = null;
        OutputStream os = null;
        try {
            byte[] buff;
            int size;
            is = url.openStream();
            String tmpFilePath = FileUtils.createTempFile(context, "tmp", null, null);
            os = new FileOutputStream(tmpFilePath);
            while ((size = is.read(buff = new byte[102400])) > 0) {
                os.write(buff, 0, size);
            }
            String string2 = tmpFilePath;
            return string2;
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String makeNewFilePathWithName(String dir, String fileName) {
        int idxSlash;
        if (dir == null) {
            return null;
        }
        File fDir = new File(dir);
        if (!fDir.exists() || !fDir.canWrite()) {
            return null;
        }
        if (StringUtil.isEmptyOrNull(fileName)) {
            fileName = "unnamed";
        }
        if ((idxSlash = fileName.lastIndexOf(47)) > 0) {
            fileName = fileName.substring(idxSlash + 1);
        }
        String extName = "";
        int idxDot = fileName.lastIndexOf(46);
        if (idxDot >= 0) {
            extName = fileName.substring(idxDot);
        }
        String mainName = fileName.substring(0, fileName.length() - extName.length());
        int num = 0;
        File file = null;
        File fileTmp = null;
        do {
            StringBuilder sPath = new StringBuilder(dir);
            if (!dir.endsWith("/")) {
                sPath.append('/');
            }
            sPath.append(mainName);
            if (num > 0) {
                sPath.append('(').append(num).append(')');
            }
            ++num;
            sPath.append(extName);
            file = new File(sPath.toString());
            fileTmp = new File(sPath.append(".zmdownload").toString());
        } while (file.exists() || fileTmp.exists());
        return file.getAbsolutePath();
    }

    private static String validateFilename(String filename, String intendedDir) throws IOException {
        File iD;
        String canonicalID;
        File f = new File(filename);
        String canonicalPath = f.getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return canonicalPath;
        }
        throw new IllegalStateException("File is outside extraction target directory.");
    }

    public static String readZipFile(String file, String fileName) {
        return FileUtils.readZipFile(file, fileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readZipFile(String file, String fileName, boolean appendEnter) {
        if (TextUtils.isEmpty((CharSequence)file) || TextUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        ZipInputStream zin = null;
        try {
            ZipFile zf = new ZipFile(file);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            zin = new ZipInputStream(in);
            StringBuffer result = new StringBuffer();
            while (true) {
                ZipEntry ze;
                if ((ze = zin.getNextEntry()) != null) {
                    String line;
                    String entryName = FileUtils.validateFilename(ze.getName(), ".");
                    if (ze.isDirectory() || TextUtils.isEmpty((CharSequence)entryName) || !entryName.endsWith(fileName)) continue;
                    BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                    while ((line = br.readLine()) != null) {
                        result.append(line);
                        if (!appendEnter) continue;
                        result.append("\n");
                    }
                    br.close();
                    String string2 = result.toString();
                    return string2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (zin != null) {
                try {
                    zin.closeEntry();
                    zin.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipFile(String zipFileName, String locationDir) {
        if (StringUtil.isEmptyOrNull(zipFileName) || StringUtil.isEmptyOrNull(locationDir)) {
            return false;
        }
        if (!new File(zipFileName).exists() || !new File(locationDir).exists()) {
            return false;
        }
        File dir = new File(locationDir);
        if (!dir.isDirectory()) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    int size;
                    ZipEntry entry = enumeration.nextElement();
                    File entryDestination = new File(locationDir, entry.getName());
                    entryDestination.delete();
                    if (entry.isDirectory()) {
                        entryDestination.mkdirs();
                        continue;
                    }
                    entryDestination.getParentFile().mkdirs();
                    InputStream in = zipFile.getInputStream(entry);
                    FileOutputStream out = new FileOutputStream(entryDestination);
                    byte[] buff = new byte[8192];
                    while ((size = in.read(buff)) > 0) {
                        ((OutputStream)out).write(buff, 0, size);
                    }
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ((OutputStream)out).close();
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] files;
            for (String subFile : files = file.list()) {
                FileUtils.deleteFile(subFile);
            }
        }
        file.delete();
    }

    public static boolean fileIsExists(String path) {
        if (path == null || path.trim().length() <= 0) {
            return false;
        }
        try {
            File f = new File(path);
            if (!f.exists()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean createFile(String filePath, boolean deleteIfExist) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        File parent = file.getParentFile();
        boolean result = true;
        if (!parent.exists()) {
            result = parent.mkdirs();
        }
        if (result) {
            if (deleteIfExist) {
                file.deleteOnExit();
            }
            if (!file.exists()) {
                try {
                    result = file.createNewFile();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }
}

