/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.CalendarContract;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

@TargetApi(value=14)
public class Event
implements Cloneable {
    private static final String TAG = "CalEvent";
    private static final boolean PROFILE = false;
    private static final String SORT_EVENTS_BY = "begin ASC, end DESC, title ASC";
    private static final String SORT_ALLDAY_BY = "startDay ASC, endDay DESC, title ASC";
    private static final String DISPLAY_AS_ALLDAY = "dispAllday";
    private static final String EVENTS_WHERE = "dispAllday=0";
    private static final String ALLDAY_WHERE = "dispAllday=1";
    public static final String[] EVENT_PROJECTION = new String[]{"title", "eventLocation", "allDay", "displayColor", "eventTimezone", "event_id", "begin", "end", "_id", "startDay", "endDay", "startMinute", "endMinute", "hasAlarm", "rrule", "rdate", "selfAttendeeStatus", "organizer", "guestsCanModify", "allDay=1 OR (end-begin)>=86400000 AS dispAllday", "description"};
    private static final int PROJECTION_TITLE_INDEX = 0;
    private static final int PROJECTION_LOCATION_INDEX = 1;
    private static final int PROJECTION_ALL_DAY_INDEX = 2;
    private static final int PROJECTION_COLOR_INDEX = 3;
    private static final int PROJECTION_TIMEZONE_INDEX = 4;
    private static final int PROJECTION_EVENT_ID_INDEX = 5;
    private static final int PROJECTION_BEGIN_INDEX = 6;
    private static final int PROJECTION_END_INDEX = 7;
    private static final int PROJECTION_START_DAY_INDEX = 9;
    private static final int PROJECTION_END_DAY_INDEX = 10;
    private static final int PROJECTION_START_MINUTE_INDEX = 11;
    private static final int PROJECTION_END_MINUTE_INDEX = 12;
    private static final int PROJECTION_HAS_ALARM_INDEX = 13;
    private static final int PROJECTION_RRULE_INDEX = 14;
    private static final int PROJECTION_RDATE_INDEX = 15;
    private static final int PROJECTION_SELF_ATTENDEE_STATUS_INDEX = 16;
    private static final int PROJECTION_ORGANIZER_INDEX = 17;
    private static final int PROJECTION_GUESTS_CAN_INVITE_OTHERS_INDEX = 18;
    private static final int PROJECTION_DISPLAY_AS_ALLDAY = 19;
    private static final int PROJECTION_DESCRIPTION = 20;
    private static String mNoTitleString;
    private static int mNoColorColor;
    public long id;
    public int color;
    public CharSequence title;
    public CharSequence location;
    public CharSequence description;
    public boolean allDay;
    public String organizer;
    public boolean guestsCanModify;
    public int startDay;
    public int endDay;
    public int startTime;
    public int endTime;
    public long startMillis;
    public long endMillis;
    private int mColumn;
    private int mMaxColumns;
    public boolean hasAlarm;
    public boolean isRepeating;
    public int selfAttendeeStatus;
    public String rrule;
    public float left;
    public float right;
    public float top;
    public float bottom;
    public Event nextRight;
    public Event nextLeft;
    public Event nextUp;
    public Event nextDown;

    private static boolean isJellybeanOrLater() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public final Object clone() throws CloneNotSupportedException {
        super.clone();
        Event e = new Event();
        e.title = this.title;
        e.color = this.color;
        e.location = this.location;
        e.allDay = this.allDay;
        e.startDay = this.startDay;
        e.endDay = this.endDay;
        e.startTime = this.startTime;
        e.endTime = this.endTime;
        e.startMillis = this.startMillis;
        e.endMillis = this.endMillis;
        e.hasAlarm = this.hasAlarm;
        e.isRepeating = this.isRepeating;
        e.selfAttendeeStatus = this.selfAttendeeStatus;
        e.organizer = this.organizer;
        e.guestsCanModify = this.guestsCanModify;
        e.rrule = this.rrule;
        e.description = this.description;
        return e;
    }

    public final void copyTo(Event dest) {
        dest.id = this.id;
        dest.title = this.title;
        dest.color = this.color;
        dest.location = this.location;
        dest.allDay = this.allDay;
        dest.startDay = this.startDay;
        dest.endDay = this.endDay;
        dest.startTime = this.startTime;
        dest.endTime = this.endTime;
        dest.startMillis = this.startMillis;
        dest.endMillis = this.endMillis;
        dest.hasAlarm = this.hasAlarm;
        dest.isRepeating = this.isRepeating;
        dest.selfAttendeeStatus = this.selfAttendeeStatus;
        dest.organizer = this.organizer;
        dest.guestsCanModify = this.guestsCanModify;
        dest.rrule = this.rrule;
        dest.description = this.description;
    }

    public static final Event newInstance() {
        Event e = new Event();
        e.id = 0L;
        e.title = null;
        e.color = 0;
        e.location = null;
        e.allDay = false;
        e.startDay = 0;
        e.endDay = 0;
        e.startTime = 0;
        e.endTime = 0;
        e.startMillis = 0L;
        e.endMillis = 0L;
        e.hasAlarm = false;
        e.isRepeating = false;
        e.selfAttendeeStatus = 0;
        e.rrule = null;
        e.description = null;
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadEvents(Context context, ArrayList<Event> events, int startDay, int days, int requestId, AtomicInteger sequenceNumber) {
        Cursor cEvents = null;
        Cursor cAllday = null;
        events.clear();
        try {
            int endDay = startDay + days - 1;
            boolean hideDeclined = false;
            String where = EVENTS_WHERE;
            String whereAllday = ALLDAY_WHERE;
            if (hideDeclined) {
                String hideString = " AND selfAttendeeStatus!=2";
                where = where + hideString;
                whereAllday = whereAllday + hideString;
            }
            cEvents = Event.instancesQuery(context.getContentResolver(), EVENT_PROJECTION, startDay, endDay, where, null, SORT_EVENTS_BY);
            cAllday = Event.instancesQuery(context.getContentResolver(), EVENT_PROJECTION, startDay, endDay, whereAllday, null, SORT_ALLDAY_BY);
            if (requestId != sequenceNumber.get()) {
                return;
            }
            Event.buildEventsFromCursor(events, cEvents, context, startDay, endDay);
            Event.buildEventsFromCursor(events, cAllday, context, startDay, endDay);
        }
        finally {
            if (cEvents != null) {
                cEvents.close();
            }
            if (cAllday != null) {
                cAllday.close();
            }
        }
    }

    private static final Cursor instancesQuery(ContentResolver cr, String[] projection, int startDay, int endDay, String selection, String[] selectionArgs, String orderBy) {
        String WHERE_CALENDARS_SELECTED = "visible=?";
        String[] WHERE_CALENDARS_ARGS = new String[]{"1"};
        String DEFAULT_SORT_ORDER = "begin ASC";
        Uri.Builder builder = CalendarContract.Instances.CONTENT_BY_DAY_URI.buildUpon();
        ContentUris.appendId((Uri.Builder)builder, (long)startDay);
        ContentUris.appendId((Uri.Builder)builder, (long)endDay);
        if (TextUtils.isEmpty((CharSequence)selection)) {
            selection = WHERE_CALENDARS_SELECTED;
            selectionArgs = WHERE_CALENDARS_ARGS;
        } else {
            selection = "(" + selection + ") AND " + WHERE_CALENDARS_SELECTED;
            if (selectionArgs != null && selectionArgs.length > 0) {
                selectionArgs = Arrays.copyOf(selectionArgs, selectionArgs.length + 1);
                selectionArgs[selectionArgs.length - 1] = WHERE_CALENDARS_ARGS[0];
            } else {
                selectionArgs = WHERE_CALENDARS_ARGS;
            }
        }
        return cr.query(builder.build(), projection, selection, selectionArgs, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
    }

    public static void buildEventsFromCursor(ArrayList<Event> events, Cursor cEvents, Context context, int startDay, int endDay) {
        if (cEvents == null || events == null) {
            return;
        }
        int count = cEvents.getCount();
        if (count == 0) {
            return;
        }
        Resources res = context.getResources();
        mNoTitleString = "";
        mNoColorColor = -16777216;
        cEvents.moveToPosition(-1);
        while (cEvents.moveToNext()) {
            Event e = Event.generateEventFromCursor(cEvents);
            if (e.startDay > endDay || e.endDay < startDay) continue;
            events.add(e);
        }
    }

    private static Event generateEventFromCursor(Cursor cEvents) {
        Event e = new Event();
        e.id = cEvents.getLong(5);
        e.title = cEvents.getString(0);
        e.location = cEvents.getString(1);
        e.allDay = cEvents.getInt(2) != 0;
        e.organizer = cEvents.getString(17);
        boolean bl = e.guestsCanModify = cEvents.getInt(18) != 0;
        if (e.title == null || e.title.length() == 0) {
            e.title = mNoTitleString;
        }
        e.color = !cEvents.isNull(3) ? -16777216 : mNoColorColor;
        long eStart = cEvents.getLong(6);
        long eEnd = cEvents.getLong(7);
        e.startMillis = eStart;
        e.startTime = cEvents.getInt(11);
        e.startDay = cEvents.getInt(9);
        e.endMillis = eEnd;
        e.endTime = cEvents.getInt(12);
        e.endDay = cEvents.getInt(10);
        e.hasAlarm = cEvents.getInt(13) != 0;
        String rrule = cEvents.getString(14);
        String rdate = cEvents.getString(15);
        e.isRepeating = !TextUtils.isEmpty((CharSequence)rrule) || !TextUtils.isEmpty((CharSequence)rdate);
        e.rrule = rrule;
        e.selfAttendeeStatus = cEvents.getInt(16);
        e.description = cEvents.getString(20);
        return e;
    }

    static void computePositions(ArrayList<Event> eventsList, long minimumDurationMillis) {
        if (eventsList == null) {
            return;
        }
        Event.doComputePositions(eventsList, minimumDurationMillis, false);
        Event.doComputePositions(eventsList, minimumDurationMillis, true);
    }

    private static void doComputePositions(ArrayList<Event> eventsList, long minimumDurationMillis, boolean doAlldayEvents) {
        ArrayList<Event> activeList = new ArrayList<Event>();
        ArrayList<Event> groupList = new ArrayList<Event>();
        if (minimumDurationMillis < 0L) {
            minimumDurationMillis = 0L;
        }
        long colMask = 0L;
        int maxCols = 0;
        for (Event event : eventsList) {
            int col;
            if (event.drawAsAllday() != doAlldayEvents) continue;
            colMask = !doAlldayEvents ? Event.removeNonAlldayActiveEvents(event, activeList.iterator(), minimumDurationMillis, colMask) : Event.removeAlldayActiveEvents(event, activeList.iterator(), colMask);
            if (activeList.isEmpty()) {
                for (Event ev : groupList) {
                    ev.setMaxColumns(maxCols);
                }
                maxCols = 0;
                colMask = 0L;
                groupList.clear();
            }
            if ((col = Event.findFirstZeroBit(colMask)) == 64) {
                col = 63;
            }
            colMask |= 1L << col;
            event.setColumn(col);
            activeList.add(event);
            groupList.add(event);
            int len = activeList.size();
            if (maxCols >= len) continue;
            maxCols = len;
        }
        for (Event ev : groupList) {
            ev.setMaxColumns(maxCols);
        }
    }

    private static long removeAlldayActiveEvents(Event event, Iterator<Event> iter, long colMask) {
        while (iter.hasNext()) {
            Event active = iter.next();
            if (active.endDay >= event.startDay) continue;
            colMask &= 1L << active.getColumn() ^ 0xFFFFFFFFFFFFFFFFL;
            iter.remove();
        }
        return colMask;
    }

    private static long removeNonAlldayActiveEvents(Event event, Iterator<Event> iter, long minDurationMillis, long colMask) {
        long start = event.getStartMillis();
        while (iter.hasNext()) {
            Event active = iter.next();
            long duration = Math.max(active.getEndMillis() - active.getStartMillis(), minDurationMillis);
            if (active.getStartMillis() + duration > start) continue;
            colMask &= 1L << active.getColumn() ^ 0xFFFFFFFFFFFFFFFFL;
            iter.remove();
        }
        return colMask;
    }

    public static int findFirstZeroBit(long val) {
        for (int ii = 0; ii < 64; ++ii) {
            if ((val & 1L << ii) != 0L) continue;
            return ii;
        }
        return 64;
    }

    public final void dump() {
    }

    public final boolean intersects(int julianDay, int startMinute, int endMinute) {
        if (this.endDay < julianDay) {
            return false;
        }
        if (this.startDay > julianDay) {
            return false;
        }
        if (this.endDay == julianDay) {
            if (this.endTime < startMinute) {
                return false;
            }
            if (this.endTime == startMinute && (this.startTime != this.endTime || this.startDay != this.endDay)) {
                return false;
            }
        }
        return this.startDay != julianDay || this.startTime <= endMinute;
    }

    public String getTitleAndLocation() {
        String locationString;
        String text = this.title.toString();
        if (this.location != null && !text.endsWith(locationString = this.location.toString())) {
            text = text + ", " + locationString;
        }
        return text;
    }

    public void setColumn(int column) {
        this.mColumn = column;
    }

    public int getColumn() {
        return this.mColumn;
    }

    public void setMaxColumns(int maxColumns) {
        this.mMaxColumns = maxColumns;
    }

    public int getMaxColumns() {
        return this.mMaxColumns;
    }

    public void setStartMillis(long startMillis) {
        this.startMillis = startMillis;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public void setEndMillis(long endMillis) {
        this.endMillis = endMillis;
    }

    public long getEndMillis() {
        return this.endMillis;
    }

    public boolean drawAsAllday() {
        return this.allDay || this.endMillis - this.startMillis >= 86400000L;
    }

    static {
        if (!Event.isJellybeanOrLater()) {
            Event.EVENT_PROJECTION[3] = "calendar_color";
        }
    }
}

