/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.content.Context;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.security.auth.x500.X500Principal;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;

public class EncryptUtils {
    private static final String TAG = EncryptUtils.class.getSimpleName();
    private static final String CIPHER_TRANSFORMATION_OAEP = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private static final String CIPHER_TRANSFORMATION_PKCS = "RSA/ECB/PKCS1Padding";
    private String mCipherTransformation = "RSA/ECB/PKCS1Padding";
    static EncryptUtils encryptUtilsInstance;
    KeyStore keyStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EncryptUtils getInstance() {
        Class<EncryptUtils> clazz = EncryptUtils.class;
        synchronized (EncryptUtils.class) {
            if (null == encryptUtilsInstance) {
                encryptUtilsInstance = new EncryptUtils();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return encryptUtilsInstance;
        }
    }

    private EncryptUtils() {
    }

    private boolean initKeyStore(Context context, String alias) {
        try {
            this.keyStore = KeyStore.getInstance("AndroidKeyStore");
            this.keyStore.load(null);
        }
        catch (Exception e) {
            return false;
        }
        if (OsUtil.isAtLeastJB_MR2()) {
            return this.createNewKeys(context, alias);
        }
        return false;
    }

    private boolean createNewKeys(Context context, String alias) {
        if (!StringUtil.isEmptyOrNull(alias)) {
            try {
                if (!this.keyStore.containsAlias(alias)) {
                    Calendar start = Calendar.getInstance();
                    Calendar end = Calendar.getInstance();
                    end.add(1, 20);
                    KeyPairGeneratorSpec spec = null;
                    if (OsUtil.isAtLeastM()) {
                        this.mCipherTransformation = CIPHER_TRANSFORMATION_PKCS;
                        spec = new KeyGenParameterSpec.Builder(alias, 3).setCertificateSubject(new X500Principal("CN=" + alias)).setEncryptionPaddings(new String[]{"PKCS1Padding"}).setCertificateSerialNumber(BigInteger.TEN).setCertificateNotBefore(start.getTime()).setCertificateNotAfter(end.getTime()).build();
                    } else if (OsUtil.isAtLeastJB_MR2()) {
                        this.mCipherTransformation = CIPHER_TRANSFORMATION_PKCS;
                        spec = new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setSubject(new X500Principal("CN=" + alias)).setSerialNumber(BigInteger.TEN).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
                    } else {
                        this.mCipherTransformation = CIPHER_TRANSFORMATION_PKCS;
                    }
                    KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    if (OsUtil.isAtLeastJB_MR2()) {
                        generator.initialize((AlgorithmParameterSpec)spec);
                    }
                    generator.generateKeyPair();
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public String encryptString(Context context, String needEncryptWord, String alias) {
        if (!StringUtil.isEmptyOrNull(alias) && !StringUtil.isEmptyOrNull(needEncryptWord)) {
            boolean isInitKeyStore = false;
            if (OsUtil.isAtLeastJB_MR2()) {
                isInitKeyStore = this.initKeyStore(context, alias);
            }
            if (!isInitKeyStore) {
                return "";
            }
            String encryptStr = "";
            byte[] vals = null;
            try {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, null);
                if (needEncryptWord.isEmpty()) {
                    return encryptStr;
                }
                Cipher inCipher = Cipher.getInstance(this.mCipherTransformation);
                inCipher.init(1, privateKeyEntry.getCertificate().getPublicKey());
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, inCipher);
                cipherOutputStream.write(needEncryptWord.getBytes("UTF-8"));
                cipherOutputStream.close();
                vals = outputStream.toByteArray();
            }
            catch (Exception e) {
                return "";
            }
            return Base64.encodeToString((byte[])vals, (int)0);
        }
        return "";
    }

    public String decryptString(Context context, String needDecryptWord, String alias) {
        if (!StringUtil.isEmptyOrNull(alias) && !StringUtil.isEmptyOrNull(needDecryptWord)) {
            boolean isInitKeyStore = false;
            if (OsUtil.isAtLeastJB_MR2()) {
                isInitKeyStore = this.initKeyStore(context, alias);
            }
            if (!isInitKeyStore) {
                return "";
            }
            String decryptStr = "";
            try {
                int nextByte;
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, null);
                Cipher output = Cipher.getInstance(this.mCipherTransformation);
                output.init(2, privateKeyEntry.getPrivateKey());
                CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(Base64.decode((String)needDecryptWord, (int)0)), output);
                ArrayList<Byte> values = new ArrayList<Byte>();
                while ((nextByte = cipherInputStream.read()) != -1) {
                    values.add((byte)nextByte);
                }
                byte[] bytes = new byte[values.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (Byte)values.get(i);
                }
                decryptStr = new String(bytes, 0, bytes.length, "UTF-8");
            }
            catch (Exception e) {
                return "";
            }
            return decryptStr;
        }
        return "";
    }
}

