/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import java.util.Locale;
import us.zoom.androidlib.app.preference.ZMPreferencesStoreUtils;
import us.zoom.androidlib.util.OsUtil;

public class CompatUtils {
    public static Locale getLocalDefault() {
        if (OsUtil.isAtLeastN()) {
            return Locale.getDefault(Locale.Category.DISPLAY);
        }
        return Locale.getDefault();
    }

    public static int getSystemAlertWindowType(int type) {
        if (OsUtil.isAtLeastO() && (type == 2002 || type == 2007 || type == 2003 || type == 2006 || type == 2010 || type == 2005)) {
            return 2038;
        }
        return type;
    }

    public static void startService(@NonNull Context context, @NonNull Intent service, boolean isBackground, boolean isMultiProcess) {
        ComponentName componentName = service.getComponent();
        if (componentName == null) {
            return;
        }
        boolean isStartForegroundService = false;
        try {
            if (OsUtil.isAtLeastO() && isBackground) {
                context.startForegroundService(service);
                isStartForegroundService = true;
            } else {
                context.startService(service);
                isStartForegroundService = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ZMPreferencesStoreUtils.putBoolean(context, "PREFERENCE_PROVIDER_DEFAULT_SP_NAME", componentName.getClassName(), isStartForegroundService, isMultiProcess);
    }
}

