/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.CalendarContract;
import android.provider.MediaStore;
import android.support.v4.app.Fragment;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.io.File;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import us.zoom.androidlib.R;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.Event;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.androidlib.widget.ZMAlertDialog;

public class AndroidAppUtil {
    private static final String ACTION_MEETING_INVITE = ".intent.action.MeetingInvite";
    private static final String GSF_PACKAGE = "com.google.android.gsf";
    public static final int DEF_REMINDER_MINUTES = 15;
    private static final String TAG = AndroidAppUtil.class.getSimpleName();
    public static final int FILE_TYPE_UNKNOWN = -1;
    public static final int FILE_TYPE_APK = 0;
    public static final int FILE_TYPE_TEXT = 1;
    public static final int FILE_TYPE_HTML = 2;
    public static final int FILE_TYPE_IMAGE = 3;
    public static final int FILE_TYPE_DOC = 4;
    public static final int FILE_TYPE_VIDEO = 5;
    public static final int FILE_TYPE_AUDIO = 6;
    public static final int FILE_TYPE_ZIP = 7;
    public static final int FILE_TYPE_ICS = 8;
    public static final int FILE_TYPE_FOLDER = 100;
    public static final String IMAGE_MIME_TYPE_PNG = "image/png";
    public static final String IMAGE_MIME_TYPE_GIF = "image/gif";
    public static final String IMAGE_MIME_TYPE_JPG = "image/jpeg";
    public static final String IMAGE_MIME_TYPE_UNKNOW = "unknow";
    public static final String FILE_PROVIDER_AUTHORITY = "us.zoom.videomeetings.fileprovider";
    public static String EXTRA_SUBJECT = "android.intent.extra.SUBJECT";
    public static String EXTRA_TEXT = "android.intent.extra.TEXT";
    public static String EXTRA_MEETING_ID = "meetingId";
    public static String EXTRA_MEETING_PSW = "meetingPassword";
    public static String EXTRA_MEETING_RAW_PSW = "meetingRawPassword";
    public static String EXTRA_TOPIC = "meetingTopic";
    public static String EXTRA_IS_REPEAT = "meetingIsRepeat";
    public static String EXTRA_DATE = "meetingDate";
    public static String EXTRA_TIME = "meetingTime";
    private static final String MIMTYPE_FOLDER = "application/vnd.google-apps.folder";
    private static final Object[][] mimeTypesTable = new Object[][]{{".apk", "application/vnd.android.package-archive", 0, R.drawable.zm_ic_filetype_apk}, {".c", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".conf", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".cpp", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".cxx", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".php", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".perl", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".py", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".vbs", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".h", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".java", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".s", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".S", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".log", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".prop", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".rc", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".xml", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".sh", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".bat", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".cmd", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".txt", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".js", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".lrc", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".ini", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".inf", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".properties", "text/plain", 1, R.drawable.zm_ic_filetype_txt}, {".htm", "text/html", 2, R.drawable.zm_ic_filetype_html}, {".html", "text/html", 2, R.drawable.zm_ic_filetype_html}, {".ics", "text/calendar", 8, R.drawable.zm_ic_filetype_txt}, {".bmp", "image/bmp", 3, R.drawable.zm_ic_filetype_image}, {".gif", "image/gif", 3, R.drawable.zm_ic_filetype_image}, {".jpeg", "image/jpeg", 3, R.drawable.zm_ic_filetype_image}, {".jpg", "image/jpeg", 3, R.drawable.zm_ic_filetype_image}, {".png", "image/png", 3, R.drawable.zm_ic_filetype_image}, {".3gp", "video/3gpp", 5, R.drawable.zm_ic_filetype_video}, {".asf", "video/x-ms-asf", 5, R.drawable.zm_ic_filetype_video}, {".avi", "video/x-msvideo", 5, R.drawable.zm_ic_filetype_video}, {".m4u", "video/vnd.mpegurl", 5, R.drawable.zm_ic_filetype_video}, {".m4v", "video/x-m4v", 5, R.drawable.zm_ic_filetype_video}, {".mov", "video/quicktime", 5, R.drawable.zm_ic_filetype_video}, {".mp4", "video/mp4", 5, R.drawable.zm_ic_filetype_video}, {".mpe", "video/mpeg", 5, R.drawable.zm_ic_filetype_video}, {".mpeg", "video/mpeg", 5, R.drawable.zm_ic_filetype_video}, {".mpg", "video/mpeg", 5, R.drawable.zm_ic_filetype_video}, {".mpg4", "video/mp4", 5, R.drawable.zm_ic_filetype_video}, {".wmv", "video/x-ms-wmv", 5, R.drawable.zm_ic_filetype_video}, {".rmvb", "video/x-pn-realaudio", 5, R.drawable.zm_ic_filetype_video}, {".m3u", "audio/x-mpegurl", 6, R.drawable.zm_ic_filetype_audio}, {".m4a", "audio/mp4a-latm", 6, R.drawable.zm_ic_filetype_audio}, {".m4b", "audio/mp4a-latm", 6, R.drawable.zm_ic_filetype_audio}, {".m4p", "audio/mp4a-latm", 6, R.drawable.zm_ic_filetype_audio}, {".mp2", "audio/x-mpeg", 6, R.drawable.zm_ic_filetype_audio}, {".mp3", "audio/x-mpeg", 6, R.drawable.zm_ic_filetype_audio}, {".mpga", "audio/mpeg", 6, R.drawable.zm_ic_filetype_audio}, {".ogg", "audio/ogg", 6, R.drawable.zm_ic_filetype_audio}, {".wav", "audio/x-wav", 6, R.drawable.zm_ic_filetype_audio}, {".wma", "audio/x-ms-wma", 6, R.drawable.zm_ic_filetype_audio}, {".doc", "application/msword", 4, R.drawable.zm_ic_filetype_doc}, {".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", 4, R.drawable.zm_ic_filetype_doc}, {".xls", "application/vnd.ms-excel", 4, R.drawable.zm_ic_filetype_xls}, {".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", 4, R.drawable.zm_ic_filetype_xls}, {".msg", "application/vnd.ms-outlook", 4, R.drawable.zm_ic_filetype_unknown}, {".pdf", "application/pdf", 4, R.drawable.zm_ic_filetype_pdf}, {".pps", "application/vnd.ms-powerpoint", 4, R.drawable.zm_ic_filetype_ppt}, {".ppt", "application/vnd.ms-powerpoint", 4, R.drawable.zm_ic_filetype_ppt}, {".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation", 4, R.drawable.zm_ic_filetype_ppt}, {".rtf", "application/rtf", 4, R.drawable.zm_ic_filetype_doc}, {".wps", "application/vnd.ms-works", 4, R.drawable.zm_ic_filetype_doc}, {".epub", "application/epub+zip", 4, R.drawable.zm_ic_filetype_epud}, {".gtar", "application/x-gtar", 7, R.drawable.zm_ic_filetype_zip}, {".gz", "application/x-gzip", 7, R.drawable.zm_ic_filetype_zip}, {".jar", "application/java-archive", 7, R.drawable.zm_ic_filetype_zip}, {".tar", "application/x-tar", 7, R.drawable.zm_ic_filetype_zip}, {".tgz", "application/x-compressed", 7, R.drawable.zm_ic_filetype_zip}, {".z", "application/x-compress", 7, R.drawable.zm_ic_filetype_zip}, {".zip", "application/x-zip-compressed", 7, R.drawable.zm_ic_filetype_zip}};
    private static final String[] DAY_OF_WEEK = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA"};

    public static Drawable getApplicationIcon(Context context, ResolveInfo info) {
        if (context == null || info == null || info.activityInfo == null) {
            return null;
        }
        ApplicationInfo appInfo = info.activityInfo.applicationInfo;
        return AndroidAppUtil.getApplicationIcon(context, appInfo);
    }

    public static Drawable getApplicationIcon(Context context, ApplicationInfo appInfo) {
        if (context == null || appInfo == null) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return null;
        }
        return pm.getApplicationIcon(appInfo);
    }

    public static String getApplicationLabel(Context context, ResolveInfo info) {
        if (context == null || info == null || info.activityInfo == null) {
            return null;
        }
        ApplicationInfo appInfo = info.activityInfo.applicationInfo;
        return AndroidAppUtil.getApplicationLabel(context, appInfo);
    }

    public static String getApplicationLabel(Context context, ApplicationInfo appInfo) {
        if (context == null || appInfo == null) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return null;
        }
        CharSequence cs = pm.getApplicationLabel(appInfo);
        return cs != null ? cs.toString() : null;
    }

    public static Drawable getActivityIcon(Context context, ResolveInfo info) {
        if (context == null || info == null) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return null;
        }
        return info.loadIcon(pm);
    }

    public static String getActivityLabel(Context context, ResolveInfo info) {
        if (context == null || info == null) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return null;
        }
        CharSequence cs = info.loadLabel(pm);
        return cs != null ? cs.toString() : null;
    }

    public static ApplicationInfo getApplicationInfo(Context context, String packageName) {
        if (context == null || packageName == null) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return null;
        }
        try {
            return pm.getApplicationInfo(packageName, 9344);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static List<ResolveInfo> queryEmailActivities(Context context) {
        PackageManager pm = context.getPackageManager();
        Intent emailIntent = new Intent("android.intent.action.SENDTO");
        emailIntent.setType("vnd.android.cursor.dir/email");
        emailIntent.setData(Uri.parse((String)"mailto:"));
        emailIntent.putExtra("android.intent.extra.SUBJECT", "test topic");
        emailIntent.putExtra("android.intent.extra.TEXT", "test text");
        ArrayList<ResolveInfo> resultList = new ArrayList<ResolveInfo>();
        List<ResolveInfo> list = AndroidAppUtil.queryActivitiesForIntent(context, emailIntent);
        if (list == null) {
            return resultList;
        }
        List<ResolveInfo> smsActivities = AndroidAppUtil.querySMSActivities(context);
        for (ResolveInfo info : list) {
            if (AndroidAppUtil.appExists(info, smsActivities)) continue;
            resultList.add(info);
        }
        Collections.sort(resultList, new ResolbeInfoComparator(CompatUtils.getLocalDefault()));
        return resultList;
    }

    public static boolean hasCameraApp(Context context) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        List<ResolveInfo> list = AndroidAppUtil.queryActivitiesForIntent(context, intent);
        return list != null && list.size() > 0;
    }

    private static boolean appExists(ResolveInfo info, List<ResolveInfo> activities) {
        for (ResolveInfo item : activities) {
            if (item.activityInfo == null || item.activityInfo.packageName == null || info.activityInfo == null) {
                return false;
            }
            if (!item.activityInfo.packageName.equals(info.activityInfo.packageName)) continue;
            return true;
        }
        return false;
    }

    public static List<ResolveInfo> querySMSActivities(Context context) {
        Intent smsIntent = new Intent("android.intent.action.VIEW");
        smsIntent.setType("vnd.android-dir/mms-sms");
        smsIntent.putExtra("sms_body", "test");
        smsIntent.setData(Uri.parse((String)"sms:"));
        List<ResolveInfo> list = AndroidAppUtil.queryActivitiesForIntent(context, smsIntent);
        if (list == null) {
            list = new ArrayList<ResolveInfo>();
        } else {
            Collections.sort(list, new ResolbeInfoComparator(CompatUtils.getLocalDefault()));
        }
        return list;
    }

    public static List<ResolveInfo> queryZoomMeetingInviteActivities(Context context) {
        Intent intent = new Intent(context.getPackageName() + ACTION_MEETING_INVITE);
        List<ResolveInfo> list = AndroidAppUtil.queryActivitiesForIntent(context, intent);
        if (list == null) {
            list = new ArrayList<ResolveInfo>();
        } else {
            Collections.sort(list, new ResolbeInfoComparator(CompatUtils.getLocalDefault()));
        }
        return list;
    }

    public static List<ResolveInfo> queryCalendarActivities(Context context) {
        Intent intent = new Intent("android.intent.action.EDIT");
        intent.setType("vnd.android.cursor.item/event");
        intent.putExtra("title", "test title");
        intent.putExtra("description", "test description");
        intent.putExtra("beginTime", System.currentTimeMillis());
        intent.putExtra("endTime", System.currentTimeMillis());
        List<ResolveInfo> list = AndroidAppUtil.queryActivitiesForIntent(context, intent);
        if (list == null) {
            list = new ArrayList<ResolveInfo>();
        } else {
            Collections.sort(list, new ResolbeInfoComparator(CompatUtils.getLocalDefault()));
        }
        return list;
    }

    public static boolean hasEmailApp(Context context) {
        List<ResolveInfo> apps = AndroidAppUtil.queryEmailActivities(context);
        return apps.size() > 0;
    }

    public static boolean hasSMSApp(Context context) {
        List<ResolveInfo> apps = AndroidAppUtil.querySMSActivities(context);
        return apps.size() > 0;
    }

    public static boolean hasCalendarApp(Context context) {
        List<ResolveInfo> apps = AndroidAppUtil.queryCalendarActivities(context);
        return apps.size() > 0;
    }

    public static boolean sendEmailVia(ResolveInfo activity, Context context, String[] email, String topic, String content, String stream) {
        if (content != null) {
            content = content.replace("\r\n", "\n");
        }
        Intent intent = new Intent();
        intent.setType("vnd.android.cursor.dir/email");
        if (email == null || email.length == 0 || !StringUtil.isEmptyOrNull(stream)) {
            intent.setAction("android.intent.action.SEND");
        } else {
            intent.setAction("android.intent.action.SENDTO");
            intent.setData(Uri.parse((String)"mailto:"));
        }
        intent.putExtra("android.intent.extra.SUBJECT", topic);
        intent.putExtra("android.intent.extra.TEXT", content);
        if (email != null && email.length > 0) {
            intent.putExtra("android.intent.extra.EMAIL", email);
        }
        if (!StringUtil.isEmptyOrNull(stream)) {
            Uri uri = null;
            if (OsUtil.isAtLeastN()) {
                File tmp = new File(Uri.parse((String)stream).getPath());
                if (tmp.exists()) {
                    uri = FileProvider.getUriForFile((Context)context, (String)FILE_PROVIDER_AUTHORITY, (File)tmp);
                    intent.addFlags(1);
                }
            } else {
                uri = Uri.parse((String)stream);
            }
            if (uri != null) {
                intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            }
        }
        if (activity != null && activity.activityInfo != null) {
            intent.setClassName(activity.activityInfo.packageName, activity.activityInfo.name);
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean sendEmail(Context context, String[] email, String topic, String content, String stream) {
        return AndroidAppUtil.sendEmailVia(null, context, email, topic, content, stream);
    }

    public static boolean sendZoomMeetingInvitationVia(ResolveInfo info, Activity activity, String meetingUrl, String topic, String content, long meetingId, String meetingPassword, String meetingRawPassword, int requestCode) {
        Intent intent = new Intent(activity.getPackageName() + ACTION_MEETING_INVITE);
        Uri uri = null;
        try {
            uri = Uri.parse((String)meetingUrl);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (uri != null) {
            intent.setData(uri);
        }
        intent.putExtra(EXTRA_SUBJECT, topic);
        intent.putExtra(EXTRA_TEXT, content);
        intent.putExtra(EXTRA_MEETING_ID, meetingId);
        intent.putExtra(EXTRA_MEETING_PSW, meetingPassword);
        intent.putExtra(EXTRA_MEETING_RAW_PSW, meetingRawPassword);
        if (info != null && info.activityInfo != null) {
            intent.setClassName(info.activityInfo.packageName, info.activityInfo.name);
        }
        try {
            activity.startActivityForResult(intent, requestCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean sendZoomMeetingInvitation(Activity activity, String meetingUrl, String topic, String content, long meetingId, String meetingPassword, String meetingRawPassword, int requestCode) {
        return AndroidAppUtil.sendZoomMeetingInvitationVia(null, activity, meetingUrl, topic, content, meetingId, meetingPassword, meetingRawPassword, requestCode);
    }

    public static boolean sendSMSVia(ResolveInfo activity, Context context, String[] phoneNumbers, String content) {
        if (context == null || activity == null || activity.activityInfo == null) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setType("vnd.android-dir/mms-sms");
        intent.putExtra("sms_body", content);
        if (phoneNumbers != null && phoneNumbers.length > 0) {
            char delimiter = ';';
            if ("samsung".equalsIgnoreCase(Build.MANUFACTURER)) {
                delimiter = ',';
            }
            StringBuilder numbers = new StringBuilder();
            for (int i = 0; i < phoneNumbers.length; ++i) {
                numbers.append(phoneNumbers[i]);
                if (i >= phoneNumbers.length - 1) continue;
                numbers.append(delimiter);
            }
            intent.setData(Uri.parse((String)("smsto:" + numbers.toString())));
        } else {
            intent.setData(Uri.parse((String)"sms:"));
        }
        if (activity != null && activity.activityInfo != null) {
            intent.setClassName(activity.activityInfo.packageName, activity.activityInfo.name);
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void sendSMS(Context context, String[] phoneNumbers, String content) {
        AndroidAppUtil.sendSMSVia(null, context, phoneNumbers, content);
    }

    public static boolean createCalendarEventVia(ResolveInfo activity, Context context, long eventStartInMillis, long eventEndInMillis, String title, String description, String location) {
        if (context == null) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.EDIT");
        intent.setType("vnd.android.cursor.item/event");
        if (title != null) {
            intent.putExtra("title", title);
        }
        if (description != null) {
            intent.putExtra("description", description);
        }
        if (eventStartInMillis > 0L) {
            intent.putExtra("beginTime", eventStartInMillis);
        }
        if (eventEndInMillis > 0L) {
            intent.putExtra("endTime", eventEndInMillis);
        }
        intent.putExtra("allDay", false);
        if (location != null) {
            intent.putExtra("eventLocation", location);
        }
        if (activity != null) {
            intent.setClassName(activity.activityInfo.packageName, activity.activityInfo.name);
        }
        try {
            context.startActivity(intent);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void sendDial(Context context, String phoneNo) {
        if (context == null || StringUtil.isEmptyOrNull(phoneNo)) {
            return;
        }
        try {
            Uri uri = Uri.parse((String)("tel:" + phoneNo));
            Intent it = new Intent();
            it.setAction("android.intent.action.DIAL");
            it.setData(uri);
            context.startActivity(it);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean createCalendarEvent(Context context, long eventStartInMillis, long eventEndInMillis, String title, String description, String location) {
        return AndroidAppUtil.createCalendarEventVia(null, context, eventStartInMillis, eventEndInMillis, title, description, location);
    }

    @SuppressLint(value={"NewApi"})
    public static long[] queryCalendarEventsForMeeting(Context context, long meetingID, String joinMeetingUrl) {
        if (context == null || meetingID <= 0L) {
            return null;
        }
        Uri uri = null;
        String selection = null;
        if (Build.VERSION.SDK_INT < 14) {
            uri = Uri.parse((String)"content://com.android.calendar/events");
            selection = "(((eventLocation = ?) OR (description LIKE ?)) AND (deleted = ?))";
        } else {
            uri = CalendarContract.Events.CONTENT_URI;
            selection = "(((eventLocation = ?) OR (description like ?)) AND (deleted = ?))";
        }
        Cursor cur = null;
        ContentResolver cr = context.getContentResolver();
        String[] selectionArgs = new String[]{joinMeetingUrl, "%" + joinMeetingUrl + "%", "0"};
        String[] EVENT_PROJECTION = new String[]{"_id"};
        boolean EVENT_ID_INDEX = false;
        try {
            cur = cr.query(uri, EVENT_PROJECTION, selection, selectionArgs, null);
        }
        catch (Exception e) {
            return null;
        }
        if (cur == null) {
            return new long[0];
        }
        long[] ids = new long[cur.getCount()];
        int idx = 0;
        while (cur.moveToNext()) {
            long eventID = cur.getLong(0);
            ids[idx++] = eventID;
        }
        cur.close();
        return ids;
    }

    @SuppressLint(value={"NewApi"})
    public static Event loadCalendarEvent(Context context, long eventID) {
        if (context == null || eventID < 0L) {
            return null;
        }
        Uri uri = null;
        uri = Build.VERSION.SDK_INT < 14 ? Uri.parse((String)"content://com.android.calendar/events") : CalendarContract.Events.CONTENT_URI;
        uri = ContentUris.withAppendedId((Uri)uri, (long)eventID);
        Cursor cur = null;
        ContentResolver cr = context.getContentResolver();
        String[] EVENT_PROJECTION = new String[]{"dtstart", "title", "description", "eventLocation", "rrule", "duration", "dtend"};
        try {
            cur = cr.query(uri, EVENT_PROJECTION, null, null, null);
        }
        catch (Exception e) {
            return null;
        }
        if (cur == null) {
            return null;
        }
        Event event = null;
        if (cur.getCount() > 0) {
            cur.moveToNext();
            event = new Event();
            event.id = eventID;
            event.startMillis = cur.getLong(0);
            event.title = cur.getString(1);
            event.location = cur.getString(3);
            event.rrule = cur.getString(4);
            event.endMillis = cur.getLong(6);
        }
        cur.close();
        return event;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean updateCalendarEvent(Context context, long eventID, long eventStartInMillis, long eventEndInMillis, String title, String description, String location, String rrule) {
        if (context == null || eventID < 0L) {
            return false;
        }
        Uri uri = null;
        uri = Build.VERSION.SDK_INT < 14 ? Uri.parse((String)"content://com.android.calendar/events") : CalendarContract.Events.CONTENT_URI;
        uri = ContentUris.withAppendedId((Uri)uri, (long)eventID);
        ContentResolver cr = context.getContentResolver();
        ContentValues values = new ContentValues();
        if (Build.VERSION.SDK_INT < 14) {
            if (eventStartInMillis > 0L) {
                values.put("dtstart", Long.valueOf(eventStartInMillis));
            }
            if (title != null) {
                values.put("title", title);
            }
            if (description != null) {
                values.put("description", description);
            }
            if (location != null) {
                values.put("eventLocation", location);
            }
            if (!StringUtil.isEmptyOrNull(rrule)) {
                values.put("rrule", rrule);
                values.put("duration", "P" + (eventEndInMillis - eventStartInMillis) / 1000L + "S");
            } else if (eventEndInMillis > 0L) {
                values.put("dtend", Long.valueOf(eventEndInMillis));
            }
        } else {
            if (eventStartInMillis > 0L) {
                values.put("dtstart", Long.valueOf(eventStartInMillis));
            }
            if (title != null) {
                values.put("title", title);
            }
            if (description != null) {
                values.put("description", description);
            }
            if (location != null) {
                values.put("eventLocation", location);
            }
            if (!StringUtil.isEmptyOrNull(rrule)) {
                values.put("rrule", rrule);
                values.put("duration", "P" + (eventEndInMillis - eventStartInMillis) / 1000L + "S");
            } else if (eventEndInMillis > 0L) {
                values.put("dtend", Long.valueOf(eventEndInMillis));
            }
        }
        try {
            int rows = cr.update(uri, values, null, null);
            return rows > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void editCalendarEvent(Context context, long eventID, long eventStartInMillis, long eventEndInMillis, String title, String description, String location, boolean editMode) {
        Uri eventsUri = null;
        eventsUri = Build.VERSION.SDK_INT < 14 ? Uri.parse((String)"content://com.android.calendar/events") : CalendarContract.Events.CONTENT_URI;
        Uri uri = ContentUris.withAppendedId((Uri)eventsUri, (long)eventID);
        Intent intent = new Intent("android.intent.action.EDIT");
        intent.setData(uri);
        intent.putExtra("editMode", editMode);
        if (title != null) {
            intent.putExtra("title", title);
        }
        if (description != null) {
            intent.putExtra("description", description);
        }
        if (eventStartInMillis > 0L) {
            intent.putExtra("beginTime", eventStartInMillis);
        }
        if (eventEndInMillis > 0L) {
            intent.putExtra("endTime", eventEndInMillis);
        }
        if (location != null) {
            intent.putExtra("eventLocation", location);
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void viewCalendarEvent(Context context, long eventID) {
        AndroidAppUtil.viewCalendarEvent(context, eventID, 0L, 0L);
    }

    @SuppressLint(value={"NewApi"})
    public static void viewCalendarEvent(Context context, long eventID, long eventStartInMillis, long eventEndInMillis) {
        Uri eventsUri = null;
        eventsUri = Build.VERSION.SDK_INT < 14 ? Uri.parse((String)"content://com.android.calendar/events") : CalendarContract.Events.CONTENT_URI;
        Uri uri = ContentUris.withAppendedId((Uri)eventsUri, (long)eventID);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(uri);
        if (eventStartInMillis > 0L) {
            intent.putExtra("beginTime", eventStartInMillis);
        }
        if (eventEndInMillis > 0L) {
            intent.putExtra("endTime", eventEndInMillis);
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SuppressLint(value={"NewApi"})
    public static int deleteCalendarEvent(Context context, long eventID) {
        if (context == null || eventID < 0L) {
            return 0;
        }
        AndroidAppUtil.deleteRemindersForEvent(context, eventID);
        Uri uri = null;
        uri = Build.VERSION.SDK_INT < 14 ? Uri.parse((String)"content://com.android.calendar/events") : CalendarContract.Events.CONTENT_URI;
        uri = ContentUris.withAppendedId((Uri)uri, (long)eventID);
        ContentResolver cr = context.getContentResolver();
        try {
            int rows = cr.delete(uri, null, null);
            return rows;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @SuppressLint(value={"NewApi"})
    private static int deleteRemindersForEvent(Context context, long eventID) {
        if (context == null || eventID < 0L) {
            return 0;
        }
        Uri uri = null;
        String where = null;
        if (Build.VERSION.SDK_INT < 14) {
            uri = Uri.parse((String)"content://com.android.calendar/reminders");
            where = "(event_id = ?)";
        } else {
            uri = CalendarContract.Reminders.CONTENT_URI;
            where = "(event_id = ?)";
        }
        String[] selectionArgs = new String[]{String.valueOf(eventID)};
        ContentResolver cr = context.getContentResolver();
        try {
            int rows = cr.delete(uri, where, selectionArgs);
            return rows;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @SuppressLint(value={"NewApi"})
    private static long selectDefaultCalendar(Context context, String email) {
        if (context == null) {
            return 0L;
        }
        Uri uri = null;
        String[] CALENDAR_PROJECTION = null;
        if (Build.VERSION.SDK_INT < 14) {
            uri = Uri.parse((String)"content://com.android.calendar/calendars");
            CALENDAR_PROJECTION = new String[]{"_id", "_sync_account", "_sync_account_type", "ownerAccount"};
        } else {
            uri = CalendarContract.Calendars.CONTENT_URI;
            CALENDAR_PROJECTION = new String[]{"_id", "account_name", "account_type", "ownerAccount"};
        }
        Cursor cur = null;
        ContentResolver cr = context.getContentResolver();
        boolean PROJECTION_ID_INDEX = false;
        boolean PROJECTION_ACCOUNT_NAME_INDEX = true;
        int PROJECTION_ACCOUNT_TYPE_INDEX = 2;
        int PROJECTION_OWNER_ACCOUNT_INDEX = 3;
        cur = cr.query(uri, CALENDAR_PROJECTION, null, null, null);
        if (cur == null) {
            return 0L;
        }
        long firstCalID = -1L;
        long firstGoogleCal = -1L;
        while (cur.moveToNext()) {
            long calID = 0L;
            String accountName = null;
            String ownerName = null;
            String accountType = null;
            calID = cur.getLong(0);
            accountName = cur.getString(1);
            ownerName = cur.getString(3);
            accountType = cur.getString(2);
            if (StringUtil.isEmptyOrNull(email)) {
                return calID;
            }
            email = email.toLowerCase();
            ownerName = ownerName != null ? ownerName.toLowerCase() : "";
            String string2 = accountName = accountName != null ? accountName.toLowerCase() : "";
            if ("com.google".equals(accountType) && email.equals(ownerName) && email.equals(accountName)) {
                return calID;
            }
            if (firstCalID == -1L) {
                firstCalID = calID;
            }
            if (firstGoogleCal != -1L || !accountType.equals("com.google") || ownerName.length() <= 0 || !ownerName.equals(accountName)) continue;
            firstGoogleCal = calID;
        }
        cur.close();
        return firstGoogleCal >= 0L ? firstGoogleCal : firstCalID;
    }

    public static long addNewCalendarEvent(Context context, String myEmail, long startTime, long endTime, String title, String description, String location) {
        return AndroidAppUtil.addNewCalendarEvent(context, myEmail, startTime, endTime, title, description, location, null);
    }

    public static long addNewCalendarEvent(Context context, String myEmail, long startTime, long endTime, String title, String description, String location, String rrule) {
        try {
            long calId = AndroidAppUtil.selectDefaultCalendar(context, myEmail);
            if (calId < 0L) {
                return -1L;
            }
            return AndroidAppUtil.addNewCalendarEvent(context, calId, startTime, endTime, title, description, location, rrule);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @SuppressLint(value={"NewApi"})
    private static long addNewCalendarEvent(Context context, long calendarId, long startTime, long endTime, String title, String description, String location, String rrule) {
        if (context == null) {
            return -1L;
        }
        Uri contentUri = null;
        ContentValues values = new ContentValues();
        if (Build.VERSION.SDK_INT < 14) {
            values.put("dtstart", Long.valueOf(startTime));
            values.put("title", title);
            values.put("description", description);
            values.put("calendar_id", Long.valueOf(calendarId));
            values.put("eventLocation", location);
            values.put("eventTimezone", TimeZone.getDefault().getID());
            values.put("hasAlarm", Integer.valueOf(1));
            if (!StringUtil.isEmptyOrNull(rrule)) {
                values.put("rrule", rrule);
                values.put("duration", "P" + (endTime - startTime) / 1000L + "S");
            } else {
                values.put("dtend", Long.valueOf(endTime));
            }
            contentUri = Uri.parse((String)"content://com.android.calendar/events");
        } else {
            values.put("dtstart", Long.valueOf(startTime));
            values.put("title", title);
            values.put("description", description);
            values.put("calendar_id", Long.valueOf(calendarId));
            values.put("eventLocation", location);
            values.put("eventTimezone", TimeZone.getDefault().getID());
            values.put("hasAlarm", Integer.valueOf(1));
            if (!StringUtil.isEmptyOrNull(rrule)) {
                values.put("rrule", rrule);
                values.put("duration", "P" + (endTime - startTime) / 1000L + "S");
            } else {
                values.put("dtend", Long.valueOf(endTime));
            }
            contentUri = CalendarContract.Events.CONTENT_URI;
        }
        ContentResolver cr = context.getContentResolver();
        Uri uri = cr.insert(contentUri, values);
        if (uri == null) {
            return -1L;
        }
        long eventID = Long.parseLong(uri.getLastPathSegment());
        AndroidAppUtil.addReminder(context, eventID, 15);
        return eventID;
    }

    @SuppressLint(value={"NewApi"})
    private static long addReminder(Context context, long eventID, int minutes) {
        if (context == null) {
            return -1L;
        }
        Uri contentUri = null;
        ContentValues values = new ContentValues();
        if (Build.VERSION.SDK_INT < 14) {
            values.put("minutes", Integer.valueOf(minutes));
            values.put("event_id", Long.valueOf(eventID));
            values.put("method", Integer.valueOf(1));
            contentUri = Uri.parse((String)"content://com.android.calendar/reminders");
        } else {
            values.put("minutes", Integer.valueOf(minutes));
            values.put("event_id", Long.valueOf(eventID));
            values.put("method", Integer.valueOf(1));
            contentUri = CalendarContract.Reminders.CONTENT_URI;
        }
        ContentResolver cr = context.getContentResolver();
        Uri uri = cr.insert(contentUri, values);
        if (uri == null) {
            return -1L;
        }
        long reminderID = Long.parseLong(uri.getLastPathSegment());
        return reminderID;
    }

    public static String buildCalendarRrule(Date dtStart, EventRepeatType repeatType, int count) {
        if (repeatType == EventRepeatType.NONE) {
            return null;
        }
        boolean needByDay = false;
        StringBuilder res = new StringBuilder();
        res.append("FREQ=");
        switch (repeatType) {
            case DAILY: {
                res.append("DAILY;");
                break;
            }
            case WORKDAY: {
                res.append("WEEKLY;");
                break;
            }
            case WEEKLY: {
                needByDay = true;
                res.append("WEEKLY;");
                break;
            }
            case BIWEEKLY: {
                needByDay = true;
                res.append("WEEKLY;INTERVAL=2;");
                break;
            }
            case MONTHLY: {
                res.append("MONTHLY;");
                break;
            }
            case YEARLY: {
                res.append("YEARLY;");
            }
        }
        if (count > 0) {
            res.append("COUNT=" + count + ";");
        }
        res.append("WKST=SU");
        if (needByDay) {
            res.append(";");
            res.append(AndroidAppUtil.buildByDay(dtStart));
        }
        if (repeatType == EventRepeatType.WORKDAY) {
            res.append(";BYDAY=MO,TU,WE,TH,FR");
        }
        return res.toString();
    }

    public static String buildCalendarRrule(Date dtStart, EventRepeatType repeatType, Date untilTime) {
        if (repeatType == EventRepeatType.NONE) {
            return null;
        }
        boolean needByDay = false;
        StringBuilder res = new StringBuilder();
        res.append("FREQ=");
        switch (repeatType) {
            case DAILY: {
                res.append("DAILY;");
                break;
            }
            case WORKDAY: {
                res.append("WEEKLY;");
                break;
            }
            case WEEKLY: {
                needByDay = true;
                res.append("WEEKLY;");
                break;
            }
            case BIWEEKLY: {
                needByDay = true;
                res.append("WEEKLY;INTERVAL=2;");
                break;
            }
            case MONTHLY: {
                res.append("MONTHLY;");
                break;
            }
            case YEARLY: {
                res.append("YEARLY;");
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-hhmmss");
        if (untilTime != null && untilTime.getTime() > 0L) {
            res.append("UNTIL=" + format.format(untilTime).replace('-', 'T') + "Z;");
        }
        res.append("WKST=SU");
        if (needByDay) {
            res.append(";");
            res.append(AndroidAppUtil.buildByDay(dtStart));
        }
        if (repeatType == EventRepeatType.WORKDAY) {
            res.append(";BYDAY=MO,TU,WE,TH,FR");
        }
        return res.toString();
    }

    private static String buildByDay(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int day = cal.get(7) - 1;
        return "BYDAY=" + DAY_OF_WEEK[day];
    }

    public static boolean isC2DMCapable(Context context) {
        if ("OPPO".equals(Build.MANUFACTURER)) {
            return false;
        }
        return AndroidAppUtil.hasGSFPackage(context) && AndroidAppUtil.hasC2DMPermission(context);
    }

    public static int getAppVersionCode(Context context) {
        if (context == null) {
            return 0;
        }
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pInfo.versionCode;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static boolean hasC2DMPermission(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        if (pm == null) {
            return false;
        }
        return 0 == pm.checkPermission("com.google.android.c2dm.permission.RECEIVE", context.getPackageName());
    }

    private static boolean hasGSFPackage(Context context) {
        int version = Build.VERSION.SDK_INT;
        if (version < 8) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getPackageInfo(GSF_PACKAGE, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean copyText(Context context, CharSequence text) {
        if (context == null) {
            return false;
        }
        try {
            if (Build.VERSION.SDK_INT < 11) {
                android.text.ClipboardManager clipboard = (android.text.ClipboardManager)context.getSystemService("clipboard");
                if (clipboard == null) {
                    return false;
                }
                clipboard.setText(text);
                return true;
            }
            ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
            if (clipboard == null) {
                return false;
            }
            ClipData data = ClipData.newPlainText(null, (CharSequence)text);
            if (data == null) {
                return false;
            }
            clipboard.setPrimaryClip(data);
            return true;
        }
        catch (Exception e) {
            ZMLog.e(TAG, e, "copy to clipboard failed", new Object[0]);
            return false;
        }
    }

    private static int getJpegRotation(String imagePath) {
        try {
            ExifInterface exif = new ExifInterface(imagePath);
            int orientation = exif.getAttributeInt("Orientation", 1);
            int angle = 0;
            if (orientation == 6) {
                angle = 90;
            } else if (orientation == 3) {
                angle = 180;
            } else if (orientation == 8) {
                angle = 270;
            }
            return angle;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void addImageToGallery(Context context, String imagePath) {
        AndroidAppUtil.addImageToGallery(context, imagePath, IMAGE_MIME_TYPE_JPG);
    }

    public static void addImageToGallery(Context context, String imagePath, String mimeType) {
        if (StringUtil.isEmptyOrNull(mimeType) || IMAGE_MIME_TYPE_UNKNOW.equals(mimeType)) {
            return;
        }
        if (context == null || StringUtil.isEmptyOrNull(imagePath)) {
            return;
        }
        File file = new File(imagePath);
        if (!file.exists()) {
            return;
        }
        try {
            ContentValues values = new ContentValues();
            values.put("_data", imagePath);
            values.put("datetaken", Long.valueOf(file.lastModified()));
            values.put("date_added", Long.valueOf(file.lastModified()));
            values.put("date_modified", Long.valueOf(file.lastModified()));
            values.put("mime_type", mimeType);
            values.put("orientation", Integer.valueOf(AndroidAppUtil.getJpegRotation(imagePath)));
            ContentResolver contentResolver = context.getContentResolver();
            Uri localUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            contentResolver.insert(localUri, values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MimeType getMimeTypeOfFile(String fileName) {
        String ext = AndroidAppUtil.getFileExtendName(fileName);
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase(Locale.US);
        for (Object[] item : mimeTypesTable) {
            if (!StringUtil.isSameString(ext, (String)item[0])) continue;
            String sType = (String)item[1];
            int fileType = (Integer)item[2];
            return new MimeType(sType, fileType);
        }
        return null;
    }

    public static int getFileTypeFromMimType(String mimType) {
        if (StringUtil.isEmptyOrNull(mimType)) {
            return -1;
        }
        if (MIMTYPE_FOLDER.equals(mimType)) {
            return 100;
        }
        for (Object[] item : mimeTypesTable) {
            String sType = (String)item[1];
            int fileType = (Integer)item[2];
            if (!StringUtil.isSameString(sType, mimType)) continue;
            return fileType;
        }
        return -1;
    }

    public static String getFileExtendNameFromMimType(String mimType) {
        if (StringUtil.isEmptyOrNull(mimType)) {
            return "";
        }
        if (MIMTYPE_FOLDER.equals(mimType)) {
            return "";
        }
        for (Object[] item : mimeTypesTable) {
            String sType = (String)item[1];
            int fileType = (Integer)item[2];
            if (!StringUtil.isSameString(sType, mimType)) continue;
            return (String)item[0];
        }
        return "";
    }

    public static String getFileExtendName(String fileName) {
        if (StringUtil.isEmptyOrNull(fileName)) {
            return null;
        }
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos < 0) {
            return null;
        }
        String ext = fileName.substring(dotPos);
        return ext;
    }

    public static String getPathLastName(String path) {
        int separatorIndex;
        if (StringUtil.isEmptyOrNull(path)) {
            return null;
        }
        if ("/".equals(path)) {
            return path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (separatorIndex = path.lastIndexOf("/")) < 0 ? path : path.substring(separatorIndex + 1, path.length());
    }

    public static boolean hasActivityToOpenFile(Context context, File file) {
        if (context == null || file == null) {
            return false;
        }
        String fileName = file.getName();
        MimeType mimeType = AndroidAppUtil.getMimeTypeOfFile(fileName);
        if (mimeType == null) {
            return false;
        }
        Intent intent = AndroidAppUtil.buildIntentToOpenFile(context, file, mimeType);
        return AndroidAppUtil.hasActivityForIntent(context, intent);
    }

    public static boolean openFile(Context context, File file) {
        return AndroidAppUtil.openFile(context, file, false);
    }

    public static boolean openFile(Context context, File file, boolean ignoreSelf) {
        if (context == null || file == null || !file.exists()) {
            return false;
        }
        String fileName = file.getName();
        MimeType mimeType = AndroidAppUtil.getMimeTypeOfFile(fileName);
        if (mimeType == null) {
            return false;
        }
        Intent intent = AndroidAppUtil.buildIntentToOpenFile(context, file, mimeType);
        if (ignoreSelf ? !AndroidAppUtil.hasActivityForIntentIgnoreSelf(context, intent) : !AndroidAppUtil.hasActivityForIntent(context, intent)) {
            return false;
        }
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static Intent buildIntentToOpenFile(Context context, File file, MimeType mimeType) {
        Uri uri;
        if (file == null || mimeType == null) {
            return null;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        if (OsUtil.isAtLeastN()) {
            uri = FileProvider.getUriForFile((Context)context, (String)FILE_PROVIDER_AUTHORITY, (File)file);
            intent.addFlags(1);
        } else {
            uri = Uri.fromFile((File)file);
        }
        intent.setDataAndType(uri, mimeType.mimeType);
        if (mimeType.fileType == 6 || mimeType.fileType == 5) {
            intent.putExtra("oneshot", 0);
            intent.putExtra("configchange", 0);
        }
        return intent;
    }

    public static boolean hasActiviyToSelectImage(Context context) {
        Intent intent = AndroidAppUtil.createIntentForSelectImage();
        return AndroidAppUtil.hasActivityForIntent(context, intent);
    }

    public static Intent createIntentForSelectImage() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT", null);
        intent.setType("image/*");
        return intent;
    }

    public static List<ResolveInfo> queryActivitiesForSelectImage(Context context) {
        if (context == null) {
            return null;
        }
        Intent intent = AndroidAppUtil.createIntentForSelectImage();
        return AndroidAppUtil.queryActivitiesForIntent(context, intent);
    }

    public static boolean selectImageNoDefault(Activity activity, int titleRes, int requestCode) {
        return AndroidAppUtil.selectImageNoDefault(null, activity, titleRes, requestCode);
    }

    public static boolean selectImageNoDefault(Fragment fragment, int titleRes, int requestCode) {
        return AndroidAppUtil.selectImageNoDefault(fragment, null, titleRes, requestCode);
    }

    private static boolean selectImageNoDefault(final Fragment fragment, Activity activity, int titleRes, final int requestCode) {
        if (activity == null && fragment == null) {
            return false;
        }
        if (activity == null) {
            activity = fragment.getActivity();
        }
        if (activity == null) {
            return false;
        }
        List<ResolveInfo> apps = AndroidAppUtil.queryActivitiesForSelectImage((Context)activity);
        if (apps == null) {
            return false;
        }
        ArrayList<AppItem> items = new ArrayList<AppItem>();
        for (ResolveInfo info : apps) {
            items.add(new AppItem(info));
        }
        final AppListAdapter adapter = new AppListAdapter((ZMActivity)activity, items);
        final Activity _activity = activity;
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(titleRes != 0 ? titleRes : R.string.zm_select_a_image).setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppItem item = (AppItem)adapter.getItem(which);
                AndroidAppUtil.onSelectSelectImageItem(_activity, fragment, item, requestCode);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
        return true;
    }

    private static void onSelectSelectImageItem(Activity activity, Fragment fragment, AppItem item, int requestCode) {
        Intent intent = AndroidAppUtil.createIntentForSelectImage();
        if (item != null && item.appInfo != null && item.appInfo.activityInfo != null) {
            intent.setClassName(item.appInfo.activityInfo.packageName, item.appInfo.activityInfo.name);
        }
        try {
            if (fragment != null) {
                fragment.startActivityForResult(intent, requestCode);
            } else if (activity != null) {
                activity.startActivityForResult(intent, requestCode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<ResolveInfo> queryActivitiesForIntent(Context context, Intent intent) {
        if (context == null || intent == null) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        ArrayList list = null;
        try {
            list = pm.queryIntentActivities(intent, 65536);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public static boolean hasActivityForIntentIgnoreSelf(Context context, Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        List<ResolveInfo> list = AndroidAppUtil.queryActivitiesForIntent(context, intent);
        if (list == null || list.size() <= 0) {
            return false;
        }
        int count = 0;
        for (ResolveInfo info : list) {
            if (TextUtils.equals((CharSequence)info.activityInfo.packageName, (CharSequence)context.getApplicationContext().getPackageName())) continue;
            ++count;
        }
        return count > 0;
    }

    public static boolean hasActivityForIntent(Context context, Intent intent) {
        if (context == null || intent == null) {
            return false;
        }
        List<ResolveInfo> list = AndroidAppUtil.queryActivitiesForIntent(context, intent);
        return list != null && list.size() > 0;
    }

    public static PackageInfo getPackageInfo(Context context, String packetName) {
        int version = Build.VERSION.SDK_INT;
        if (version < 8 || StringUtil.isEmptyOrNull(packetName)) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        PackageInfo info = null;
        try {
            info = packageManager.getPackageInfo(packetName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        return info;
    }

    public static int getIconForFile(String file) {
        if (file == null) {
            return R.drawable.zm_ic_filetype_unknown;
        }
        String ext = AndroidAppUtil.getFileExtendName(file);
        if (ext == null) {
            return R.drawable.zm_ic_filetype_unknown;
        }
        ext = ext.toLowerCase(Locale.US);
        for (Object[] item : mimeTypesTable) {
            if (!StringUtil.isSameString(ext, (String)item[0])) continue;
            return (Integer)item[3];
        }
        return R.drawable.zm_ic_filetype_unknown;
    }

    static class AppListAdapter
    extends BaseAdapter {
        private ZMActivity mActivity;
        private List<AppItem> mList;

        public AppListAdapter(ZMActivity activity, List<AppItem> items) {
            this.mActivity = activity;
            this.mList = items;
        }

        public int getCount() {
            return this.mList.size();
        }

        public Object getItem(int position) {
            if (position < 0 || position >= this.mList.size()) {
                return null;
            }
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Object oItem = this.getItem(position);
            if (convertView == null) {
                convertView = View.inflate((Context)this.mActivity, (int)R.layout.zm_app_item, null);
            }
            ImageView imgIcon = (ImageView)convertView.findViewById(R.id.imgIcon);
            TextView txtLabel = (TextView)convertView.findViewById(R.id.txtLabel);
            if (oItem instanceof AppItem) {
                AppItem item = (AppItem)oItem;
                if (item.appInfo != null) {
                    imgIcon.setVisibility(0);
                    imgIcon.setImageDrawable(AndroidAppUtil.getApplicationIcon((Context)this.mActivity, item.appInfo));
                    txtLabel.setText((CharSequence)AndroidAppUtil.getApplicationLabel((Context)this.mActivity, item.appInfo));
                }
            }
            return convertView;
        }
    }

    static class AppItem {
        ResolveInfo appInfo = null;

        AppItem(ResolveInfo info) {
            this.appInfo = info;
        }
    }

    public static class MimeType {
        public int fileType = -1;
        public String mimeType;

        public MimeType(String mimeType, int fileType) {
            this.mimeType = mimeType;
            this.fileType = fileType;
        }
    }

    static class ResolbeInfoComparator
    implements Comparator<ResolveInfo> {
        private Collator mCollator;

        public ResolbeInfoComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(ResolveInfo lhs, ResolveInfo rhs) {
            return this.mCollator.compare(lhs.activityInfo.name, rhs.activityInfo.name);
        }
    }

    public static enum EventRepeatType {
        NONE,
        DAILY,
        WORKDAY,
        WEEKLY,
        BIWEEKLY,
        MONTHLY,
        YEARLY,
        UNKNOWN;

    }
}

