/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;

public class ProxyConfig {
    private Proxy mProxy;

    public ProxyConfig(Proxy proxy) {
        this.mProxy = proxy;
    }

    public String getHost() {
        if (this.mProxy == null || this.mProxy.type() == Proxy.Type.DIRECT) {
            return null;
        }
        InetSocketAddress address = (InetSocketAddress)this.mProxy.address();
        if (address != null) {
            return address.getHostName();
        }
        return null;
    }

    public int getPort() {
        if (this.mProxy == null || this.mProxy.type() == Proxy.Type.DIRECT) {
            return 0;
        }
        InetSocketAddress address = (InetSocketAddress)this.mProxy.address();
        if (address != null) {
            return address.getPort();
        }
        return 0;
    }

    public Proxy.Type getProxyType() {
        if (this.mProxy == null) {
            return Proxy.Type.DIRECT;
        }
        return this.mProxy.type();
    }

    public String toString() {
        Proxy.Type type = this.getProxyType();
        if (type == Proxy.Type.DIRECT || this.mProxy == null) {
            return "";
        }
        String scheme = null;
        if (type == Proxy.Type.HTTP) {
            scheme = "http";
        } else if (type == Proxy.Type.SOCKS) {
            scheme = "socks";
        }
        if (scheme == null) {
            return "";
        }
        return scheme + "://" + this.getHost() + ":" + this.getPort();
    }
}

