/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import us.zoom.androidlib.R;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.androidlib.widget.ZMTipLayer;

public class ZMTipFragment
extends ZMFragment {
    private static final String TAG = "ZMTipFragment";
    private boolean mbRemoved = true;
    private long mlShowTime = 0L;
    private long mlDuration = 0L;
    private Handler mHandler = new Handler();
    private Runnable mDismissRunnable;
    private ZMTip mTip;
    private boolean mCanDismiss = false;
    private boolean mShowsTip = false;
    protected boolean mAutoFocus = true;

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        View view;
        super.onActivityCreated(savedInstanceState);
        SparseArray tipState = null;
        if (savedInstanceState != null) {
            tipState = savedInstanceState.getSparseParcelableArray("tipState");
            this.mlDuration = savedInstanceState.getLong("duration");
            this.mShowsTip = savedInstanceState.getBoolean("showsTip");
        }
        if ((view = this.getView()) != null && tipState != null) {
            view.restoreHierarchyState(tipState);
        }
        if (this.mShowsTip) {
            ZMTip tip = this.onCreateTip((Context)this.getActivity(), this.getLayoutInflater(savedInstanceState), savedInstanceState);
            if (tip == null) {
                if (view == null) {
                    return;
                }
                tip = new ZMTip((Context)this.getActivity());
                tip.addView(view);
            } else if (view == null && tipState != null) {
                tip.restoreHierarchyState(tipState);
            }
            this.mTip = tip;
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.mDismissRunnable != null) {
            this.mHandler.removeCallbacks(this.mDismissRunnable);
        }
        this.mlDuration -= System.currentTimeMillis() - this.mlShowTime;
        SparseArray container = new SparseArray();
        View view = this.getView();
        if (view != null) {
            view.saveHierarchyState(container);
        } else if (this.mTip != null) {
            this.mTip.saveHierarchyState(container);
        }
        outState.putSparseParcelableArray("tipState", container);
        outState.putLong("duration", this.mlDuration);
        outState.putBoolean("showsTip", this.mShowsTip);
        super.onSaveInstanceState(outState);
        this.mCanDismiss = false;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (!this.isInMultWindowMode()) {
            this.performResume();
        }
    }

    private void performResume() {
        FragmentActivity context;
        if (!this.mShowsTip) {
            return;
        }
        if (this.mTip != null) {
            ZMTipLayer tipLayer = this.getTipLayer();
            if (tipLayer == null) {
                throw new RuntimeException("cannot find a ZPTipLayer width id: " + R.class.getName() + ".id.tipLayer");
            }
            this.mTip.show(tipLayer);
            this.mbRemoved = false;
            this.mCanDismiss = true;
        }
        this.mlShowTime = System.currentTimeMillis();
        if (this.mlDuration > 0L) {
            this.mDismissRunnable = new Runnable(){

                @Override
                public void run() {
                    ZMTipFragment.this.dismiss();
                }
            };
            this.mHandler.postDelayed(this.mDismissRunnable, this.mlDuration);
        }
        if ((context = this.getActivity()) != null && this.mAutoFocus && AccessibilityUtil.isSpokenFeedbackEnabled((Context)context)) {
            try {
                if (this.mTip != null) {
                    this.mTip.sendAccessibilityEvent(8);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.isInMultWindowMode()) {
            this.performResume();
        }
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        return null;
    }

    private ZMTipLayer getTipLayer() {
        Resources res = this.getActivity().getResources();
        if (res == null) {
            return null;
        }
        int id2 = res.getIdentifier("tipLayer", "id", res.getResourcePackageName(R.id.zm_used_for_package_name_retrieval));
        if (id2 == 0) {
            return null;
        }
        ZMTipLayer tipLayer = this.getZMTipLayer(id2);
        return tipLayer;
    }

    protected ZMTipLayer getZMTipLayer(int id2) {
        return (ZMTipLayer)this.getActivity().getWindow().getDecorView().findViewById(id2);
    }

    public void show(FragmentManager manager, String tag) {
        this.show(manager, tag, 0L);
    }

    public void show(FragmentManager manager, String tag, long duration) {
        if (!this.mbRemoved) {
            return;
        }
        this.mShowsTip = true;
        this.mbRemoved = false;
        this.mlDuration = duration;
        try {
            manager.beginTransaction().add((Fragment)this, tag).commitAllowingStateLoss();
        }
        catch (Exception e) {
            ZMLog.e(TAG, e, "", new Object[0]);
        }
        this.mCanDismiss = true;
    }

    public void show(FragmentTransaction transaction, String tag) {
        this.show(transaction, tag, 0L);
    }

    public void show(FragmentTransaction transaction, String tag, long duration) {
        if (!this.mbRemoved) {
            return;
        }
        this.mShowsTip = true;
        this.mbRemoved = false;
        this.mlDuration = duration;
        try {
            transaction.add((Fragment)this, tag).commitAllowingStateLoss();
        }
        catch (Exception e) {
            ZMLog.e(TAG, e, "", new Object[0]);
        }
        this.mCanDismiss = true;
    }

    public void dismiss() {
        FragmentTransaction transaction;
        if (this.mbRemoved || !this.mCanDismiss) {
            return;
        }
        this.mShowsTip = false;
        this.mbRemoved = true;
        if (this.mTip != null) {
            this.mTip.dismiss();
        }
        this.mTip = null;
        FragmentManager fm = this.getFragmentManager();
        if (fm != null && (transaction = fm.beginTransaction()) != null) {
            transaction.remove((Fragment)this).commitAllowingStateLoss();
        }
    }

    public ZMTip getTip() {
        return this.mTip;
    }

    public boolean getShowsTip() {
        return this.mShowsTip;
    }
}

