/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.app.Dialog;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMActivityCompat;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;

public class ZMFragment
extends Fragment
implements IUIElement {
    private static final String TAG = ZMFragment.class.getSimpleName();
    private EventTaskManager mTaskMgr = null;
    private RetainedFragment mRetainedFragment = null;
    private Handler mHandler = new Handler();

    public final EventTaskManager getEventTaskManager() {
        RetainedFragment f = this.getRetainedFragment();
        if (f != null) {
            return f.mTaskMgr;
        }
        return null;
    }

    @NonNull
    public final EventTaskManager getNonNullEventTaskManagerOrThrowException() {
        RetainedFragment f = this.getRetainedFragment();
        if (f != null) {
            return f.mTaskMgr;
        }
        throw new NullPointerException("Exception in getNonNullEventTaskManagerOrThrowException. class=" + this.getClass().getName());
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initRetainedFragment();
        this.mTaskMgr = this.getRetainedFragment().mTaskMgr;
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            try {
                this.mRetainedFragment = new RetainedFragment();
                this.getFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, this.getClass().getName() + ":" + RetainedFragment.class.getName()).commitAllowingStateLoss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = this.getFragmentManager();
        RetainedFragment retainedFragment = (RetainedFragment)fm.findFragmentByTag(this.getClass().getName() + ":" + RetainedFragment.class.getName());
        return retainedFragment;
    }

    public void finishActivity(int requestCode) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        activity.finishActivityFromFragment(this, requestCode);
    }

    public void zm_requestPermissions(String[] permissions, int requestCode) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        ZMActivityCompat.requestPermissionsFromFragment(this, permissions, requestCode);
    }

    public int checkSelfPermission(String permission2) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return -1;
        }
        if (StringUtil.isEmptyOrNull(permission2)) {
            throw new IllegalArgumentException("permission is null");
        }
        try {
            return activity.checkPermission(permission2, Process.myPid(), Process.myUid());
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mTaskMgr != null) {
            this.mTaskMgr.onUIDestroy(this);
            FragmentActivity activity = this.getActivity();
            if (activity != null && activity.isFinishing() || this.isRemoving()) {
                this.mTaskMgr.destroy();
            }
        }
    }

    public void onPause() {
        super.onPause();
        if (!this.isInMultWindowMode() && this.mTaskMgr != null) {
            this.mTaskMgr.onPause(this);
        }
    }

    public void onResume() {
        super.onResume();
        if (!this.isInMultWindowMode()) {
            this.performResume();
        }
    }

    private void performResume() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if ((!ZMFragment.this.isInMultWindowMode() && ZMFragment.this.isResumed() || ZMFragment.this.isInMultWindowMode() && ZMFragment.this.isVisible()) && ZMFragment.this.mTaskMgr != null) {
                    ZMFragment.this.mTaskMgr.onResume(ZMFragment.this);
                }
            }
        });
    }

    public void onStart() {
        try {
            super.onStart();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in ZMFragment.onStart(). class=" + this.getClass().getName(), e);
        }
        if (this.mTaskMgr != null) {
            this.mTaskMgr.onStart(this);
        }
        if (this.isInMultWindowMode()) {
            this.performResume();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.mTaskMgr != null) {
            this.mTaskMgr.onStop(this);
        }
    }

    public View getContentView() {
        return ContentViewHelper.getFragmentContentView(this);
    }

    public boolean isInMultWindowMode() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return activity.isInMultiWindowMode();
        }
        return false;
    }

    public static class RetainedFragment
    extends Fragment {
        EventTaskManager mTaskMgr = new EventTaskManager();

        public RetainedFragment() {
            this.setRetainInstance(true);
        }
    }

    public static class ContentViewHelper {
        public static View getFragmentContentView(Fragment fragment) {
            Window window;
            Dialog dlg;
            if (fragment == null) {
                return null;
            }
            View view = fragment.getView();
            if (view != null) {
                if ("android.support.v4.app.Fragment".equals(ZMFragment.class.getSuperclass().getName()) && view instanceof ViewGroup) {
                    view = ((ViewGroup)view).getChildAt(0);
                }
            } else if (fragment instanceof DialogFragment && (dlg = ((DialogFragment)fragment).getDialog()) != null && (window = dlg.getWindow()) != null) {
                view = window.getDecorView();
            }
            return view;
        }
    }
}

