/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.TimeUtil;

public class ZMFileListItemView
extends LinearLayout {
    private Context mContext;
    private TextView mDisplayName;
    private ImageView mIcon;
    private ImageView mFolderIndicator;
    private TextView mLastModifiedDate;
    private TextView mCountOrSize;
    private TextView mSeparator;
    private CheckedTextView mFileIndicator;
    private boolean mChecked = false;

    public ZMFileListItemView(Context context) {
        super(context);
        this.mContext = context;
        this.initView(context);
    }

    public ZMFileListItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    @SuppressLint(value={"NewApi"})
    public ZMFileListItemView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        View.inflate((Context)context, (int)R.layout.zm_file_list_item, (ViewGroup)this);
        this.mDisplayName = (TextView)this.findViewById(R.id.txtFileName);
        this.mIcon = (ImageView)this.findViewById(R.id.fileIcon);
        this.mFolderIndicator = (ImageView)this.findViewById(R.id.folderIndicator);
        this.mCountOrSize = (TextView)this.findViewById(R.id.txtFileSize);
        this.mLastModifiedDate = (TextView)this.findViewById(R.id.txtDate);
        this.mSeparator = (TextView)this.findViewById(R.id.separator);
        this.mFileIndicator = (CheckedTextView)this.findViewById(R.id.check);
    }

    public void setDisplayName(String name) {
        if (name == null) {
            this.mDisplayName.setText((CharSequence)"");
        } else {
            this.mDisplayName.setText((CharSequence)name);
        }
    }

    public void setIcon(int resId) {
        this.mIcon.setImageResource(resId);
    }

    public void setFolderIndicatorVisible(boolean visible) {
        if (visible) {
            this.mFolderIndicator.setVisibility(0);
        } else {
            this.mFolderIndicator.setVisibility(8);
        }
    }

    public void setChildrenCount(int count) {
        this.mCountOrSize.setVisibility(8);
        this.checkSeparator();
    }

    public void setFileSize(long size) {
        if (size < 0L) {
            this.mCountOrSize.setVisibility(8);
        } else {
            this.mCountOrSize.setVisibility(0);
            String strSize = FileUtils.toFileSizeString(this.mContext, size);
            this.mCountOrSize.setText((CharSequence)strSize);
        }
        this.checkSeparator();
    }

    public void setLastModified(long date) {
        if (date <= 0L) {
            this.mLastModifiedDate.setVisibility(8);
            this.checkSeparator();
            return;
        }
        this.mLastModifiedDate.setText((CharSequence)TimeUtil.formatDateWithYear(this.mContext, date));
        this.mLastModifiedDate.setVisibility(0);
        this.checkSeparator();
    }

    private void checkSeparator() {
        if (this.mLastModifiedDate.getVisibility() == 0 && this.mCountOrSize.getVisibility() == 0) {
            this.mSeparator.setVisibility(0);
        } else {
            this.mSeparator.setVisibility(8);
        }
    }

    public void setItemChecked(boolean checked) {
        this.mChecked = checked;
        if (this.mChecked) {
            this.mFileIndicator.setVisibility(0);
            this.mFileIndicator.setChecked(this.mChecked);
        } else {
            this.mFileIndicator.setVisibility(8);
        }
    }
}

