/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import us.zoom.androidlib.R;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFileListEntry;
import us.zoom.androidlib.app.ZMFileListItemView;
import us.zoom.androidlib.app.ZMFileListListener;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;

public abstract class ZMFileListBaseAdapter
extends BaseAdapter {
    protected ZMActivity mActivity;
    protected LayoutInflater mInflater;
    private int mSelectedPos = -1;
    protected ArrayList<String> mFilterExtensions = new ArrayList();
    protected ArrayList<AndroidAppUtil.MimeType> mFilterMimtypes = new ArrayList();
    protected ArrayList<ZMFileListEntry> mFileList = new ArrayList();
    protected String mLastErrorMessage = null;
    protected ProgressDialog mWaitingDialog = null;
    protected final long MIN_CHECK_SPACE_SIZE = 0x3200000L;

    public Context getContext() {
        return this.mActivity;
    }

    public ZMActivity getActivity() {
        return this.mActivity;
    }

    public void init(ZMActivity activity, ZMFileListListener l) {
        this.mActivity = activity;
        this.mInflater = (LayoutInflater)this.mActivity.getSystemService("layout_inflater");
    }

    public boolean isNeedAuth() {
        return false;
    }

    public boolean hasAuthorized() {
        return false;
    }

    public void onStoragePermissionResult(int permission2) {
    }

    public void setLastErrorMessage(String message) {
        this.mLastErrorMessage = message;
    }

    public String getLastErrorMessage() {
        return this.mLastErrorMessage;
    }

    public void login() {
    }

    public void logout() {
    }

    public void onDestroy() {
        this.dismissWaitingDialog();
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onStart() {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public final void upDir() {
        this.mSelectedPos = -1;
        this.gotoParentDir();
    }

    public abstract boolean openDir(String var1);

    public abstract boolean isRootDir();

    public abstract String getCurrentDirName();

    public abstract String getCurrentDirPath();

    protected abstract void gotoParentDir();

    public void onRefresh() {
        this.notifyDataSetChanged();
    }

    public void onClickItem(int position) {
        if (position >= this.getCount()) {
            return;
        }
        ZMFileListEntry entry = this.getItem(position);
        if (entry.isDir()) {
            this.openDir(entry);
            this.mSelectedPos = -1;
            this.notifyDataSetChanged();
            return;
        }
        this.mSelectedPos = this.mSelectedPos == position ? -1 : position;
        this.notifyDataSetChanged();
    }

    public boolean isFileSelected() {
        if (this.mSelectedPos < 0 || this.mSelectedPos > this.getCount()) {
            return false;
        }
        return !this.isDir(this.mSelectedPos);
    }

    public boolean onBackPressed() {
        if (this.isRootDir()) {
            return true;
        }
        this.upDir();
        return false;
    }

    public void openSelectedFile() {
        if (this.mSelectedPos < 0 || this.mSelectedPos > this.getCount()) {
            return;
        }
        ZMFileListEntry entry = this.getItem(this.mSelectedPos);
        this.openFile(entry);
    }

    protected boolean isDir(int position) {
        ZMFileListEntry entry = this.getItem(position);
        if (entry == null) {
            return false;
        }
        return entry.isDir();
    }

    public int getCount() {
        return this.mFileList.size();
    }

    public ZMFileListEntry getItem(int position) {
        if (position >= this.mFileList.size()) {
            return null;
        }
        return this.mFileList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    private View getFileItemView(ZMFileListEntry entry, View convertView, ViewGroup parent, boolean selectted) {
        if (entry == null) {
            return null;
        }
        ZMFileListItemView view = convertView == null || !(convertView instanceof ZMFileListItemView) ? new ZMFileListItemView((Context)this.mActivity) : (ZMFileListItemView)convertView;
        view.setDisplayName(entry.getDisplayName());
        if (entry.isDir()) {
            view.setFolderIndicatorVisible(true);
        } else {
            view.setFolderIndicatorVisible(false);
        }
        String path = entry.getPath();
        if (entry.isDir()) {
            view.setIcon(R.drawable.zm_ic_filetype_folder);
        } else {
            view.setIcon(AndroidAppUtil.getIconForFile(path));
        }
        view.setLastModified(entry.getDate());
        if (entry.isDir()) {
            view.setChildrenCount(entry.getChildEntryCount());
        } else {
            view.setFileSize(entry.getBytes());
        }
        view.setItemChecked(selectted);
        return view;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ZMFileListEntry entry = this.getItem(position);
        if (entry == null) {
            return null;
        }
        return this.getFileItemView(entry, convertView, parent, position == this.mSelectedPos);
    }

    protected void showToast(String msg) {
        Toast error = Toast.makeText((Context)this.mActivity, (CharSequence)msg, (int)1);
        error.show();
    }

    protected void openDir(ZMFileListEntry dir) {
    }

    protected void openFile(ZMFileListEntry file) {
    }

    public void setFilterExtens(String[] extentions) {
        this.mFilterExtensions.clear();
        this.mFilterMimtypes.clear();
        if (extentions == null || extentions.length <= 0) {
            return;
        }
        for (String ext : extentions) {
            if (StringUtil.isEmptyOrNull(ext)) continue;
            this.mFilterExtensions.add(ext);
            this.mFilterMimtypes.add(AndroidAppUtil.getMimeTypeOfFile(ext));
        }
    }

    protected boolean acceptFileType(String file) {
        if (StringUtil.isEmptyOrNull(file)) {
            return false;
        }
        if (this.mFilterExtensions.size() <= 0) {
            return true;
        }
        String extension = AndroidAppUtil.getFileExtendName(file);
        if (extension == null) {
            return false;
        }
        return this.mFilterExtensions.contains(extension.toLowerCase(Locale.US));
    }

    protected boolean acceptFileTypeByMimeType(String mimType) {
        if (StringUtil.isEmptyOrNull(mimType)) {
            return false;
        }
        if (this.mFilterMimtypes.size() <= 0) {
            return true;
        }
        for (AndroidAppUtil.MimeType type : this.mFilterMimtypes) {
            if (!mimType.equals(type.mimeType)) continue;
            return true;
        }
        return false;
    }

    protected void sortFileList() {
        if (this.mFileList != null && this.mFileList.size() > 0) {
            Collections.sort(this.mFileList, new ItemFileNameComparator());
        }
    }

    protected void showWaitingDialog(String message, DialogInterface.OnCancelListener cancelListener) {
        if (this.mWaitingDialog != null || !this.mActivity.isActive()) {
            return;
        }
        this.mWaitingDialog = new ProgressDialog((Context)this.mActivity);
        this.mWaitingDialog.setOnCancelListener(cancelListener);
        this.mWaitingDialog.setCancelable(true);
        this.mWaitingDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (ZMFileListBaseAdapter.this.mWaitingDialog != null && ZMFileListBaseAdapter.this.mWaitingDialog.isShowing()) {
                    return;
                }
                ZMFileListBaseAdapter.this.mWaitingDialog = null;
            }
        });
        this.mWaitingDialog.requestWindowFeature(1);
        this.mWaitingDialog.setMessage((CharSequence)message);
        this.mWaitingDialog.setCanceledOnTouchOutside(false);
        this.mWaitingDialog.show();
    }

    protected void dismissWaitingDialog() {
        if (this.mWaitingDialog == null) {
            return;
        }
        if (this.mWaitingDialog != null && this.mWaitingDialog.isShowing()) {
            this.mWaitingDialog.dismiss();
        }
        this.mWaitingDialog = null;
    }

    protected void updateProgressWaitingDialog(String progressMsg) {
        if (this.mWaitingDialog == null) {
            return;
        }
        this.mWaitingDialog.setMessage((CharSequence)progressMsg);
    }

    protected void alertMemoryNotEnough(String title, String message) {
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.mActivity).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        if (!StringUtil.isEmptyOrNull(title)) {
            builder.setTitle(title);
        }
        if (!StringUtil.isEmptyOrNull(message)) {
            builder.setMessage(message);
        }
        ZMAlertDialog dialog = builder.create();
        dialog.show();
    }

    private class ItemFileNameComparator
    implements Comparator<ZMFileListEntry> {
        private ItemFileNameComparator() {
        }

        @Override
        public int compare(ZMFileListEntry lhs, ZMFileListEntry rhs) {
            if (lhs.isDir() && !rhs.isDir()) {
                return -1;
            }
            if (!lhs.isDir() && rhs.isDir()) {
                return 1;
            }
            Locale locale = CompatUtils.getLocalDefault();
            String lhsName = lhs.getDisplayName().toLowerCase(locale);
            String rhsName = rhs.getDisplayName().toLowerCase(locale);
            return lhsName.compareTo(rhsName);
        }
    }
}

