/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.SparseArray;
import android.view.View;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMActivityCompat;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;

public class ZMDialogFragment
extends DialogFragment
implements IUIElement {
    private static final String TAG = ZMDialogFragment.class.getSimpleName();
    private EventTaskManager mTaskMgr = null;
    private RetainedFragment mRetainedFragment = null;
    private boolean mIsEmptyDialog;
    private Handler mHandler = new Handler();

    public final EventTaskManager getEventTaskManager() {
        RetainedFragment f = this.getRetainedFragment();
        if (f != null) {
            return f.mTaskMgr;
        }
        return null;
    }

    @NonNull
    public final EventTaskManager getNonNullEventTaskManagerOrThrowException() {
        RetainedFragment f = this.getRetainedFragment();
        if (f != null) {
            return f.mTaskMgr;
        }
        throw new NullPointerException("Exception in getNonNullEventTaskManagerOrThrowException. class=" + this.getClass().getName());
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        try {
            super.onActivityCreated(savedInstanceState);
        }
        catch (Exception e) {
            String activityClass = null;
            boolean isActive = false;
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity != null) {
                activityClass = activity.getClass().getName();
                isActive = activity.isActive();
                if (activity.isFinishing()) {
                    return;
                }
                if (ZMActivity.isActivityDestroyed((Activity)activity)) {
                    return;
                }
            }
            throw new RuntimeException("Exception in onActivityCreated. class=" + this.getClass().getName() + ", activityClass=" + activityClass + ", isActive=" + isActive, e);
        }
        if (savedInstanceState != null) {
            this.onRestoreInstanceState(savedInstanceState);
        }
        this.initRetainedFragment();
        RetainedFragment f = this.getRetainedFragment();
        if (f != null) {
            this.mTaskMgr = f.mTaskMgr;
        }
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            try {
                this.mRetainedFragment = new RetainedFragment();
                this.getFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, this.getClass().getName() + ":" + RetainedFragment.class.getName()).commitAllowingStateLoss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean isInMultWindowMode() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return activity.isInMultiWindowMode();
        }
        return false;
    }

    public void zm_requestPermissions(String[] permissions, int requestCode) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        ZMActivityCompat.requestPermissionsFromFragment((Fragment)this, permissions, requestCode);
    }

    public int checkSelfPermission(String permission) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return -1;
        }
        if (StringUtil.isEmptyOrNull(permission)) {
            throw new IllegalArgumentException("permission is null");
        }
        try {
            return activity.checkPermission(permission, Process.myPid(), Process.myUid());
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        RetainedFragment retainedFragment = null;
        FragmentManager fm = this.getFragmentManager();
        if (fm != null) {
            retainedFragment = (RetainedFragment)fm.findFragmentByTag(this.getClass().getName() + ":" + RetainedFragment.class.getName());
        }
        return retainedFragment;
    }

    public void finishActivity(int requestCode) {
        ZMActivity activity = (ZMActivity)this.getActivity();
        if (activity == null) {
            return;
        }
        activity.finishActivityFromFragment((Fragment)this, requestCode);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mTaskMgr != null) {
            this.mTaskMgr.onUIDestroy(this);
        }
        FragmentActivity activity = this.getActivity();
        if (this.mTaskMgr != null && (activity != null && activity.isFinishing() || this.isRemoving())) {
            this.mTaskMgr.destroy();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mTaskMgr != null && !this.isInMultWindowMode()) {
            this.mTaskMgr.onPause(this);
        }
    }

    public void onResume() {
        super.onResume();
        if (!this.isInMultWindowMode()) {
            this.performResume();
        }
    }

    private void performResume() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if ((!ZMDialogFragment.this.isInMultWindowMode() && ZMDialogFragment.this.isResumed() || ZMDialogFragment.this.isInMultWindowMode() && ZMDialogFragment.this.isVisible()) && ZMDialogFragment.this.mTaskMgr != null) {
                    ZMDialogFragment.this.mTaskMgr.onResume(ZMDialogFragment.this);
                }
            }
        });
    }

    public void onStart() {
        try {
            super.onStart();
        }
        catch (Exception e) {
            String activityClass = null;
            boolean isActive = false;
            ZMActivity activity = (ZMActivity)this.getActivity();
            if (activity != null) {
                activityClass = activity.getClass().getName();
                isActive = activity.isActive();
                if (activity.isFinishing()) {
                    return;
                }
                if (ZMActivity.isActivityDestroyed((Activity)activity)) {
                    return;
                }
            }
            throw new RuntimeException("Exception in ZMDialogFragment.onStart(). class=" + this.getClass().getName() + ", activityClass=" + activityClass + ", isActive=" + isActive, e);
        }
        if (this.mTaskMgr != null) {
            this.mTaskMgr.onStart(this);
        }
        if (this.isInMultWindowMode()) {
            this.performResume();
        }
        if (this.mIsEmptyDialog) {
            this.dismiss();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.mTaskMgr != null) {
            this.mTaskMgr.onStop(this);
        }
    }

    public void show(FragmentManager manager, String tag) {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            if (activity.isFinishing()) {
                return;
            }
            if (ZMActivity.isActivityDestroyed((Activity)activity)) {
                return;
            }
        }
        try {
            super.show(manager, tag);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int show(FragmentTransaction transaction, String tag) {
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            if (activity.isFinishing()) {
                return -1;
            }
            if (ZMActivity.isActivityDestroyed((Activity)activity)) {
                return -1;
            }
            return -1;
        }
        try {
            return super.show(transaction, tag);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void dismiss() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        FragmentManager fm = activity.getSupportFragmentManager();
        if (fm == null || fm.isStateSaved()) {
            return;
        }
        super.dismiss();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        View view = this.getContentView();
        if (view != null) {
            SparseArray contentViewState = new SparseArray();
            view.saveHierarchyState(contentViewState);
            outState.putSparseParcelableArray("saasbee_contentViewState", contentViewState);
        }
    }

    protected void finishFragment(boolean enableAnim) {
        if (this.getShowsDialog()) {
            super.dismissAllowingStateLoss();
        } else {
            FragmentActivity zmActivity = this.getActivity();
            if (zmActivity != null) {
                zmActivity.finish();
                if (!enableAnim) {
                    zmActivity.overridePendingTransition(0, 0);
                }
            }
        }
    }

    protected void finishFragment(int result) {
        if (this.getShowsDialog()) {
            super.dismissAllowingStateLoss();
        } else {
            FragmentActivity zmActivity = this.getActivity();
            if (zmActivity != null) {
                zmActivity.setResult(result);
                zmActivity.finish();
            }
        }
    }

    private void onRestoreInstanceState(Bundle savedInstanceState) {
        SparseArray contentViewState;
        View view = this.getContentView();
        if (view != null && (contentViewState = savedInstanceState.getSparseParcelableArray("saasbee_contentViewState")) != null) {
            try {
                view.restoreHierarchyState(contentViewState);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Dialog createEmptyDialog() {
        this.mIsEmptyDialog = true;
        return new ZMAlertDialog.Builder((Context)this.getActivity()).create();
    }

    public View getContentView() {
        return ZMFragment.ContentViewHelper.getFragmentContentView((Fragment)this);
    }

    public static class RetainedFragment
    extends Fragment {
        EventTaskManager mTaskMgr = new EventTaskManager();

        public RetainedFragment() {
            this.setRetainInstance(true);
        }
    }
}

