/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.os.Handler;
import java.util.ArrayList;
import us.zoom.androidlib.app.ForegroundTask;
import us.zoom.androidlib.app.ZMActivity;

public class ForegroundTaskManager {
    private static final String TAG = "ForegroundTaskManager";
    private static ForegroundTaskManager instance = null;
    private ArrayList<ForegroundTask> mTaskQueue = new ArrayList();
    private Handler mHandler = new Handler();

    public static synchronized ForegroundTaskManager getInstance() {
        if (instance == null) {
            instance = new ForegroundTaskManager();
        }
        return instance;
    }

    private ForegroundTaskManager() {
    }

    public void runInForeground(final ForegroundTask task) {
        if (task == null) {
            return;
        }
        final ZMActivity _frontActivity = ZMActivity.getFrontActivity();
        if (!(_frontActivity != null && _frontActivity.isActive() && !_frontActivity.isFinishing() && task.isValidActivity(_frontActivity.getClass().getName()) || task.isOtherProcessSupported() && task.hasAnotherProcessAtFront())) {
            if (!task.isMultipleInstancesAllowed()) {
                this.updateTask(task);
            } else {
                this.mTaskQueue.add(task);
            }
            return;
        }
        if (task.isOtherProcessSupported() && task.hasAnotherProcessAtFront()) {
            this.executeTask(task, null);
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ZMActivity curFrontActivity = ZMActivity.getFrontActivity();
                if (_frontActivity == curFrontActivity && _frontActivity.isActive() && !_frontActivity.isFinishing()) {
                    if (task.isExpired()) {
                        return;
                    }
                    ForegroundTaskManager.this.executeTask(task, _frontActivity);
                }
                ForegroundTaskManager.this.mTaskQueue.add(task);
            }
        });
    }

    public void removeTask(ForegroundTask task) {
        this.mTaskQueue.remove(task);
    }

    protected void onActivityMoveToFront(ZMActivity activity) {
        if (this.mTaskQueue.isEmpty()) {
            return;
        }
        this.runQueuedTasks(activity);
    }

    public void onAnotherProcessMoveToFront(String activityClass) {
        if (this.mTaskQueue.isEmpty()) {
            return;
        }
        if (activityClass != null) {
            this.runQueuedTasksOnAnotherProcess(activityClass);
        }
    }

    private void runQueuedTasksOnAnotherProcess(String activityClass) {
        if (activityClass == null) {
            return;
        }
        ArrayList<ForegroundTask> skippedTaskQueue = new ArrayList<ForegroundTask>();
        while (!this.mTaskQueue.isEmpty()) {
            ForegroundTask task = this.mTaskQueue.remove(0);
            if (task.isExpired()) continue;
            if (!task.isOtherProcessSupported() || !task.isValidActivity(activityClass)) {
                skippedTaskQueue.add(task);
                continue;
            }
            this.executeTask(task, null);
        }
        this.mTaskQueue.addAll(skippedTaskQueue);
    }

    private void runQueuedTasks(ZMActivity activity) {
        if (activity == null) {
            return;
        }
        ArrayList<ForegroundTask> skippedTaskQueue = new ArrayList<ForegroundTask>();
        while (!this.mTaskQueue.isEmpty()) {
            ForegroundTask task = this.mTaskQueue.remove(0);
            if (task.isExpired()) continue;
            if (!task.isValidActivity(activity.getClass().getName())) {
                skippedTaskQueue.add(task);
                continue;
            }
            this.executeTask(task, activity);
        }
        this.mTaskQueue.addAll(skippedTaskQueue);
    }

    private void executeTask(ForegroundTask task, ZMActivity activity) {
        task.run(activity);
    }

    private void updateTask(ForegroundTask task) {
        if (task == null) {
            return;
        }
        for (ForegroundTask tk : this.mTaskQueue) {
            if (tk == null || tk.getName() == null || !tk.getName().equals(task.getName())) continue;
            this.mTaskQueue.remove(tk);
            break;
        }
        this.mTaskQueue.add(task);
    }
}

