/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import us.zoom.androidlib.R;

public class ZMMaterialActionButtonLayout
extends RelativeLayout
implements View.OnClickListener {
    TextView mTxtNeutral;
    TextView mTxtNegative;
    TextView mTxtPositive;
    private MaterialActionButtonCallBack mMaterialActionButtonCallBack;

    public ZMMaterialActionButtonLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    public ZMMaterialActionButtonLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public ZMMaterialActionButtonLayout(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    private void init(Context context, AttributeSet attrs, int style) {
        if (context == null || attrs == null) {
            return;
        }
        LayoutInflater.from((Context)context).inflate(R.layout.zm_material_action_button_layout, (ViewGroup)this, true);
        this.mTxtNeutral = (TextView)this.findViewById(R.id.txtNeutral);
        this.mTxtNegative = (TextView)this.findViewById(R.id.txtNegative);
        this.mTxtPositive = (TextView)this.findViewById(R.id.txtPositive);
        this.mTxtNeutral.setOnClickListener((View.OnClickListener)this);
        this.mTxtNegative.setOnClickListener((View.OnClickListener)this);
        this.mTxtPositive.setOnClickListener((View.OnClickListener)this);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ZMMaterialActionButtonLayout);
        if (a != null) {
            float textSize;
            Resources resources = this.getResources();
            this.mTxtNeutral.setTextColor(a.getColor(R.styleable.ZMMaterialActionButtonLayout_zm_text_color_neutral, resources.getColor(R.color.zm_white)));
            this.mTxtNegative.setTextColor(a.getColor(R.styleable.ZMMaterialActionButtonLayout_zm_text_color_negative, resources.getColor(R.color.zm_white)));
            this.mTxtPositive.setTextColor(a.getColor(R.styleable.ZMMaterialActionButtonLayout_zm_text_color_positive, resources.getColor(R.color.zm_white)));
            this.mTxtNeutral.setVisibility(a.getBoolean(R.styleable.ZMMaterialActionButtonLayout_zm_visible_neutral, false) ? 0 : 8);
            this.mTxtNegative.setVisibility(a.getBoolean(R.styleable.ZMMaterialActionButtonLayout_zm_visible_negative, true) ? 0 : 8);
            this.mTxtPositive.setVisibility(a.getBoolean(R.styleable.ZMMaterialActionButtonLayout_zm_visible_positive, true) ? 0 : 8);
            String text = a.getString(R.styleable.ZMMaterialActionButtonLayout_zm_text_neutral);
            if (text != null) {
                this.mTxtNeutral.setText((CharSequence)text);
            }
            if ((text = a.getString(R.styleable.ZMMaterialActionButtonLayout_zm_text_negative)) != null) {
                this.mTxtNegative.setText((CharSequence)text);
            }
            if ((text = a.getString(R.styleable.ZMMaterialActionButtonLayout_zm_text_positive)) != null) {
                this.mTxtPositive.setText((CharSequence)text);
            }
            if ((textSize = (float)a.getDimensionPixelSize(R.styleable.ZMMaterialActionButtonLayout_zm_text_size, -1)) > 0.0f) {
                this.mTxtNeutral.setTextSize(0, textSize);
                this.mTxtNegative.setTextSize(0, textSize);
                this.mTxtPositive.setTextSize(0, textSize);
            }
            a.recycle();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.txtNeutral) {
            if (this.mMaterialActionButtonCallBack != null) {
                this.mMaterialActionButtonCallBack.onClickNeutral();
            }
        } else if (id2 == R.id.txtNegative) {
            if (this.mMaterialActionButtonCallBack != null) {
                this.mMaterialActionButtonCallBack.onClickNegative();
            }
        } else if (id2 == R.id.txtPositive && this.mMaterialActionButtonCallBack != null) {
            this.mMaterialActionButtonCallBack.onClickPositive();
        }
    }

    public void setmMaterialActionButtonCallBack(MaterialActionButtonCallBack mMaterialActionButtonCallBack) {
        this.mMaterialActionButtonCallBack = mMaterialActionButtonCallBack;
    }

    public static interface MaterialActionButtonCallBack {
        public void onClickPositive();

        public void onClickNegative();

        public void onClickNeutral();
    }
}

