/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.android.hms.agent;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import com.huawei.android.hms.agent.common.ActivityMgr;
import com.huawei.android.hms.agent.common.ApiClientMgr;
import com.huawei.android.hms.agent.common.HMSAgentLog;
import com.huawei.android.hms.agent.common.IClientConnectCallback;
import com.huawei.android.hms.agent.common.INoProguard;
import com.huawei.android.hms.agent.common.handler.ConnectHandler;
import com.huawei.android.hms.agent.push.DeleteTokenApi;
import com.huawei.android.hms.agent.push.EnableReceiveNormalMsgApi;
import com.huawei.android.hms.agent.push.EnableReceiveNotifyMsgApi;
import com.huawei.android.hms.agent.push.GetPushStateApi;
import com.huawei.android.hms.agent.push.GetTokenApi;
import com.huawei.android.hms.agent.push.QueryAgreementApi;
import com.huawei.android.hms.agent.push.handler.DeleteTokenHandler;
import com.huawei.android.hms.agent.push.handler.EnableReceiveNormalMsgHandler;
import com.huawei.android.hms.agent.push.handler.EnableReceiveNotifyMsgHandler;
import com.huawei.android.hms.agent.push.handler.GetPushStateHandler;
import com.huawei.android.hms.agent.push.handler.GetTokenHandler;
import com.huawei.android.hms.agent.push.handler.QueryAgreementHandler;
import com.huawei.hms.api.HuaweiApiClient;

public final class HMSAgent
implements INoProguard {
    private static final String VER_020503001 = "020503001";
    private static final String VER_020600001 = "020600001";
    private static final String VER_020600200 = "020600200";
    private static final String VER_020600302 = "020600302";
    public static final String CURVER = "020600302";

    private HMSAgent() {
    }

    private static boolean checkSDKVersion(Context context) {
        long sdkMainVerL = 20603L;
        long agentMainVerL = Long.parseLong("020600302") / 1000L;
        if (sdkMainVerL != agentMainVerL) {
            String errMsg = "error: HMSAgent major version code (" + agentMainVerL + ") does not match HMSSDK major version code (" + sdkMainVerL + ")";
            HMSAgentLog.e(errMsg);
            Toast.makeText((Context)context, (CharSequence)errMsg, (int)1).show();
            return false;
        }
        return true;
    }

    public static boolean init(Activity activity) {
        return HMSAgent.init(null, activity);
    }

    public static boolean init(Application app) {
        return HMSAgent.init(app, null);
    }

    public static boolean init(Application app, Activity activity) {
        Application appTmp = app;
        Activity activityTmp = activity;
        if (appTmp == null && activityTmp == null) {
            HMSAgentLog.e("the param of method HMSAgent.init can not be null !!!");
            return false;
        }
        if (appTmp == null) {
            appTmp = activityTmp.getApplication();
        }
        if (appTmp == null) {
            HMSAgentLog.e("the param of method HMSAgent.init app can not be null !!!");
            return false;
        }
        if (activityTmp != null && activityTmp.isFinishing()) {
            activityTmp = null;
        }
        if (!HMSAgent.checkSDKVersion((Context)appTmp)) {
            return false;
        }
        HMSAgentLog.i("init HMSAgent 020600302 with hmssdkver 20603301");
        ActivityMgr.INST.init(appTmp, activityTmp);
        ApiClientMgr.INST.init(appTmp);
        return true;
    }

    public static void destroy() {
        HMSAgentLog.i("destroy HMSAgent");
        ActivityMgr.INST.release();
        ApiClientMgr.INST.release();
    }

    public static void connect(Activity activity, final ConnectHandler callback) {
        HMSAgentLog.i("start connect");
        ApiClientMgr.INST.connect(new IClientConnectCallback(){

            @Override
            public void onConnect(final int rst, HuaweiApiClient client) {
                if (callback != null) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onConnect(rst);
                        }
                    });
                }
            }
        }, true);
    }

    public static void checkUpdate(final Activity activity) {
        HMSAgentLog.i("start checkUpdate");
        ApiClientMgr.INST.connect(new IClientConnectCallback(){

            @Override
            public void onConnect(int rst, HuaweiApiClient client) {
                Activity activityCur = ActivityMgr.INST.getLastActivity();
                if (!(activityCur != null && client != null || activity != null && client != null)) {
                    HMSAgentLog.e("no activity to checkUpdate");
                }
            }
        }, true);
    }

    public static final class Push {
        public static void getToken(GetTokenHandler handler) {
            new GetTokenApi().getToken(handler);
        }

        public static void deleteToken(String token, DeleteTokenHandler handler) {
            new DeleteTokenApi().deleteToken(token, handler);
        }

        public static void getPushState(GetPushStateHandler handler) {
            new GetPushStateApi().getPushState(handler);
        }

        public static void enableReceiveNotifyMsg(boolean enable, EnableReceiveNotifyMsgHandler handler) {
            new EnableReceiveNotifyMsgApi().enableReceiveNotifyMsg(enable, handler);
        }

        public static void enableReceiveNormalMsg(boolean enable, EnableReceiveNormalMsgHandler handler) {
            new EnableReceiveNormalMsgApi().enableReceiveNormalMsg(enable, handler);
        }

        public static void queryAgreement(QueryAgreementHandler handler) {
            new QueryAgreementApi().queryAgreement(handler);
        }
    }

    public static final class AgentResultCode {
        public static final int HMSAGENT_SUCCESS = 0;
        public static final int HMSAGENT_NO_INIT = -1000;
        public static final int NO_ACTIVITY_FOR_USE = -1001;
        public static final int RESULT_IS_NULL = -1002;
        public static final int STATUS_IS_NULL = -1003;
        public static final int START_ACTIVITY_ERROR = -1004;
        public static final int ON_ACTIVITY_RESULT_ERROR = -1005;
        public static final int REQUEST_REPEATED = -1006;
        public static final int APICLIENT_TIMEOUT = -1007;
        public static final int CALL_EXCEPTION = -1008;
        public static final int EMPTY_PARAM = -1009;
    }
}

