package com.arcsoft.face;

/**
 * 人脸信息类
 */
public class FaceFeatureInfo {

    /**
     * 唯一标识符
     */
    private int searchId;

    /**
     * 人脸特征值
     */
    private byte[] featureData;

    /**
     * 备注
     */
    private String faceTag;

    /**
     *  获取唯一标识符
     * @return 唯一标识符
     */
    public int getSearchId() {
        return searchId;
    }

    /**
     * 设置唯一标识符
     * @param searchId 唯一标识符
     * @return 人脸信息
     */
    public FaceFeatureInfo setSearchId(int searchId) {
        this.searchId = searchId;
        return this;
    }

    /**
     * 获取人脸特征值
     * @return 人脸特征值
     */
    public byte[] getFeatureData() {
        return featureData;
    }

    /**
     * 设置人脸特征值
     * @param featureData 人脸特征值
     * @return 人脸信息
     */
    public FaceFeatureInfo setFeatureData(byte[] featureData) {
        this.featureData = featureData;
        return this;
    }

    /**
     * 获取备注
     * @return 备注
     */
    public String getFaceTag() {
        return faceTag;
    }

    /**
     *
     * @param faceTag
     * @return 人脸信息
     */
    public FaceFeatureInfo setFaceTag(String faceTag) {
        this.faceTag = faceTag;
        return this;
    }
}
